/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class CSGeometryFactory
extends GeometryFactory {
    public static GeometryFactory DEFAULT = new GeometryFactory();
    public static PrecisionModel DEFAULT_PRECISON_MODEL = new PrecisionModel();

    public CSGeometryFactory(CoordinateReferenceSystem cs) {
        super(CSGeometryFactory.toPrecisionModel(cs), CSGeometryFactory.toSRID(cs));
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometries) {
        GeometryCollection gc = super.createGeometryCollection(geometries);
        return gc;
    }

    public LinearRing createLinearRing(Coordinate[] coordinates) {
        LinearRing lr = super.createLinearRing(coordinates);
        return lr;
    }

    private static int toSRID(CoordinateReferenceSystem cs) {
        if (cs == null || cs == DefaultGeocentricCRS.CARTESIAN) {
            return 0;
        }
        return 0;
    }

    private static PrecisionModel toPrecisionModel(CoordinateReferenceSystem cs) {
        if (cs == null || cs == DefaultGeocentricCRS.CARTESIAN) {
            return DEFAULT_PRECISON_MODEL;
        }
        return DEFAULT_PRECISON_MODEL;
    }
}

