/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.geotools.data.collection.ResourceCollection;
import org.geotools.data.collection.ResourceList;
import org.geotools.feature.collection.AbstractResourceCollection;
import org.geotools.feature.collection.SubList;

public abstract class AbstractResourceList
extends AbstractResourceCollection
implements ResourceList {
    protected transient int modCount = 0;

    protected AbstractResourceList() {
    }

    public boolean add(Object item) {
        this.add(this.size(), item);
        return true;
    }

    public abstract Object get(int var1);

    public Object set(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        ListIterator e = this.listIterator();
        try {
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    int n = e.previousIndex();
                    return n;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    int n = e.previousIndex();
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        ListIterator e = this.listIterator(this.size());
        try {
            if (o == null) {
                while (e.hasPrevious()) {
                    if (e.previous() != null) continue;
                    int n = e.nextIndex();
                    return n;
                }
            } else {
                while (e.hasPrevious()) {
                    if (!o.equals(e.previous())) continue;
                    int n = e.nextIndex();
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            this.close(e);
        }
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        boolean modified = false;
        Iterator e = c.iterator();
        try {
            while (e.hasNext()) {
                this.add(index++, e.next());
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            if (c instanceof ResourceCollection) {
                ((ResourceCollection)c).close(e);
            }
        }
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        ListIterator iterator = this.openIterator(index);
        this.open.add(iterator);
        return iterator;
    }

    public ListIterator openIterator(int index) {
        return new ListItr(index);
    }

    protected Iterator openIterator() {
        return new ListItr(0);
    }

    protected void closeIterator(Iterator close) {
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object o) {
        boolean bl;
        ListIterator e2;
        ListIterator e1;
        block6: {
            boolean bl2;
            block5: {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof List)) {
                    return false;
                }
                e1 = this.listIterator();
                e2 = ((List)o).listIterator();
                try {
                    while (e1.hasNext() && e2.hasNext()) {
                        Object o1 = e1.next();
                        Object o2 = e2.next();
                        if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                        bl2 = false;
                        Object var8_8 = null;
                        break block5;
                    }
                    bl = !e1.hasNext() && !e2.hasNext();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.close(e1);
                    if (!(o instanceof ResourceCollection)) throw throwable;
                    ((ResourceCollection)o).close(e2);
                    throw throwable;
                }
            }
            this.close(e1);
            if (!(o instanceof ResourceCollection)) return bl2;
            ((ResourceCollection)o).close(e2);
            return bl2;
        }
        Object var8_9 = null;
        this.close(e1);
        if (!(o instanceof ResourceCollection)) return bl;
        ((ResourceCollection)o).close(e2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int hashCode = 1;
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                Object obj = i.next();
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            int n = hashCode;
            return n;
        }
        finally {
            this.close(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(int fromIndex, int toIndex) {
        ListIterator it = this.listIterator(fromIndex);
        try {
            int n = toIndex - fromIndex;
            for (int i = 0; i < n; ++i) {
                it.next();
                it.remove();
            }
        }
        finally {
            this.close(it);
        }
    }

    private class ListItr
    implements ListIterator {
        int index = 0;
        int lastRet = -1;
        int expectedModCount;

        ListItr(int index) {
            this.expectedModCount = AbstractResourceList.this.modCount;
            this.index = index;
        }

        final void checkForComodification() {
            if (AbstractResourceList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            return this.index != AbstractResourceList.this.size();
        }

        public Object next() {
            this.checkForComodification();
            try {
                Object next = AbstractResourceList.this.get(this.index);
                this.lastRet = this.index++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractResourceList.this.remove(this.lastRet);
                if (this.lastRet < this.index) {
                    --this.index;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractResourceList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasPrevious() {
            return this.index != 0;
        }

        public Object previous() {
            this.checkForComodification();
            try {
                int i = this.index - 1;
                Object previous = AbstractResourceList.this.get(i);
                this.lastRet = this.index = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractResourceList.this.set(this.lastRet, o);
                this.expectedModCount = AbstractResourceList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o) {
            this.checkForComodification();
            try {
                AbstractResourceList.this.add(this.index++, o);
                this.lastRet = -1;
                this.expectedModCount = AbstractResourceList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

