/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureList;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.AbstractResourceList;
import org.geotools.feature.collection.FeatureState;
import org.geotools.feature.collection.SubFeatureState;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public abstract class AbstractFeatureList
extends AbstractResourceList
implements FeatureList {
    FeatureState state;

    protected AbstractFeatureList(FeatureState state) {
        this.state = state;
    }

    protected AbstractFeatureList(FeatureCollection collection) {
        this.state = new SubFeatureState(collection, (FeatureCollection)this);
    }

    public FeatureCollection getParent() {
        return this.state.getParent();
    }

    public void setParent(FeatureCollection collection) {
        this.state.setParent(collection);
    }

    public FeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public String getID() {
        return this.state.getId();
    }

    public Object[] getAttributes(Object[] attributes) {
        return this.state.getAttributes(attributes);
    }

    public Object getAttribute(String xPath) {
        return this.state.getAttribute(xPath);
    }

    public Object getAttribute(int index) {
        return this.state.getAttribute(index);
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        this.state.setAttribute(position, val);
    }

    public int getNumberOfAttributes() {
        return this.state.getNumberOfAttributes();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        this.state.setAttribute(xPath, attribute);
    }

    public Geometry getDefaultGeometry() {
        return this.state.getDefaultGeometry();
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        this.state.setDefaultGeometry(geometry);
    }

    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference((Envelope)this.state.getBounds());
    }

    public void addListener(CollectionListener listener) {
        this.state.addListener(listener);
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.state.removeListener(listener);
    }

    public FeatureIterator features() {
        return null;
    }

    public void close(FeatureIterator close) {
    }

    public FeatureType getSchema() {
        return null;
    }

    public void accepts(FeatureVisitor visitor) throws IOException {
    }

    public FeatureList subList(Filter filter) {
        return null;
    }

    public FeatureCollection subCollection(Filter filter) {
        return null;
    }

    public FeatureList sort(SortBy order) {
        return null;
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public int getCount() throws IOException {
        return this.size();
    }

    public FeatureCollection collection() throws IOException {
        return this;
    }
}

