/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Iterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureList;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.AbstractResourceCollection;
import org.geotools.feature.collection.BaseFeatureState;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.collection.FeatureState;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.ProgressListener;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public abstract class AbstractFeatureCollection
extends AbstractResourceCollection
implements FeatureCollection {
    FeatureState state;

    protected AbstractFeatureCollection(FeatureState state) {
        this.state = state;
    }

    public AbstractFeatureCollection(FeatureType schema) {
        this.state = new BaseFeatureState(this, schema);
    }

    public FeatureCollection getParent() {
        return this.state.getParent();
    }

    public void setParent(FeatureCollection collection) {
        this.state.setParent(collection);
    }

    public FeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public String getID() {
        return this.state.getId();
    }

    public Object[] getAttributes(Object[] attributes) {
        return this.state.getAttributes(attributes);
    }

    public Object getAttribute(String xPath) {
        return this.state.getAttribute(xPath);
    }

    public Object getAttribute(int index) {
        return this.state.getAttribute(index);
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        this.state.setAttribute(position, val);
    }

    public int getNumberOfAttributes() {
        return this.state.getNumberOfAttributes();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        this.state.setAttribute(xPath, attribute);
    }

    public Geometry getDefaultGeometry() {
        return this.state.getDefaultGeometry();
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        this.state.setDefaultGeometry(geometry);
    }

    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference((Envelope)this.state.getBounds());
    }

    public FeatureType getSchema() {
        return this.state.getChildFeatureType();
    }

    public void addListener(CollectionListener listener) {
        this.state.addListener(listener);
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.state.removeListener(listener);
    }

    public FeatureIterator features() {
        DelegateFeatureIterator iter = new DelegateFeatureIterator(this, this.openIterator());
        this.open.add(iter);
        return iter;
    }

    public void close(FeatureIterator close) {
        this.closeIterator(close);
        this.open.remove(close);
    }

    public void closeIterator(FeatureIterator close) {
        DelegateFeatureIterator iter = (DelegateFeatureIterator)close;
        this.closeIterator(iter.delegate);
        iter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Iterator i = this.open.iterator();
        while (i.hasNext()) {
            Object resource = i.next();
            if (!(resource instanceof FeatureIterator)) continue;
            FeatureIterator resourceIterator = (FeatureIterator)resource;
            try {
                this.closeIterator(resourceIterator);
            }
            catch (Throwable e) {}
            continue;
            finally {
                i.remove();
            }
        }
        super.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        Iterator iterator = null;
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                if (size > 0.0f) {
                    float f = position;
                    position = f + 1.0f;
                    progress.progress(f / size);
                }
                try {
                    Feature feature = (Feature)iterator.next();
                    visitor.visit(feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
            }
        }
        catch (Throwable throwable) {
            progress.complete();
            this.close(iterator);
            throw throwable;
        }
        progress.complete();
        this.close(iterator);
    }

    public FeatureList subList(Filter filter) {
        return new SubFeatureList((FeatureCollection)this, filter);
    }

    public FeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public FeatureList sort(SortBy order) {
        return new SubFeatureList((FeatureCollection)this, order);
    }
}

