/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeature;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;

public class DefaultFeatureType
implements FeatureType {
    private final String typeName;
    private final URI namespace;
    private final AttributeType[] types;
    private final FeatureType[] ancestors;
    private final GeometryAttributeType defaultGeom;
    private final int hashCode;
    final int defaultGeomIdx;
    public static final FeatureType EMPTY = new DefaultFeatureType();
    private final Map attLookup;

    private static final URI toURI(String namespace) throws SchemaException {
        try {
            return new URI(namespace);
        }
        catch (URISyntaxException badNamespace) {
            throw new SchemaException((Throwable)badNamespace);
        }
    }

    public DefaultFeatureType(String typeName, String namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws SchemaException, NullPointerException {
        this(typeName, DefaultFeatureType.toURI(namespace), types, superTypes, defaultGeom);
    }

    public DefaultFeatureType(String typeName, URI namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws NullPointerException {
        int i;
        if (typeName == null) {
            throw new NullPointerException(typeName);
        }
        this.typeName = typeName;
        this.namespace = namespace == null ? FeatureTypes.DEFAULT_NAMESPACE : namespace;
        this.ancestors = superTypes.toArray(new FeatureType[superTypes.size()]);
        ArrayList<AttributeType> attributes = new ArrayList<AttributeType>(types);
        int ii = this.ancestors.length;
        for (i = 0; i < ii; ++i) {
            FeatureType ancestor = this.ancestors[i];
            int jj = ancestor.getAttributeCount();
            for (int j = 0; j < jj; ++j) {
                attributes.add(ancestor.getAttributeType(j));
            }
        }
        this.types = attributes.size() != 0 ? attributes.toArray(new AttributeType[attributes.size()]) : new AttributeType[0];
        this.defaultGeom = defaultGeom;
        this.attLookup = new HashMap(this.types.length);
        ii = this.types.length;
        for (i = 0; i < ii; ++i) {
            this.attLookup.put(this.types[i].getName(), new Integer(i));
        }
        this.defaultGeomIdx = this.find((AttributeType)defaultGeom);
        this.hashCode = this.computeHash();
    }

    private DefaultFeatureType() {
        this.typeName = "emptyFeatureType";
        this.namespace = FeatureTypes.DEFAULT_NAMESPACE;
        this.types = new AttributeType[0];
        this.ancestors = new FeatureType[0];
        this.defaultGeomIdx = -1;
        this.defaultGeom = null;
        this.hashCode = this.computeHash();
        this.attLookup = Collections.EMPTY_MAP;
    }

    public Feature create(Object[] attributes) throws IllegalAttributeException {
        return this.create(attributes, null);
    }

    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        return new DefaultFeature(this, attributes, featureID);
    }

    public Feature duplicate(Feature original) throws IllegalAttributeException {
        if (original == null) {
            return null;
        }
        FeatureType featureType = original.getFeatureType();
        if (!featureType.equals(this)) {
            throw new IllegalAttributeException("Feature type " + featureType + " does not match " + this);
        }
        String id = original.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeType curAttType = this.getAttributeType(i);
            attributes[i] = curAttType.duplicate(original.getAttribute(i));
        }
        return featureType.create(attributes, id);
    }

    public final GeometryAttributeType getDefaultGeometry() {
        return this.getPrimaryGeometry();
    }

    public GeometryAttributeType getPrimaryGeometry() {
        return this.defaultGeom;
    }

    public AttributeType getAttributeType(String xPath) {
        AttributeType attType = null;
        int idx = this.find(xPath);
        if (idx >= 0) {
            attType = this.types[idx];
        }
        return attType;
    }

    public int find(AttributeType type) {
        if (type == null) {
            return -1;
        }
        int idx = this.find(type.getName());
        if (idx < 0 || !this.types[idx].equals(type)) {
            idx = -1;
        }
        return idx;
    }

    public int find(String attName) {
        Integer idx = (Integer)this.attLookup.get(attName);
        return idx == null ? -1 : idx;
    }

    public AttributeType getAttributeType(int position) {
        return this.types[position];
    }

    public AttributeType[] getAttributeTypes() {
        return (AttributeType[])this.types.clone();
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    public int getAttributeCount() {
        return this.types.length;
    }

    public boolean equals(FeatureType other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.typeName == null && other.getTypeName() != null) {
            return false;
        }
        if (!this.typeName.equals(other.getTypeName())) {
            return false;
        }
        if (this.namespace == null && other.getNamespace() != null) {
            return false;
        }
        if (!this.namespace.equals(other.getNamespace())) {
            return false;
        }
        if (this.types.length != other.getAttributeCount()) {
            return false;
        }
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            if (this.types[i].equals(other.getAttributeType(i))) continue;
            return false;
        }
        return true;
    }

    private int computeHash() {
        int hash = this.typeName.hashCode() ^ this.namespace.hashCode();
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            hash ^= this.types[i].hashCode();
        }
        return hash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String info = "name=" + this.typeName;
        info = info + " , namespace=" + this.namespace;
        info = info + " , abstract=" + this.isAbstract();
        String types1 = "types=(";
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            types1 = types1 + this.types[i].toString();
            if (i >= ii) continue;
            types1 = types1 + ",";
        }
        types1 = types1 + ")";
        info = info + " , " + types1;
        return "DefaultFeatureType [" + info + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof FeatureType) {
            return this.equals((FeatureType)other);
        }
        return false;
    }

    public FeatureType[] getAncestors() {
        return this.ancestors;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isDescendedFrom(FeatureType type) {
        return this.isDescendedFrom(type.getNamespace(), type.getTypeName());
    }

    public boolean isDescendedFrom(URI nsURI, String typeName1) {
        int ii = this.ancestors.length;
        for (int i = 0; i < ii; ++i) {
            if (nsURI != null && !this.ancestors[i].getNamespace().equals(nsURI) || !this.ancestors[i].getTypeName().equals(typeName1)) continue;
            return true;
        }
        return false;
    }

    static final class Abstract
    extends DefaultFeatureType {
        public Abstract(String typeName, URI namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws SchemaException {
            super(typeName, namespace, types, superTypes, defaultGeom);
            Iterator st = superTypes.iterator();
            while (st.hasNext()) {
                FeatureType ft = (FeatureType)st.next();
                if (ft.isAbstract()) continue;
                throw new SchemaException("Abstract type cannot descend from no abstract type : " + ft);
            }
        }

        public final boolean isAbstract() {
            return true;
        }

        public Feature create(Object[] atts) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Abstract Type");
        }

        public Feature create(Object[] atts, String id) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Abstract Type");
        }
    }
}

