/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.event.AbstractGTComponent;
import org.geotools.event.GTComponent;
import org.geotools.event.GTDelta;
import org.geotools.event.GTDeltaImpl;
import org.geotools.event.GTEvent;
import org.geotools.event.GTEventImpl;
import org.geotools.event.GTListener;
import org.geotools.event.GTNote;
import org.geotools.event.GTNoteImpl;
import org.geotools.event.GTRoot;
import org.geotools.util.logging.Logging;

public abstract class AbstractGTRoot
extends AbstractGTComponent
implements GTRoot {
    private static final Logger LOGGER;
    GTNote notification = new GTNoteImpl((GTComponent)GTRoot.NO_PARENT, "", -1);
    private HashSet listeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Object clone() throws CloneNotSupportedException {
        AbstractGTRoot copy = (AbstractGTRoot)super.clone();
        copy.notification = new GTNoteImpl((GTComponent)GTRoot.NO_PARENT, "", -1);
        return copy;
    }

    public void removed(GTDelta childDelta) {
        GTDeltaImpl delta = new GTDeltaImpl(this.notification, GTDelta.Kind.NO_CHANGE, (Object)this, null, childDelta);
        this.notification.getParent().removed((GTDelta)delta);
    }

    public void changed(GTDelta childDelta) {
        GTDeltaImpl delta = new GTDeltaImpl(this.notification, GTDelta.Kind.NO_CHANGE, (Object)this, null, childDelta);
        this.notification.getParent().removed((GTDelta)delta);
    }

    protected void fireChanged() {
        GTDeltaImpl delta = new GTDeltaImpl(this.notification, GTDelta.Kind.CHANGED, this, null);
        this.notification.getParent().changed((GTDelta)delta);
    }

    protected final void fireChildChanged(String childName, Object child, Object oldValue) {
        if (child == null) {
            this.fireChanged();
        } else {
            GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(childName, -1), GTDelta.Kind.CHANGED, child);
            delta = new GTDeltaImpl(this.notification, GTDelta.Kind.NO_CHANGE, this);
            this.notification.getParent().changed((GTDelta)delta);
        }
    }

    public synchronized void addListener(GTListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(GTListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fire(GTEvent event) {
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError();
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            GTListener listener = (GTListener)i.next();
            try {
                listener.changed(event);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "GTListener encountered a serious problem", t);
            }
        }
    }

    protected synchronized void fire(GTDelta delta) {
        if (!this.hasListeners()) {
            return;
        }
        GTEventImpl event = new GTEventImpl(this, GTEvent.Type.POST_CHANGE, delta);
        this.fire(event);
    }

    protected boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    static {
        $assertionsDisabled = !AbstractGTRoot.class.desiredAssertionStatus();
        LOGGER = Logging.getLogger("org.geotools.event");
    }
}

