/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.ReprojectingIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureList;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.ProgressListener;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ReprojectingFeatureCollection
implements FeatureCollection {
    FeatureCollection delegate;
    MathTransform transform;
    FeatureType schema;
    FeatureType featureType;
    CoordinateReferenceSystem target;
    GeometryCoordinateSequenceTransformer transformer;

    public ReprojectingFeatureCollection(FeatureCollection delegate, CoordinateReferenceSystem target) {
        this(delegate, delegate.getSchema().getDefaultGeometry().getCoordinateSystem(), target);
    }

    public ReprojectingFeatureCollection(FeatureCollection delegate, CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        this.delegate = delegate;
        this.target = target;
        FeatureType schema = delegate.getSchema();
        this.schema = this.reType(schema, target);
        FeatureType featureType = delegate.getFeatureType();
        this.featureType = this.reType(featureType, target);
        if (source == null) {
            throw new NullPointerException("source crs");
        }
        if (target == null) {
            throw new NullPointerException("destination crs");
        }
        this.transform = this.transform(source, target);
        this.transformer = new GeometryCoordinateSequenceTransformer();
    }

    public void setTransformer(GeometryCoordinateSequenceTransformer transformer) {
        this.transformer = transformer;
    }

    private MathTransform transform(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        try {
            return CRS.findMathTransform(source, target);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Could not create math transform");
        }
    }

    private FeatureType reType(FeatureType type, CoordinateReferenceSystem target) {
        try {
            return FeatureTypes.transform(type, target);
        }
        catch (SchemaException e) {
            throw new IllegalArgumentException("Could not transform source schema");
        }
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public FeatureIterator features() {
        return new DelegateFeatureIterator(this, this.iterator());
    }

    public void close(FeatureIterator close) {
        close.close();
    }

    public Iterator iterator() {
        try {
            return new ReprojectingIterator(this.delegate.iterator(), this.transform, this.schema, this.transformer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close(Iterator close) {
        Iterator iterator = ((ReprojectingIterator)close).getDelegate();
        this.delegate.close(iterator);
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        this.delegate.addListener(listener);
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.delegate.removeListener(listener);
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.delegate.accepts(visitor, progress);
    }

    public FeatureCollection subCollection(Filter filter) {
        Filter unFilter = this.unFilter(filter);
        return new ReprojectingFeatureCollection(this.delegate.subCollection(unFilter), this.target);
    }

    private Filter unFilter(Filter filter) {
        return filter;
    }

    public FeatureList sort(SortBy order) {
        throw new UnsupportedOperationException("Not yet");
    }

    public void purge() {
        this.delegate.purge();
    }

    public int size() {
        return this.delegate.size();
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        ArrayList list = new ArrayList();
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close(i);
        }
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Not yet");
    }

    public boolean contains(Object o) {
        return this.delegate.add(o);
    }

    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    public boolean addAll(Collection c) {
        return this.delegate.addAll(c);
    }

    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.delegate.retainAll(c);
    }

    public String getID() {
        return this.delegate.getID();
    }

    public Object[] getAttributes(Object[] attributes) {
        return this.delegate.getAttributes(attributes);
    }

    public Object getAttribute(String xPath) {
        return this.delegate.getAttribute(xPath);
    }

    public Object getAttribute(int index) {
        return this.delegate.getAttribute(index);
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        this.delegate.setAttribute(position, val);
    }

    public int getNumberOfAttributes() {
        return this.delegate.getNumberOfAttributes();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        this.delegate.setAttribute(xPath, attribute);
    }

    public Geometry getDefaultGeometry() {
        return this.delegate.getDefaultGeometry();
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        this.delegate.setDefaultGeometry(geometry);
    }

    public ReferencedEnvelope getBounds() {
        FeatureIterator r = this.features();
        try {
            Envelope newBBox = new Envelope();
            while (r.hasNext()) {
                Feature feature = r.next();
                Geometry geom = feature.getDefaultGeometry();
                if (geom == null) continue;
                Envelope internal = geom.getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((Envelope)newBBox);
            return referencedEnvelope;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while computing reprojected bounds", e);
        }
        finally {
            r.close();
        }
    }
}

