/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.ReTypingIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureList;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.ProgressListener;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class ReTypingFeatureCollection
implements FeatureCollection {
    FeatureCollection delegate;
    FeatureType featureType;

    public ReTypingFeatureCollection(FeatureCollection delegate, FeatureType featureType) {
        this.delegate = delegate;
        this.featureType = featureType;
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public FeatureIterator features() {
        return new DelegateFeatureIterator(this, this.iterator());
    }

    public void close(FeatureIterator close) {
        close.close();
    }

    public Iterator iterator() {
        return new ReTypingIterator(this.delegate.iterator(), this.delegate.getSchema(), this.featureType);
    }

    public void close(Iterator close) {
        ReTypingIterator reType = (ReTypingIterator)close;
        this.delegate.close(reType.getDelegate());
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        this.delegate.addListener(listener);
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.delegate.removeListener(listener);
    }

    public FeatureType getFeatureType() {
        return this.delegate.getFeatureType();
    }

    public FeatureType getSchema() {
        return this.featureType;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.delegate.accepts(visitor, progress);
    }

    public FeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FeatureList sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    public void purge() {
        this.delegate.purge();
    }

    public int size() {
        return this.delegate.size();
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        ArrayList list = new ArrayList();
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close(i);
        }
    }

    public boolean add(Object o) {
        return this.delegate.add(o);
    }

    public boolean contains(Object o) {
        return this.delegate.add(o);
    }

    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    public boolean addAll(Collection c) {
        return this.delegate.addAll(c);
    }

    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.delegate.retainAll(c);
    }

    public String getID() {
        return this.delegate.getID();
    }

    public Object[] getAttributes(Object[] attributes) {
        return this.delegate.getAttributes(attributes);
    }

    public Object getAttribute(String xPath) {
        return this.delegate.getAttribute(xPath);
    }

    public Object getAttribute(int index) {
        return this.delegate.getAttribute(index);
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        this.delegate.setAttribute(position, val);
    }

    public int getNumberOfAttributes() {
        return this.delegate.getNumberOfAttributes();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        this.delegate.setAttribute(xPath, attribute);
    }

    public Geometry getDefaultGeometry() {
        return this.delegate.getDefaultGeometry();
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        this.delegate.setDefaultGeometry(geometry);
    }

    public ReferencedEnvelope getBounds() {
        return this.delegate.getBounds();
    }
}

