/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.MaxFeaturesIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureList;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.ProgressListener;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class MaxFeaturesFeatureCollection
implements FeatureCollection {
    FeatureCollection delegate;
    long max;

    public MaxFeaturesFeatureCollection(FeatureCollection delegate, long max) {
        this.delegate = delegate;
        this.max = max;
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public FeatureIterator features() {
        return new DelegateFeatureIterator(this, this.iterator());
    }

    public void close(FeatureIterator close) {
        close.close();
    }

    public Iterator iterator() {
        return new MaxFeaturesIterator(this.delegate.iterator(), this.max);
    }

    public void close(Iterator close) {
        Iterator iterator = ((MaxFeaturesIterator)close).getDelegate();
        this.delegate.close(iterator);
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        this.delegate.addListener(listener);
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.delegate.removeListener(listener);
    }

    public FeatureType getFeatureType() {
        return this.delegate.getFeatureType();
    }

    public FeatureType getSchema() {
        return this.delegate.getSchema();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.delegate.accepts(visitor, progress);
    }

    public FeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FeatureList sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    public void purge() {
        this.delegate.purge();
    }

    public int size() {
        return (int)Math.min((long)this.delegate.size(), this.max);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty() || this.max == 0L;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        ArrayList list = new ArrayList();
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close(i);
        }
    }

    public boolean add(Object o) {
        long size = this.delegate.size();
        if (size < this.max) {
            return this.delegate.add(o);
        }
        return false;
    }

    public boolean contains(Object o) {
        return this.delegate.add(o);
    }

    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            changed |= this.add(i.next());
        }
        return changed;
    }

    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.delegate.retainAll(c);
    }

    public String getID() {
        return this.delegate.getID();
    }

    public Object[] getAttributes(Object[] attributes) {
        return this.delegate.getAttributes(attributes);
    }

    public Object getAttribute(String xPath) {
        return this.delegate.getAttribute(xPath);
    }

    public Object getAttribute(int index) {
        return this.delegate.getAttribute(index);
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        this.delegate.setAttribute(position, val);
    }

    public int getNumberOfAttributes() {
        return this.delegate.getNumberOfAttributes();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        this.delegate.setAttribute(xPath, attribute);
    }

    public Geometry getDefaultGeometry() {
        return this.delegate.getDefaultGeometry();
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        this.delegate.setDefaultGeometry(geometry);
    }

    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference((Envelope)DataUtilities.bounds(this));
    }
}

