/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataStore;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.TypeDiffState;
import org.geotools.data.store.TypeEntry;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

public abstract class ActiveTypeEntry
implements TypeEntry {
    protected static final Logger LOGGER = Logging.getLogger("org.geotools.data.store");
    protected DataStore parent;
    private final FeatureType schema;
    private final Map metadata;
    private FeatureListenerManager listeners = new FeatureListenerManager();
    int count;
    Envelope bounds;
    public FeatureListenerManager listenerManager = new FeatureListenerManager();

    public ActiveTypeEntry(DataStore parent, FeatureType schema, Map metadata) {
        this.schema = schema;
        this.metadata = metadata;
        this.parent = parent;
    }

    public InternationalString getDisplayName() {
        return new SimpleInternationalString(this.schema.getTypeName());
    }

    public InternationalString getDescription() {
        return null;
    }

    public FeatureType getFeatureType() {
        return this.schema;
    }

    public String[] getMetadataNames() {
        return this.metadata.keySet().toArray(new String[this.metadata.size()]);
    }

    public Map metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String getTypeName() {
        return this.schema.getTypeName();
    }

    public FeatureReader reader(Query query, Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("Transaction null, did you mean Transaction.AUTO_COMMIT");
        }
        FeatureCollection features = this.createFeatureSource().getFeatures(query);
        Object reader = new DelegateFeatureReader(features.getSchema(), features.features());
        if (!transaction.equals(Transaction.AUTO_COMMIT)) {
            reader = new DiffFeatureReader((FeatureReader)reader, this.state(transaction).diff());
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeDiffState state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TypeDiffState state = (TypeDiffState)transaction.getState((Object)this);
            if (state == null) {
                state = new TypeDiffState(this);
                transaction.putState((Object)this, (Transaction.State)state);
            }
            return state;
        }
    }

    public void fireAdded(Feature newFeature, Transaction transaction) {
        ReferencedEnvelope bounds = newFeature != null ? newFeature.getBounds() : null;
        this.listenerManager.fireFeaturesAdded(this.schema.getTypeName(), transaction, (Envelope)bounds, false);
    }

    public void fireRemoved(Feature removedFeature, Transaction transaction) {
        ReferencedEnvelope bounds = removedFeature != null ? removedFeature.getBounds() : null;
        this.listenerManager.fireFeaturesRemoved(this.schema.getTypeName(), transaction, (Envelope)bounds, false);
    }

    public void fireChanged(Feature before, Feature after, Transaction transaction) {
        String typeName = after.getFeatureType().getTypeName();
        Envelope bounds = new Envelope();
        bounds.expandToInclude((Envelope)before.getBounds());
        bounds.expandToInclude((Envelope)after.getBounds());
        this.listenerManager.fireFeaturesChanged(typeName, transaction, bounds, false);
    }

    public abstract FeatureSource createFeatureSource();

    protected FeatureSource createFeatureSource(final FeatureType featureType) {
        return new AbstractFeatureSource(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return featureType;
            }
        };
    }

    protected FeatureStore createFeatureStore() {
        return new AbstractFeatureStore(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return ActiveTypeEntry.this.schema;
            }
        };
    }

    protected FeatureLocking createFeatureLocking() {
        return new AbstractFeatureLocking(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return ActiveTypeEntry.this.schema;
            }
        };
    }

    public FeatureReader createReader() {
        return new EmptyFeatureReader(this.schema);
    }

    protected FeatureReader createReader(Query query) throws IOException {
        return this.createReader();
    }

    protected Filter getUnsupportedFilter(Filter filter) {
        return filter;
    }

    public FeatureWriter writer(Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        FeatureWriter writer = transaction == Transaction.AUTO_COMMIT ? this.createWriter() : this.state(transaction).writer();
        if (this.parent.getLockingManager() != null && this.parent.getLockingManager() instanceof InProcessLockingManager) {
            InProcessLockingManager lockingManger = (InProcessLockingManager)this.parent.getLockingManager();
            writer = lockingManger.checkedWriter(writer, transaction);
        }
        return writer;
    }

    protected FeatureWriter createWriter() {
        return new EmptyFeatureWriter(this.schema);
    }

    protected FeatureWriter createAppend(Transaction transaction) throws IOException {
        FeatureWriter writer = this.writer(transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }
}

