/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.InputStream;
import org.geotools.data.ows.ServiceExceptionParser;
import org.geotools.ows.ServiceException;
import org.jdom.JDOMException;

public abstract class Response {
    protected InputStream inputStream;
    protected String contentType;

    public Response(String contentType, InputStream inputStream) throws ServiceException, IOException {
        this.inputStream = inputStream;
        this.contentType = contentType;
        if (contentType.toLowerCase().equals("application/vnd.ogc.se_xml")) {
            throw this.parseException(inputStream);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected ServiceException parseException(InputStream inputStream) throws IOException {
        try {
            ServiceException serviceException = ServiceExceptionParser.parse(inputStream);
            return serviceException;
        }
        catch (JDOMException e) {
            throw (IOException)new IOException().initCause(e);
        }
        finally {
            inputStream.close();
        }
    }
}

