/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.geotools.data.ows.Capabilities;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesResponse;
import org.geotools.data.ows.Request;
import org.geotools.data.ows.Response;
import org.geotools.data.ows.Specification;
import org.geotools.ows.ServiceException;
import org.geotools.util.logging.Logging;

public abstract class AbstractOpenWebService {
    protected final URL serverURL;
    protected Capabilities capabilities;
    protected Specification[] specs;
    protected Specification specification;
    private static final Logger LOGGER = Logging.getLogger("org.geotools.data.ows");

    public AbstractOpenWebService(URL serverURL) throws IOException, ServiceException {
        if (serverURL == null) {
            throw new NullPointerException("ServerURL cannot be null");
        }
        this.serverURL = serverURL;
        this.setupSpecifications();
        this.capabilities = this.negotiateVersion();
        if (this.capabilities == null) {
            throw new ServiceException("Unable to retrieve or parse Capabilities document.");
        }
    }

    public AbstractOpenWebService(Capabilities capabilties, URL serverURL) {
        if (capabilties == null) {
            throw new NullPointerException("Capabilities cannot be null.");
        }
        if (serverURL == null) {
            throw new NullPointerException("ServerURL cannot be null");
        }
        this.setupSpecifications();
        for (int i = 0; i < this.specs.length; ++i) {
            if (!this.specs[i].getVersion().equals(capabilties.getVersion())) continue;
            this.specification = this.specs[i];
            break;
        }
        if (this.specification == null) {
            this.specification = this.specs[this.specs.length - 1];
            LOGGER.warning("Unable to choose a specification based on cached capabilities. Arbitrarily choosing spec '" + this.specification.getVersion() + "'.");
        }
        this.serverURL = serverURL;
        this.capabilities = capabilties;
    }

    protected abstract void setupSpecifications();

    protected Capabilities negotiateVersion() throws IOException, ServiceException {
        int maxClient;
        ArrayList<String> versions = new ArrayList<String>(this.specs.length);
        Throwable exception = null;
        for (int i = 0; i < this.specs.length; ++i) {
            versions.add(i, this.specs[i].getVersion());
        }
        int minClient = 0;
        int test = maxClient = this.specs.length - 1;
        while (minClient <= test && test <= maxClient) {
            Capabilities tempCapabilities;
            Specification tempSpecification = this.specs[test];
            String clientVersion = tempSpecification.getVersion();
            GetCapabilitiesRequest request = tempSpecification.createGetCapabilitiesRequest(this.serverURL);
            try {
                tempCapabilities = this.issueRequest(request).getCapabilities();
            }
            catch (ServiceException e) {
                tempCapabilities = null;
                exception = e;
            }
            int compare = -1;
            String serverVersion = clientVersion;
            if (tempCapabilities != null) {
                serverVersion = tempCapabilities.getVersion();
                compare = serverVersion.compareTo(clientVersion);
            }
            if (compare == 0) {
                this.specification = tempSpecification;
                return tempCapabilities;
            }
            if (tempCapabilities != null && versions.contains(serverVersion)) {
                int index = versions.indexOf(serverVersion);
                this.specification = this.specs[index];
                return tempCapabilities;
            }
            if (compare < 0) {
                maxClient = test - 1;
                clientVersion = this.before(versions, serverVersion);
                if (clientVersion == null) {
                    if (exception != null) {
                        if (exception instanceof ServiceException) {
                            throw (ServiceException)exception;
                        }
                        IOException e = new IOException(exception.getMessage());
                        throw e;
                    }
                    return null;
                }
                test = versions.indexOf(clientVersion);
                continue;
            }
            minClient = test + 1;
            clientVersion = this.after(versions, serverVersion);
            if (clientVersion == null) {
                if (exception != null) {
                    if (exception instanceof ServiceException) {
                        throw (ServiceException)exception;
                    }
                    IOException e = new IOException(exception.getMessage());
                    throw e;
                }
                return null;
            }
            test = versions.indexOf(clientVersion);
        }
        if (exception != null) {
            IOException e = new IOException(exception.getMessage());
            throw e;
        }
        return null;
    }

    String before(List known, String version) {
        if (known.isEmpty()) {
            return null;
        }
        String before = null;
        Iterator i = known.iterator();
        while (i.hasNext()) {
            String test = (String)i.next();
            if (test.compareTo(version) >= 0 || before != null && before.compareTo(test) >= 0) continue;
            before = test;
        }
        return before;
    }

    String after(List known, String version) {
        if (known.isEmpty()) {
            return null;
        }
        String after = null;
        Iterator i = known.iterator();
        while (i.hasNext()) {
            String test = (String)i.next();
            if (test.compareTo(version) <= 0 || after != null && after.compareTo(test) >= 0) continue;
            after = test;
        }
        return after;
    }

    protected Response internalIssueRequest(Request request) throws IOException, ServiceException {
        URL finalURL = request.getFinalURL();
        HttpURLConnection connection = (HttpURLConnection)finalURL.openConnection();
        connection.addRequestProperty("Accept-Encoding", "gzip");
        if (request.requiresPost()) {
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", request.getPostContentType());
            OutputStream outputStream = connection.getOutputStream();
            if (LOGGER.isLoggable(Level.FINE)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                request.performPostOutput(out);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                PrintStream stream = new PrintStream(outputStream);
                String postText = "";
                while (reader.ready()) {
                    String input = reader.readLine();
                    postText = postText + input;
                    stream.println(input);
                }
                LOGGER.fine(postText);
                System.out.println(postText);
                out.close();
                ((InputStream)in).close();
            } else {
                request.performPostOutput(outputStream);
            }
            outputStream.flush();
            outputStream.close();
        } else {
            connection.setRequestMethod("GET");
        }
        InputStream inputStream = connection.getInputStream();
        if (connection.getContentEncoding() != null && connection.getContentEncoding().indexOf("gzip") != -1) {
            inputStream = new GZIPInputStream(inputStream);
        }
        String contentType = connection.getContentType();
        return request.createResponse(contentType, inputStream);
    }

    public GetCapabilitiesResponse issueRequest(GetCapabilitiesRequest request) throws IOException, ServiceException {
        return (GetCapabilitiesResponse)this.internalIssueRequest(request);
    }

    public void setLoggingLevel(Level newLevel) {
        LOGGER.setLevel(newLevel);
    }
}

