/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.collection.RandomFeatureAccess;

public class MemoryFeatureCollection
extends AbstractFeatureCollection
implements RandomFeatureAccess {
    TreeMap contents = new TreeMap();

    public MemoryFeatureCollection(FeatureType schema) {
        super(schema);
    }

    public int size() {
        return this.contents.size();
    }

    protected Iterator openIterator() {
        return new MemoryIterator(this.contents.values().iterator());
    }

    protected void closeIterator(Iterator close) {
        if (close == null) {
            return;
        }
        MemoryIterator it = (MemoryIterator)close;
        it.close();
    }

    public boolean add(Object o) {
        Feature feature = (Feature)o;
        this.contents.put(feature.getID(), feature);
        return true;
    }

    public Feature getFeatureMember(String id) throws NoSuchElementException {
        if (this.contents.containsKey(id)) {
            return (Feature)this.contents.get(id);
        }
        throw new NoSuchElementException(id);
    }

    public Feature removeFeatureMember(String id) {
        if (this.contents.containsKey(id)) {
            Feature old = (Feature)this.contents.get(id);
            this.contents.remove(id);
            return old;
        }
        return null;
    }

    class MemoryIterator
    implements Iterator {
        Iterator it;

        MemoryIterator(Iterator iterator) {
            this.it = iterator;
        }

        public void close() {
            this.it = null;
        }

        public boolean hasNext() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            return this.it.hasNext();
        }

        public Object next() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            return this.it.next();
        }

        public void remove() {
            this.it.remove();
        }
    }
}

