/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.feature.type.TypeName;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.capability.FilterCapabilities;

public final class CollectionSource {
    private Collection collection;

    public CollectionSource(Collection collection) {
        this.collection = Collections.unmodifiableCollection(collection);
    }

    public Collection content() {
        return this.collection;
    }

    public Collection content(String query, String queryLanguage) {
        throw new UnsupportedOperationException("Please help me hook up the parser!");
    }

    public Collection content(Filter filter) {
        return this.content(filter, Integer.MAX_VALUE);
    }

    public Collection content(Filter filter, int countLimit) {
        ArrayList list = new ArrayList();
        int count = 0;
        Iterator i = this.collection.iterator();
        while (i.hasNext() && count < countLimit) {
            Object obj = i.next();
            if (!filter.evaluate(obj)) continue;
            list.add(obj);
            ++count;
        }
        return Collections.unmodifiableList(list);
    }

    public Object describe() {
        return Object.class;
    }

    public void dispose() {
        this.collection = null;
    }

    public FilterCapabilities getFilterCapabilities() {
        return null;
    }

    public Name getName() {
        return new TypeName("localhost/memory");
    }

    public void setTransaction(Transaction t) {
    }

    public GeoResourceInfo getInfo() {
        return null;
    }
}

