/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemIterator
implements Iterator {
    protected FeatureIterator reader;
    protected FeatureType schema;

    ForceCoordinateSystemIterator(FeatureIterator reader, FeatureType schema) {
        this.reader = reader;
        this.schema = schema;
    }

    public ForceCoordinateSystemIterator(FeatureIterator reader, FeatureType type, CoordinateReferenceSystem cs) throws SchemaException {
        if (cs == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem originalCs = type.getDefaultGeometry().getCoordinateSystem();
        if (cs.equals(originalCs)) {
            this.schema = FeatureTypes.transform(type, cs);
        }
        this.reader = reader;
    }

    public FeatureType getFeatureType() {
        if (this.reader == null || this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    public Object next() throws NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        Feature next = this.reader.next();
        if (this.schema == null) {
            return next;
        }
        try {
            return this.schema.create(next.getAttributes(null), next.getID());
        }
        catch (IllegalAttributeException eep) {
            throw (IllegalStateException)new IllegalStateException(eep.getMessage()).initCause(eep);
        }
    }

    public boolean hasNext() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

