/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.crs.ForceCoordinateSystemIterator;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureResults
extends AbstractFeatureCollection {
    FeatureCollection results;

    public ForceCoordinateSystemFeatureResults(FeatureCollection results, CoordinateReferenceSystem forcedCS) throws IOException, SchemaException {
        this(results, forcedCS, false);
    }

    public ForceCoordinateSystemFeatureResults(FeatureCollection results, CoordinateReferenceSystem forcedCS, boolean forceOnlyMissing) throws IOException, SchemaException {
        super(ForceCoordinateSystemFeatureResults.forceType(ForceCoordinateSystemFeatureResults.origionalType(results), forcedCS, forceOnlyMissing));
        this.results = results;
    }

    private static FeatureType origionalType(FeatureCollection results) {
        if (results instanceof ReprojectFeatureResults) {
            results = ((ReprojectFeatureResults)results).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            results = ((ForceCoordinateSystemFeatureResults)results).getOrigin();
        }
        return results.getSchema();
    }

    private static FeatureType forceType(FeatureType startingType, CoordinateReferenceSystem forcedCS, boolean forceOnlyMissing) throws SchemaException {
        CoordinateReferenceSystem originalCs;
        if (forcedCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem coordinateReferenceSystem = originalCs = startingType.getDefaultGeometry() != null ? startingType.getDefaultGeometry().getCoordinateSystem() : null;
        if (forcedCS.equals(originalCs)) {
            return startingType;
        }
        return FeatureTypes.transform(startingType, forcedCS, forceOnlyMissing);
    }

    protected Iterator openIterator() {
        return new ForceCoordinateSystemIterator(this.results.features(), this.getSchema());
    }

    protected void closeIterator(Iterator close) {
        if (close == null) {
            return;
        }
        if (close instanceof ForceCoordinateSystemIterator) {
            ForceCoordinateSystemIterator iterator = (ForceCoordinateSystemIterator)close;
            iterator.close();
        }
    }

    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference((Envelope)this.results.getBounds());
    }

    public int size() {
        return this.results.size();
    }

    public FeatureCollection getOrigin() {
        return this.results;
    }
}

