/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.referencing.operation.MathTransform;

public final class WorldFileReader {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private double xPixelSize = 0.0;
    private double rotationX = 0.0;
    private double rotationY = 0.0;
    private double yPixelSize = 0.0;
    private double xULC = 0.0;
    private double yULC = 0.0;
    private LinearTransform transform;

    public WorldFileReader(File worldFile) throws IOException {
        this(worldFile, 8192);
    }

    public WorldFileReader(File worldFile, int bufferSize) throws IOException {
        String str;
        BufferedReader bufferedreader = new BufferedReader(new FileReader(worldFile));
        int index = 0;
        double value = 0.0;
        while ((str = bufferedreader.readLine()) != null) {
            value = 0.0;
            try {
                value = Double.parseDouble(str.trim());
            }
            catch (NumberFormatException e) {
                continue;
            }
            switch (index) {
                case 0: {
                    this.xPixelSize = value;
                    break;
                }
                case 1: {
                    this.rotationX = value;
                    break;
                }
                case 2: {
                    this.rotationY = value;
                    break;
                }
                case 3: {
                    this.yPixelSize = value;
                    break;
                }
                case 4: {
                    this.xULC = value;
                    break;
                }
                case 5: {
                    this.yULC = value;
                    break;
                }
            }
            ++index;
        }
        bufferedreader.close();
        if (index < 5) {
            throw new IOException("Not all the values were found for this world file!");
        }
    }

    public double getRotationX() {
        return this.rotationX;
    }

    public double getRotationY() {
        return this.rotationY;
    }

    public double getXPixelSize() {
        return this.xPixelSize;
    }

    public double getXULC() {
        return this.xULC;
    }

    public double getYPixelSize() {
        return this.yPixelSize;
    }

    public double getYULC() {
        return this.yULC;
    }

    public synchronized MathTransform getTransform() {
        if (this.transform == null) {
            GeneralMatrix gm = new GeneralMatrix(3);
            gm.setElement(0, 0, this.xPixelSize);
            gm.setElement(1, 1, this.yPixelSize);
            gm.setElement(0, 1, this.rotationX);
            gm.setElement(1, 0, this.rotationY);
            gm.setElement(0, 2, this.xULC);
            gm.setElement(1, 2, this.yULC);
            this.transform = ProjectiveTransform.create(gm);
        }
        return this.transform;
    }
}

