/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.Filter;

public class TransactionStateDiff
implements Transaction.State {
    AbstractDataStore store;
    Transaction transaction;
    Map typeNameDiff = new HashMap();
    public static final Feature NULL = new Feature(){

        public Object getAttribute(String arg0) {
            return null;
        }

        public Object getAttribute(int arg0) {
            return null;
        }

        public Object[] getAttributes(Object[] arg0) {
            return null;
        }

        public ReferencedEnvelope getBounds() {
            return null;
        }

        public Geometry getDefaultGeometry() {
            return null;
        }

        public FeatureType getFeatureType() {
            return null;
        }

        public String getID() {
            return null;
        }

        public int getNumberOfAttributes() {
            return 0;
        }

        public FeatureCollection getParent() {
            return null;
        }

        public void setAttribute(int arg0, Object arg1) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        }

        public void setAttribute(String arg0, Object arg1) throws IllegalAttributeException {
        }

        public void setDefaultGeometry(Geometry arg0) throws IllegalAttributeException {
        }

        public void setParent(FeatureCollection arg0) {
        }
    };

    public TransactionStateDiff(AbstractDataStore dataStore) {
        this.store = dataStore;
    }

    public synchronized void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        } else {
            this.transaction = null;
            if (this.typeNameDiff != null) {
                Iterator i = this.typeNameDiff.values().iterator();
                while (i.hasNext()) {
                    Diff diff = (Diff)i.next();
                    diff.clear();
                }
                this.typeNameDiff.clear();
            }
            this.store = null;
        }
    }

    public synchronized Diff diff(String typeName) throws IOException {
        if (!this.exists(typeName)) {
            throw new IOException(typeName + " not defined");
        }
        if (this.typeNameDiff.containsKey(typeName)) {
            return (Diff)this.typeNameDiff.get(typeName);
        }
        Diff diff = new Diff();
        this.typeNameDiff.put(typeName, diff);
        return diff;
    }

    boolean exists(String typeName) {
        Object[] types;
        try {
            types = this.store.getTypeNames();
        }
        catch (IOException e) {
            return false;
        }
        Arrays.sort(types);
        return Arrays.binarySearch(types, typeName) != -1;
    }

    public synchronized void addAuthorization(String AuthID) throws IOException {
    }

    public synchronized void commit() throws IOException {
        Iterator i = this.typeNameDiff.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String typeName = (String)entry.getKey();
            Diff diff = (Diff)entry.getValue();
            this.applyDiff(typeName, diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyDiff(String typeName, Diff diff) throws IOException {
        FeatureWriter writer;
        if (diff.isEmpty()) {
            return;
        }
        try {
            writer = this.store.createFeatureWriter(typeName, this.transaction);
        }
        catch (UnsupportedOperationException e) {
            writer = this.store.getFeatureWriter(typeName);
        }
        try {
            String fid;
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                fid = feature.getID();
                if (!diff.modified2.containsKey(fid)) continue;
                Feature update = (Feature)diff.modified2.get(fid);
                if (update == NULL) {
                    writer.remove();
                    this.store.listenerManager.fireFeaturesRemoved(typeName, this.transaction, (Envelope)feature.getBounds(), true);
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes(null));
                    writer.write();
                    Envelope bounds = new Envelope();
                    bounds.expandToInclude((Envelope)feature.getBounds());
                    bounds.expandToInclude((Envelope)update.getBounds());
                    this.store.listenerManager.fireFeaturesChanged(typeName, this.transaction, bounds, true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, (Throwable)e);
                }
            }
            Diff diff2 = diff;
            synchronized (diff2) {
                Iterator i = diff.added.values().iterator();
                while (i.hasNext()) {
                    Feature addedFeature = (Feature)i.next();
                    fid = addedFeature.getID();
                    SimpleFeature nextFeature = (SimpleFeature)writer.next();
                    if (nextFeature == null) {
                        throw new DataSourceException("Could not add " + fid);
                    }
                    try {
                        nextFeature.setAttributes(addedFeature.getAttributes(null));
                        writer.write();
                        this.store.listenerManager.fireFeaturesAdded(typeName, this.transaction, (Envelope)nextFeature.getBounds(), true);
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Could update " + fid, (Throwable)e);
                    }
                }
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            writer.close();
            this.store.listenerManager.fireChanged(typeName, this.transaction, true);
            diff.clear();
            throw throwable;
        }
        writer.close();
        this.store.listenerManager.fireChanged(typeName, this.transaction, true);
        diff.clear();
    }

    public synchronized void rollback() throws IOException {
        Iterator i = this.typeNameDiff.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String typeName = (String)entry.getKey();
            Diff diff = (Diff)entry.getValue();
            diff.clear();
            this.store.listenerManager.fireChanged(typeName, this.transaction, false);
        }
    }

    public synchronized FeatureReader reader(String typeName) throws IOException {
        Diff diff = this.diff(typeName);
        FeatureReader reader = this.store.getFeatureReader(typeName);
        return new DiffFeatureReader(reader, diff);
    }

    public synchronized FeatureWriter writer(final String typeName, Filter filter) throws IOException {
        Diff diff = this.diff(typeName);
        FilteringFeatureReader reader = new FilteringFeatureReader(this.store.getFeatureReader(typeName, new DefaultQuery(typeName, filter)), filter);
        return new DiffFeatureWriter(reader, diff, filter){

            public void fireNotification(int eventType, Envelope bounds) {
                switch (eventType) {
                    case 1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesAdded(typeName, TransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case 0: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesChanged(typeName, TransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case -1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesRemoved(typeName, TransactionStateDiff.this.transaction, bounds, false);
                    }
                }
            }
        };
    }
}

