/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.filter.Filter;

public class FilteringFeatureReader
implements FeatureReader {
    protected final FeatureReader featureReader;
    protected final Filter filter;
    protected Feature next;

    public FilteringFeatureReader(FeatureReader featureReader, Filter filter) {
        this.featureReader = featureReader;
        this.filter = filter;
        this.next = null;
    }

    public FeatureReader getDelegate() {
        return this.featureReader;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        Feature f = null;
        if (this.hasNext()) {
            f = this.next;
            this.next = null;
            return f;
        }
        throw new NoSuchElementException("No such Feature exsists");
    }

    public void close() throws IOException {
        this.featureReader.close();
    }

    public FeatureType getFeatureType() {
        return this.featureReader.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        try {
            while (this.featureReader.hasNext()) {
                Feature peek = this.featureReader.next();
                if (!this.filter.evaluate(peek)) continue;
                this.next = peek;
                return true;
            }
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not peek ahead", (Throwable)e);
        }
        return this.next != null;
    }
}

