/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;

public class FileDataStoreFinder {
    protected static final Logger LOGGER = Logging.getLogger("org.geotools.data");

    private FileDataStoreFinder() {
    }

    public static DataStore getDataStore(URL url) throws IOException {
        Iterator ps = FileDataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            FileDataStoreFactorySpi fac = (FileDataStoreFactorySpi)ps.next();
            try {
                if (!fac.canProcess(url)) continue;
                return fac.createDataStore(url);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not aquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return null;
    }

    public static Iterator getAvailableDataStores() {
        HashSet<FileDataStoreFactorySpi> availableDS = new HashSet<FileDataStoreFactorySpi>();
        Set all = CommonFactoryFinder.getFileDataStoreFactories(null);
        Iterator it = all.iterator();
        while (it.hasNext()) {
            FileDataStoreFactorySpi dsFactory = (FileDataStoreFactorySpi)it.next();
            if (!dsFactory.isAvailable()) continue;
            availableDS.add(dsFactory);
        }
        return availableDS.iterator();
    }
}

