/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.util.logging.Logging;

public class DefaultTransaction
implements Transaction {
    protected static final Logger LOGGER = Logging.getLogger("org.geotools.data");
    Map stateLookup = new HashMap();
    Map propertyLookup = new HashMap();
    String handle;
    Set authorizations = new HashSet();

    public DefaultTransaction() {
        Throwable t = new Throwable("who called me?");
        StackTraceElement e = t.getStackTrace()[1];
        this.handle = e.getClassName() + "." + e.getMethodName() + " Transaction";
    }

    public DefaultTransaction(String handle) {
        this.handle = handle;
    }

    public void putState(Object key, Transaction.State state) {
        if (this.stateLookup.containsKey(key)) {
            Transaction.State current = (Transaction.State)this.stateLookup.get(key);
            if (state == current) {
                throw new IllegalArgumentException("Transaction already has an this State for key: " + key + ". Please check for existing State before creating your own.");
            }
            throw new IllegalArgumentException("Transaction already has an entry for key:" + key + ". Please check for existing State before creating your own.");
        }
        this.stateLookup.put(key, state);
        state.setTransaction((Transaction)this);
    }

    public void removeState(Object key) {
        if (this.stateLookup == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        if (!this.stateLookup.containsKey(key)) {
            throw new IllegalArgumentException("Transaction does not no anything about key:" + key + ". Has this key already been removed?");
        }
        Transaction.State state = (Transaction.State)this.stateLookup.remove(key);
        state.setTransaction(null);
    }

    public Transaction.State getState(Object key) {
        if (this.stateLookup == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        return (Transaction.State)this.stateLookup.get(key);
    }

    public void commit() throws IOException {
        int problemCount = 0;
        IOException io = null;
        Iterator i = this.stateLookup.values().iterator();
        while (i.hasNext()) {
            Transaction.State state = (Transaction.State)i.next();
            try {
                state.commit();
            }
            catch (IOException e) {
                ++problemCount;
                io = e;
            }
        }
        if (io != null) {
            if (problemCount == 1) {
                throw io;
            }
            throw new DataSourceException("Commit encountered " + problemCount + " problems - the first was", (Throwable)io);
        }
        this.authorizations.clear();
    }

    public void rollback() throws IOException {
        int problemCount = 0;
        IOException io = null;
        Iterator i = this.stateLookup.values().iterator();
        while (i.hasNext()) {
            Transaction.State state = (Transaction.State)i.next();
            try {
                state.rollback();
            }
            catch (IOException e) {
                ++problemCount;
                io = e;
            }
        }
        if (io != null) {
            if (problemCount == 1) {
                throw io;
            }
            throw new DataSourceException("Rollback encountered " + problemCount + " problems - the first was", (Throwable)io);
        }
        this.authorizations.clear();
    }

    public synchronized void close() {
        Iterator i = this.stateLookup.values().iterator();
        while (i.hasNext()) {
            Transaction.State state = (Transaction.State)i.next();
            state.setTransaction(null);
        }
        this.stateLookup.clear();
        this.stateLookup = null;
        this.authorizations.clear();
        this.authorizations = null;
        this.propertyLookup.clear();
        this.propertyLookup = null;
    }

    public Set getAuthorizations() {
        if (this.authorizations == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        return Collections.unmodifiableSet(this.authorizations);
    }

    public void addAuthorization(String authID) throws IOException {
        if (this.authorizations == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        int problemCount = 0;
        IOException io = null;
        this.authorizations.add(authID);
        Iterator i = this.stateLookup.values().iterator();
        while (i.hasNext()) {
            Transaction.State state = (Transaction.State)i.next();
            try {
                state.addAuthorization(authID);
            }
            catch (IOException e) {
                ++problemCount;
                io = e;
            }
        }
        if (io != null) {
            if (problemCount == 1) {
                throw io;
            }
            throw new DataSourceException("setAuthorization encountered " + problemCount + " problems - the first was", (Throwable)io);
        }
    }

    public String toString() {
        return this.handle;
    }

    public Object getProperty(Object key) {
        if (this.propertyLookup == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        return this.propertyLookup.get(key);
    }

    public void putProperty(Object key, Object value) throws IOException {
        if (this.propertyLookup == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        this.propertyLookup.put(key, value);
    }

    protected void finalize() throws Throwable {
        if (this.stateLookup != null) {
            LOGGER.severe("There's code leaving transaction unclosed. Call Transaction.close() after using them to ensure they do not hold state such as JDCB connections or file handles");
            LOGGER.severe("Unclosed transaction handle is '" + this.handle + "'");
            this.close();
        }
        super.finalize();
    }
}

