/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Diff;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;

public abstract class AbstractFeatureSource
implements FeatureSource {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.data");
    protected Set hints = Collections.EMPTY_SET;
    protected QueryCapabilities queryCapabilities = new QueryCapabilities();

    public AbstractFeatureSource() {
    }

    public AbstractFeatureSource(Set hints) {
        this.hints = Collections.unmodifiableSet(new HashSet(hints));
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    public FeatureCollection getFeatures(Query query) throws IOException {
        FeatureType schema = this.getSchema();
        String typeName = schema.getTypeName();
        if (query.getTypeName() == null) {
            DefaultQuery defaultQuery = new DefaultQuery(query);
            defaultQuery.setTypeName(typeName);
        } else if (!typeName.equals(query.getTypeName())) {
            return new EmptyFeatureCollection(schema);
        }
        DefaultFeatureResults collection = new DefaultFeatureResults(this, query);
        if (collection.getDefaultGeometry() == null) {
            return collection;
        }
        return collection;
    }

    public FeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    public FeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Filter.INCLUDE);
    }

    public Envelope getBounds() throws IOException {
        return this.getBounds((Query)(this.getSchema() == null ? Query.ALL : new DefaultQuery(this.getSchema().getTypeName())));
    }

    public Envelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return new Envelope();
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return null;
        }
        return ((AbstractDataStore)dataStore).getBounds(this.namedQuery(query));
    }

    protected Query namedQuery(Query query) {
        String typeName = this.getSchema().getTypeName();
        if (query.getTypeName() == null || !query.getTypeName().equals(typeName)) {
            return new DefaultQuery(typeName, query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return 0;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return -1;
        }
        Transaction t = this.getTransaction();
        int delta = 0;
        if (t != Transaction.AUTO_COMMIT) {
            Diff diff;
            if (!(t.getState((Object)dataStore) instanceof TransactionStateDiff)) {
                return -1;
            }
            Diff diff2 = diff = ((AbstractDataStore)dataStore).state(t).diff(this.namedQuery(query).getTypeName());
            synchronized (diff2) {
                Object feature;
                Iterator it = diff.added.values().iterator();
                while (it.hasNext()) {
                    feature = it.next();
                    if (!query.getFilter().evaluate(feature)) continue;
                    ++delta;
                }
                it = diff.modified2.values().iterator();
                while (it.hasNext()) {
                    feature = it.next();
                    if (feature != TransactionStateDiff.NULL) continue;
                    --delta;
                }
            }
        }
        return ((AbstractDataStore)dataStore).getCount(this.namedQuery(query)) + delta;
    }

    public Set getSupportedHints() {
        return this.hints;
    }
}

