/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public abstract class AbstractDataStoreTest
extends DataTestCase {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.hsql");
    DataStore data;

    public AbstractDataStoreTest(String arg0) {
        super(arg0);
    }

    public abstract DataStore createDataStore() throws Exception;

    public abstract DataStore tearDownDataStore(DataStore var1) throws Exception;

    protected void setUp() throws Exception {
        this.dataSetUp();
        try {
            this.data = this.createDataStore();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception while making schema", e);
        }
        this.data.createSchema(this.roadType);
        this.data.createSchema(this.riverType);
        FeatureStore roads = (FeatureStore)this.data.getFeatureSource(this.roadType.getTypeName());
        roads.addFeatures(DataUtilities.collection(this.roadFeatures));
        FeatureStore rivers = (FeatureStore)this.data.getFeatureSource(this.riverType.getTypeName());
        rivers.addFeatures(DataUtilities.collection(this.riverFeatures));
        this.roadFeatures = this.grabArray(roads.getFeatures(), this.roadFeatures.length);
        this.riverFeatures = this.grabArray(rivers.getFeatures(), this.riverFeatures.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleFeature[] grabArray(FeatureCollection features, int size) {
        try {
            Object[] array = new SimpleFeature[size];
            array = (SimpleFeature[])features.toArray(array);
            AbstractDataStoreTest.assertNotNull((Object)array);
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            features.purge();
        }
    }

    protected void tearDown() throws Exception {
        this.tearDownDataStore(this.data);
        this.data = null;
        super.tearDown();
    }

    public void testFeatureEvents() throws Exception {
        FeatureStore store1 = (FeatureStore)this.data.getFeatureSource(this.roadFeatures[0].getFeatureType().getTypeName());
        FeatureStore store2 = (FeatureStore)this.data.getFeatureSource(this.roadFeatures[0].getFeatureType().getTypeName());
        store1.setTransaction((Transaction)new DefaultTransaction());
        class Listener
        implements FeatureListener {
            String name;
            List events = new ArrayList();

            public Listener(String name) {
                this.name = name;
            }

            public void changed(FeatureEvent featureEvent) {
                this.events.add(featureEvent);
            }

            FeatureEvent getEvent(int i) {
                return (FeatureEvent)this.events.get(i);
            }
        }
        Listener listener1 = new Listener("one");
        Listener listener2 = new Listener("two");
        store1.addFeatureListener((FeatureListener)listener1);
        store2.addFeatureListener((FeatureListener)listener2);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeature feature = this.roadFeatures[0];
        Id fidFilter = ff.id(Collections.singleton(ff.featureId(feature.getID())));
        store1.removeFeatures((Filter)fidFilter);
        AbstractDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        AbstractDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
        FeatureEvent event = listener1.getEvent(0);
        AbstractDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        AbstractDataStoreTest.assertEquals((int)-1, (int)event.getEventType());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().commit();
        AbstractDataStoreTest.assertEquals((int)0, (int)listener1.events.size());
        AbstractDataStoreTest.assertEquals((int)2, (int)listener2.events.size());
        event = listener2.getEvent(0);
        AbstractDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        AbstractDataStoreTest.assertEquals((int)-1, (int)event.getEventType());
        listener1.events.clear();
        listener2.events.clear();
        store1.addFeatures(DataUtilities.collection(feature));
        AbstractDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        event = listener1.getEvent(0);
        AbstractDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        AbstractDataStoreTest.assertEquals((int)1, (int)event.getEventType());
        AbstractDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().rollback();
        AbstractDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        event = listener1.getEvent(0);
        AbstractDataStoreTest.assertNull((Object)event.getBounds());
        AbstractDataStoreTest.assertEquals((int)0, (int)event.getEventType());
        AbstractDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
    }

    public void testFixture() throws Exception {
        FeatureType type = DataUtilities.createType("namespace.typename", "name:String,id:0,geom:MultiLineString");
        AbstractDataStoreTest.assertEquals((String)"namespace", (Object)new URI("namespace"), (Object)type.getNamespace());
        AbstractDataStoreTest.assertEquals((String)"typename", (String)"typename", (String)type.getTypeName());
        AbstractDataStoreTest.assertEquals((String)"attributes", (int)3, (int)type.getAttributeCount());
        AttributeType[] a = type.getAttributeTypes();
        AbstractDataStoreTest.assertEquals((String)"a1", (String)"name", (String)a[0].getName());
        AbstractDataStoreTest.assertEquals((String)"a1", (Object)String.class, (Object)a[0].getType());
        AbstractDataStoreTest.assertEquals((String)"a2", (String)"id", (String)a[1].getName());
        AbstractDataStoreTest.assertEquals((String)"a2", (Object)Integer.class, (Object)a[1].getType());
        AbstractDataStoreTest.assertEquals((String)"a3", (String)"geom", (String)a[2].getName());
        AbstractDataStoreTest.assertEquals((String)"a3", (Object)MultiLineString.class, (Object)a[2].getType());
    }

    public void testGetFeatureTypes() {
        try {
            Object[] names = this.data.getTypeNames();
            AbstractDataStoreTest.assertEquals((int)2, (int)names.length);
            AbstractDataStoreTest.assertTrue((boolean)this.contains(names, "ROAD"));
            AbstractDataStoreTest.assertTrue((boolean)this.contains(names, "RIVER"));
        }
        catch (IOException e) {
            e.printStackTrace();
            AbstractDataStoreTest.fail((String)"Fail with an IOException trying to getTypeNames()");
        }
    }

    boolean contains(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(expected)) continue;
            return true;
        }
        return false;
    }

    boolean containsFeatureCollection(FeatureCollection fc, Feature f) {
        if (fc == null || fc.isEmpty()) {
            return false;
        }
        return this.containsFeature(fc.toArray(), f);
    }

    boolean containsFeature(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!this.isFeatureEqual((Feature)array[i], (Feature)expected)) continue;
            return true;
        }
        return false;
    }

    public boolean isFeatureEqual(Feature feature1, Feature feature2) {
        if (feature2 == null) {
            return false;
        }
        if (feature2 == feature1) {
            return true;
        }
        if (!feature2.getFeatureType().equals(feature1.getFeatureType())) {
            return false;
        }
        int ii = feature1.getNumberOfAttributes();
        for (int i = 0; i < ii; ++i) {
            Object otherAtt = feature2.getAttribute(i);
            if (feature1.getAttribute(i) == null) {
                if (otherAtt == null) continue;
                return false;
            }
            if (feature1.getAttribute(i).equals(otherAtt)) continue;
            if (feature1.getAttribute(i) instanceof Geometry && otherAtt instanceof Geometry) {
                if (((Geometry)feature1.getAttribute(i)).equals((Geometry)otherAtt)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    boolean containsLax(Feature[] array, Feature expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        FeatureType type = expected.getFeatureType();
        for (int i = 0; i < array.length; ++i) {
            if (!this.match(array[i], expected)) continue;
            return true;
        }
        return false;
    }

    boolean match(Feature expected, Feature actual) {
        FeatureType type = expected.getFeatureType();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            Geometry eg;
            Geometry ag;
            Object av = actual.getAttribute(i);
            Object ev = expected.getAttribute(i);
            if (av == null && ev != null) {
                return false;
            }
            if (ev == null && av != null) {
                return false;
            }
            if (!(av instanceof Geometry && ev instanceof Geometry ? !(ag = (Geometry)av).equals(eg = (Geometry)ev) : !av.equals(ev))) continue;
            return false;
        }
        return true;
    }

    public void testGetSchema() throws IOException {
        AbstractDataStoreTest.assertEquals((Object)this.roadType, (Object)this.data.getSchema("ROAD"));
        AbstractDataStoreTest.assertEquals((Object)this.riverType, (Object)this.data.getSchema("RIVER"));
    }

    void assertCovers(String msg, FeatureCollection c1, FeatureCollection c2) {
        if (c1 == c2) {
            return;
        }
        AbstractDataStoreTest.assertNotNull((String)msg, (Object)c1);
        AbstractDataStoreTest.assertNotNull((String)msg, (Object)c2);
        AbstractDataStoreTest.assertEquals((String)(msg + " size"), (int)c1.size(), (int)c2.size());
        FeatureIterator i = c1.features();
        while (i.hasNext()) {
            Feature f = i.next();
            AbstractDataStoreTest.assertTrue((String)(msg + " " + f.getID()), (boolean)this.containsFeatureCollection(c2, f));
        }
    }

    public void testGetFeatureReader() throws IOException, IllegalAttributeException {
        DefaultQuery query = new DefaultQuery(this.roadType.getTypeName());
        FeatureReader reader = this.data.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        this.assertCovered(this.roadFeatures, reader);
        AbstractDataStoreTest.assertEquals((boolean)false, (boolean)reader.hasNext());
    }

    public void testGetFeatureReaderMutability() throws IOException, IllegalAttributeException {
        Feature feature;
        DefaultQuery query = new DefaultQuery(this.roadType.getTypeName());
        FeatureReader reader = this.data.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        while (reader.hasNext()) {
            feature = reader.next();
            feature.setAttribute("NAME", null);
        }
        reader.close();
        reader = this.data.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        while (reader.hasNext()) {
            feature = reader.next();
            AbstractDataStoreTest.assertNotNull((Object)feature.getAttribute("NAME"));
        }
        reader.close();
        try {
            reader.next();
            AbstractDataStoreTest.fail((String)"next should fail with an IOException or NoSuchElementException");
        }
        catch (IOException expected) {
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testGetFeatureReaderConcurancy() throws NoSuchElementException, IOException, IllegalAttributeException {
        DefaultQuery query = new DefaultQuery(this.roadType.getTypeName());
        FeatureReader reader1 = this.data.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        FeatureReader reader2 = this.data.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        query = new DefaultQuery(this.riverType.getTypeName());
        FeatureReader reader3 = this.data.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        while (reader1.hasNext() || reader2.hasNext() || reader3.hasNext()) {
            AbstractDataStoreTest.assertTrue((boolean)this.containsFeature(this.roadFeatures, reader1.next()));
            AbstractDataStoreTest.assertTrue((boolean)this.containsFeature(this.roadFeatures, reader2.next()));
            if (!reader3.hasNext()) continue;
            AbstractDataStoreTest.assertTrue((boolean)this.containsFeature(this.riverFeatures, reader3.next()));
        }
        try {
            reader1.next();
            AbstractDataStoreTest.fail((String)"next should fail with an IOException or NoSuchElementException");
        }
        catch (IOException expected) {
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            reader2.next();
            AbstractDataStoreTest.fail((String)"next should fail with an IOException or NoSuchElementException");
        }
        catch (IOException expected) {
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            reader3.next();
            AbstractDataStoreTest.fail((String)"next should fail with an IOException or NoSuchElementException");
        }
        catch (IOException expected) {
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        reader1.close();
        reader2.close();
        reader3.close();
    }

    public void testGetFeatureReaderFilterAutoCommit() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureType type = this.data.getSchema("ROAD");
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertFalse((boolean)(reader instanceof FilteringFeatureReader));
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", Filter.EXCLUDE), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", this.rd1Filter), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)1, (int)this.count(reader));
    }

    public void testGetFeatureReaderFilterTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        DefaultTransaction t = new DefaultTransaction();
        FeatureType type = this.data.getSchema("ROAD");
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", Filter.EXCLUDE), (Transaction)t);
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t);
        AbstractDataStoreTest.assertTrue((boolean)(reader instanceof DiffFeatureReader));
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", this.rd1Filter), (Transaction)t);
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)1, (int)this.count(reader));
        FeatureStore store = (FeatureStore)this.data.getFeatureSource("ROAD");
        store.setTransaction((Transaction)t);
        store.removeFeatures(this.rd1Filter);
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", Filter.EXCLUDE), (Transaction)t);
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t);
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", this.rd1Filter), (Transaction)t);
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        t.rollback();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", Filter.EXCLUDE), (Transaction)t);
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t);
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", this.rd1Filter), (Transaction)t);
        AbstractDataStoreTest.assertEquals((int)1, (int)this.count(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertCovered(Feature[] features, FeatureReader reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        while (reader.hasNext()) {
            AbstractDataStoreTest.assertTrue((boolean)this.containsFeature(features, reader.next()));
            ++count;
        }
        AbstractDataStoreTest.assertEquals((int)features.length, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureCollection features, Feature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        Iterator i = features.iterator();
        try {
            while (i.hasNext()) {
                Feature feature = (Feature)i.next();
                if (!this.containsFeature(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            features.close(i);
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureReader reader, Feature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                Feature feature = reader.next();
                AbstractDataStoreTest.assertNotNull((String)"feature", (Object)feature);
                if (!this.containsFeature(array, feature)) {
                    AbstractDataStoreTest.fail((String)("feature " + feature.getID() + " not listed"));
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        AbstractDataStoreTest.assertEquals((String)"covers", (int)count, (int)array.length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureIterator reader, Feature[] array) throws NoSuchElementException, IOException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                Feature feature = reader.next();
                AbstractDataStoreTest.assertNotNull((String)"feature", (Object)feature);
                if (!this.containsFeature(array, feature)) {
                    AbstractDataStoreTest.fail((String)("feature " + feature.getID() + " not listed"));
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        AbstractDataStoreTest.assertEquals((String)"covers", (int)count, (int)array.length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(FeatureReader reader, Feature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                Feature feature = reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(FeatureIterator reader, Feature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                Feature feature = reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FeatureReader reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                Feature feature = reader.next();
                System.out.println(count + " feature:" + feature);
                ++count;
            }
        }
        finally {
            reader.close();
        }
    }

    void dump(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(i + " feature:" + array[i]);
        }
    }

    public void testGetFeatureWriter() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        try {
            writer.hasNext();
            AbstractDataStoreTest.fail((String)"Should not be able to use a closed writer");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            writer.next();
            AbstractDataStoreTest.fail((String)"Should not be able to use a closed writer");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testGetFeatureWriterRemove() throws IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            Feature feature = writer.next();
            if (!feature.getID().equals(this.roadFeatures[0].getID())) continue;
            writer.remove();
        }
        writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.count(writer));
    }

    public void testGetFeaturesWriterAdd() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureWriter writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            feature = (SimpleFeature)writer.next();
        }
        AbstractDataStoreTest.assertFalse((boolean)writer.hasNext());
        feature = (SimpleFeature)writer.next();
        feature.setAttributes(this.newRoad.getAttributes(null));
        writer.write();
        AbstractDataStoreTest.assertFalse((boolean)writer.hasNext());
        writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length + 1), (int)this.count(writer));
    }

    public void testGetFeaturesWriterModify() throws IOException, IllegalAttributeException {
        Feature feature;
        FeatureWriter writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            feature = writer.next();
            if (!feature.getID().equals(this.roadFeatures[0].getID())) continue;
            feature.setAttribute("NAME", (Object)"changed");
            writer.write();
        }
        feature = null;
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD", this.rd1Filter), Transaction.AUTO_COMMIT);
        if (reader.hasNext()) {
            feature = reader.next();
        }
        AbstractDataStoreTest.assertEquals((Object)"changed", (Object)feature.getAttribute("NAME"));
    }

    public void testGetFeatureWriterTypeNameTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        writer.close();
    }

    public void testGetFeatureWriterAppendTypeNameTransaction() throws Exception {
        FeatureWriter writer = this.data.getFeatureWriterAppend("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(writer));
        writer.close();
    }

    public void testGetFeatureWriterFilter() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("ROAD", (Filter)Filter.EXCLUDE, Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertFalse((boolean)writer.hasNext());
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(writer));
        writer = this.data.getFeatureWriter("ROAD", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertFalse((boolean)(writer instanceof FilteringFeatureWriter));
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        writer = this.data.getFeatureWriter("ROAD", this.rd1Filter, Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)1, (int)this.count(writer));
    }

    public void testGetFeatureWriterTransaction() throws Exception {
        SimpleFeature feature;
        int i;
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureWriter writer1 = this.data.getFeatureWriter("ROAD", this.rd1Filter, (Transaction)t1);
        FeatureWriter writer2 = this.data.getFeatureWriterAppend("ROAD", (Transaction)t2);
        FeatureType road = this.data.getSchema("ROAD");
        Feature[] ORIGIONAL = this.roadFeatures;
        Feature[] REMOVE = new Feature[ORIGIONAL.length - 1];
        Feature[] ADD = new Feature[ORIGIONAL.length + 1];
        Feature[] FINAL = new Feature[ORIGIONAL.length];
        int index = 0;
        for (i = 0; i < ORIGIONAL.length; ++i) {
            feature = ORIGIONAL[i];
            if (feature.getID().equals(this.roadFeatures[0].getID())) continue;
            REMOVE[index++] = feature;
        }
        for (i = 0; i < ORIGIONAL.length; ++i) {
            ADD[i] = ORIGIONAL[i];
        }
        ADD[i] = this.newRoad;
        for (i = 0; i < REMOVE.length; ++i) {
            FINAL[i] = REMOVE[i];
        }
        FINAL[i] = this.newRoad;
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        while (writer1.hasNext()) {
            feature = (SimpleFeature)writer1.next();
            AbstractDataStoreTest.assertEquals((String)this.roadFeatures[0].getID(), (String)feature.getID());
            writer1.remove();
        }
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t1);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, REMOVE));
        writer1.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t1);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, REMOVE));
        feature = (SimpleFeature)writer2.next();
        feature.setAttributes(this.newRoad.getAttributes(null));
        writer2.write();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t2);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, ADD));
        writer2.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t2);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, ADD));
        t1.commit();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, REMOVE));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t1);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, REMOVE));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t2);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, FINAL));
        t2.commit();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, FINAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t1);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, FINAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("ROAD"), (Transaction)t2);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, FINAL));
    }

    public void atestGetFeatureSourceRoad() throws IOException {
        FeatureSource road = this.data.getFeatureSource("ROAD");
        AbstractDataStoreTest.assertEquals((Object)this.roadType, (Object)road.getSchema());
        AbstractDataStoreTest.assertEquals((Object)this.data, (Object)road.getDataStore());
        AbstractDataStoreTest.assertEquals((int)3, (int)road.getCount(Query.ALL));
        AbstractDataStoreTest.assertEquals((Object)new Envelope(1.0, 5.0, 0.0, 4.0), (Object)road.getFeatures(Query.ALL).getBounds());
        FeatureCollection all = road.getFeatures();
        AbstractDataStoreTest.assertEquals((int)3, (int)all.size());
        AbstractDataStoreTest.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        FeatureCollection expected = DataUtilities.collection(this.roadFeatures);
        this.assertCovers("ALL", expected, all);
        AbstractDataStoreTest.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        FeatureCollection some = road.getFeatures(this.rd12Filter);
        AbstractDataStoreTest.assertEquals((int)2, (int)some.size());
        AbstractDataStoreTest.assertEquals((Object)this.rd12Bounds, (Object)some.getBounds());
        AbstractDataStoreTest.assertEquals((Object)some.getSchema(), (Object)road.getSchema());
        DefaultQuery query = new DefaultQuery("ROAD", this.rd12Filter, new String[]{"NAME"});
        FeatureCollection half = road.getFeatures((Query)query);
        AbstractDataStoreTest.assertEquals((int)2, (int)half.size());
        AbstractDataStoreTest.assertEquals((int)1, (int)half.getSchema().getAttributeCount());
        FeatureIterator reader = half.features();
        FeatureType type = half.getSchema();
        reader.close();
        FeatureType actual = half.getSchema();
        AbstractDataStoreTest.assertEquals((String)type.getTypeName(), (String)actual.getTypeName());
        AbstractDataStoreTest.assertEquals((Object)type.getNamespace(), (Object)actual.getNamespace());
        AbstractDataStoreTest.assertEquals((int)type.getAttributeCount(), (int)actual.getAttributeCount());
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            AbstractDataStoreTest.assertEquals((Object)type.getAttributeType(i), (Object)actual.getAttributeType(i));
        }
        AbstractDataStoreTest.assertNull((Object)type.getDefaultGeometry());
        AbstractDataStoreTest.assertEquals((Object)type.getDefaultGeometry(), (Object)actual.getDefaultGeometry());
        AbstractDataStoreTest.assertEquals((Object)type, (Object)actual);
        ReferencedEnvelope b = half.getBounds();
        AbstractDataStoreTest.assertEquals((Object)new Envelope(1.0, 5.0, 0.0, 4.0), (Object)b);
    }

    public void testGetFeatureSourceRiver() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureSource river = this.data.getFeatureSource("RIVER");
        AbstractDataStoreTest.assertEquals((Object)this.riverType, (Object)river.getSchema());
        AbstractDataStoreTest.assertEquals((Object)this.data, (Object)river.getDataStore());
        FeatureCollection all = river.getFeatures();
        AbstractDataStoreTest.assertEquals((int)2, (int)all.size());
        AbstractDataStoreTest.assertEquals((Object)this.riverBounds, (Object)all.getBounds());
        AbstractDataStoreTest.assertTrue((String)"RIVERS", (boolean)this.covers(all.features(), this.riverFeatures));
        FeatureCollection expected = DataUtilities.collection(this.riverFeatures);
        this.assertCovers("ALL", expected, all);
        AbstractDataStoreTest.assertEquals((Object)this.riverBounds, (Object)all.getBounds());
    }

    public void testGetFeatureStoreModifyFeatures1() throws IOException {
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("ROAD");
        AttributeType name = this.roadType.getAttributeType("NAME");
        road.modifyFeatures(name, (Object)"changed", this.rd1Filter);
        FeatureCollection results = road.getFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertEquals((Object)"changed", (Object)results.features().next().getAttribute("NAME"));
    }

    public void testGetFeatureStoreModifyFeatures2() throws IOException {
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("ROAD");
        AttributeType name = this.roadType.getAttributeType("NAME");
        road.modifyFeatures(new AttributeType[]{name}, new Object[]{"changed"}, this.rd1Filter);
        FeatureCollection results = road.getFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertEquals((Object)"changed", (Object)results.features().next().getAttribute("NAME"));
    }

    public void testGetFeatureStoreRemoveFeatures() throws IOException {
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("ROAD");
        road.removeFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertEquals((int)0, (int)road.getFeatures(this.rd1Filter).size());
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreAddFeatures() throws IOException {
        FeatureReader reader = DataUtilities.reader(new Feature[]{this.newRoad});
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("ROAD");
        road.addFeatures(DataUtilities.collection(reader));
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length + 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreSetFeatures() throws IOException {
        FeatureReader reader = DataUtilities.reader(new Feature[]{this.newRoad});
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("ROAD");
        road.setFeatures(reader);
        AbstractDataStoreTest.assertEquals((int)1, (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreTransactionSupport() throws Exception {
        int i;
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("ROAD");
        FeatureStore road1 = (FeatureStore)this.data.getFeatureSource("ROAD");
        FeatureStore road2 = (FeatureStore)this.data.getFeatureSource("ROAD");
        road1.setTransaction((Transaction)t1);
        road2.setTransaction((Transaction)t2);
        Feature[] ORIGIONAL = this.roadFeatures;
        Feature[] REMOVE = new Feature[ORIGIONAL.length - 1];
        Feature[] ADD = new Feature[ORIGIONAL.length + 1];
        Feature[] FINAL = new Feature[ORIGIONAL.length];
        int index = 0;
        for (i = 0; i < ORIGIONAL.length; ++i) {
            SimpleFeature feature = ORIGIONAL[i];
            if (feature.getID().equals(this.roadFeatures[0].getID())) continue;
            REMOVE[index++] = feature;
        }
        for (i = 0; i < ORIGIONAL.length; ++i) {
            ADD[i] = ORIGIONAL[i];
        }
        ADD[i] = this.newRoad;
        for (i = 0; i < REMOVE.length; ++i) {
            FINAL[i] = REMOVE[i];
        }
        FINAL[i] = this.newRoad;
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
        road1.removeFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
        FeatureCollection collection = DataUtilities.collection(new Feature[]{this.newRoad});
        road2.addFeatures(collection);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), ADD));
        t1.commit();
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road.getFeatures().features(), REMOVE));
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), FINAL));
        t2.commit();
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road.getFeatures().features(), FINAL));
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road1.getFeatures().features(), FINAL));
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), FINAL));
    }

    boolean isLocked(String typeName, String fid) {
        InProcessLockingManager lockingManager = (InProcessLockingManager)this.data.getLockingManager();
        return lockingManager.isLocked(typeName, fid);
    }

    public void testLockFeatures() throws IOException {
        FeatureLock lock = FeatureLockFactory.generate("test", 3600L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("ROAD");
        road.setFeatureLock(lock);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        road.lockFeatures();
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
    }

    public void testUnLockFeatures() throws IOException {
        FeatureLock lock = FeatureLockFactory.generate("test", 360000L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("ROAD");
        road.setFeatureLock(lock);
        road.lockFeatures();
        try {
            road.unLockFeatures();
            AbstractDataStoreTest.fail((String)"unlock should fail due on AUTO_COMMIT");
        }
        catch (IOException expected) {
            // empty catch block
        }
        DefaultTransaction t = new DefaultTransaction();
        road.setTransaction((Transaction)t);
        try {
            road.unLockFeatures();
            AbstractDataStoreTest.fail((String)"unlock should fail due lack of authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        t.addAuthorization(lock.getAuthorization());
        road.unLockFeatures();
    }

    public void testLockFeatureInteraction() throws IOException {
        FeatureLock lockA = FeatureLockFactory.generate("LockA", 3600L);
        FeatureLock lockB = FeatureLockFactory.generate("LockB", 3600L);
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureLocking road1 = (FeatureLocking)this.data.getFeatureSource("ROAD");
        FeatureLocking road2 = (FeatureLocking)this.data.getFeatureSource("ROAD");
        road1.setTransaction((Transaction)t1);
        road2.setTransaction((Transaction)t2);
        road1.setFeatureLock(lockA);
        road2.setFeatureLock(lockB);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
        road1.lockFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
        road2.lockFeatures(this.rd2Filter);
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
        try {
            road1.unLockFeatures(this.rd1Filter);
            AbstractDataStoreTest.fail((String)"need authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        t1.addAuthorization(lockA.getAuthorization());
        try {
            road1.unLockFeatures(this.rd2Filter);
            AbstractDataStoreTest.fail((String)"need correct authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        road1.unLockFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
        t2.addAuthorization(lockB.getAuthorization());
        road2.unLockFeatures(this.rd2Filter);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
    }

    public void testGetFeatureLockingExpire() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate("Timed", 1L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("ROAD");
        road.setFeatureLock(lock);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        road.lockFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        Thread.sleep(50L);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
    }

    public void testCreateSchema() throws Exception {
        String typename = "NewType";
        FeatureType t = DataUtilities.createType(typename, "*geom:Geometry");
        this.data.createSchema(t);
        String[] names = this.data.getTypeNames();
        boolean foundNewType = false;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(typename)) continue;
            foundNewType = true;
        }
        AbstractDataStoreTest.assertTrue((boolean)foundNewType);
    }
}

