/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.adaptable;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveAdapterFactory;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveChangeListener;
import org.geotools.catalog.Service;
import org.geotools.catalog.adaptable.AdaptingCatalog;
import org.geotools.catalog.adaptable.AdaptingGeoResource;
import org.geotools.catalog.adaptable.AdaptingResolveAware;
import org.geotools.catalog.adaptable.AdaptingService;
import org.geotools.catalog.adaptable.ResolveAdapterFactoryFinder;
import org.geotools.resources.Utilities;
import org.geotools.util.ProgressListener;

public abstract class AdaptingResolve
implements Resolve {
    protected Resolve resolve;
    protected ResolveAdapterFactoryFinder finder;
    AdaptingResolve parent;
    List members;
    HashMap adapterCache;

    AdaptingResolve(Resolve resolve, ResolveAdapterFactoryFinder finder) {
        this.resolve = resolve;
        this.finder = finder;
        this.adapterCache = new HashMap();
    }

    public ResolveAdapterFactoryFinder getResolveAdapterFactoryFinder() {
        return this.finder;
    }

    public final synchronized List members(ProgressListener monitor) throws IOException {
        List rMembers = this.resolve.members(monitor);
        if (this.members == null) {
            this.members = this.wrap(rMembers);
        } else {
            boolean equal = true;
            if (this.members.size() != rMembers.size()) {
                equal = false;
            } else {
                Iterator r = rMembers.iterator();
                Iterator m = this.members.iterator();
                while (r.hasNext() && equal) {
                    Resolve rMember = (Resolve)r.next();
                    AdaptingResolve member = (AdaptingResolve)m.next();
                    equal = Utilities.equals(rMember, member);
                }
            }
            if (!equal) {
                this.members = this.wrap(rMembers);
            }
        }
        return this.members;
    }

    protected List wrap(List members) {
        ArrayList<AdaptingResolve> wrapped;
        try {
            wrapped = (ArrayList<AdaptingResolve>)members.getClass().newInstance();
        }
        catch (Exception e) {
            wrapped = new ArrayList<AdaptingResolve>();
        }
        Iterator m = members.iterator();
        while (m.hasNext()) {
            Resolve member = (Resolve)m.next();
            AdaptingResolve wrapper = this.wrap(member);
            if (wrapper == null) continue;
            wrapped.add(wrapper);
        }
        return wrapped;
    }

    protected AdaptingResolve wrap(Resolve resolve) {
        if (resolve instanceof AdaptingResolve) {
            return (AdaptingResolve)resolve;
        }
        if (resolve instanceof Catalog) {
            return new AdaptingCatalog((Catalog)resolve, this.finder);
        }
        if (resolve instanceof Service) {
            return new AdaptingService((Service)resolve, this.finder);
        }
        if (resolve instanceof GeoResource) {
            return new AdaptingGeoResource((GeoResource)resolve, this.finder);
        }
        return null;
    }

    public final boolean canResolve(Class adaptee) {
        if (this.finder.find(this, adaptee) != null) {
            return true;
        }
        return this.resolve.canResolve(adaptee);
    }

    public final Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        Key key = new Key(this.resolve, adaptee);
        if (this.adapterCache.containsKey(key)) {
            return this.adapterCache.get(key);
        }
        ResolveAdapterFactory factory = this.finder.find(this, adaptee);
        if (factory != null) {
            Object adapter;
            if (factory instanceof AdaptingResolveAware) {
                ((AdaptingResolveAware)factory).setAdaptingResolve(this);
            }
            if ((adapter = factory.adapt(this.resolve, adaptee, monitor)) != null) {
                this.adapterCache.put(key, adapter);
                return adapter;
            }
        }
        if (this.resolve.canResolve(adaptee)) {
            return this.resolve.resolve(adaptee, monitor);
        }
        return null;
    }

    public final synchronized Resolve parent(ProgressListener monitor) throws IOException {
        Resolve rParent = this.resolve.parent(monitor);
        if (this.parent == null || !Utilities.equals(this.parent.resolve, rParent)) {
            this.parent = this.wrap(rParent);
        }
        return this.parent;
    }

    public Resolve.Status getStatus() {
        return this.resolve.getStatus();
    }

    public Throwable getMessage() {
        return this.resolve.getMessage();
    }

    public URI getIdentifier() {
        return this.resolve.getIdentifier();
    }

    public void addListener(ResolveChangeListener listener) throws UnsupportedOperationException {
        this.resolve.addListener(listener);
    }

    public void removeListener(ResolveChangeListener listener) {
        this.resolve.removeListener(listener);
    }

    public void fire(ResolveChangeEvent event) {
        this.resolve.fire(event);
    }

    private static class Key {
        public Resolve resolve;
        public Class adaptee;

        public Key(Resolve resolve, Class adaptee) {
            this.resolve = resolve;
            this.adaptee = adaptee;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return Utilities.equals(this.resolve, other.resolve) && Utilities.equals(this.adaptee, other.adaptee);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + (this.resolve != null ? this.resolve.hashCode() : 0);
            hash = 31 * hash + (this.adaptee != null ? this.adaptee.hashCode() : 0);
            return hash;
        }
    }
}

