/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.geotools.catalog.AbstractGeoResource;
import org.geotools.catalog.DataStoreService;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.Service;
import org.geotools.catalog.defaults.DefaultGeoResourceInfo;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.ProgressListener;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureSourceGeoResource
extends AbstractGeoResource {
    DataStoreService parent;
    String name;
    FeatureSource source;
    GeoResourceInfo info;

    public FeatureSourceGeoResource(DataStoreService parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(Service.class) || adaptee.isAssignableFrom(GeoResourceInfo.class) || adaptee.isAssignableFrom(FeatureSource.class) || adaptee.isAssignableFrom(FeatureType.class) || adaptee.isAssignableFrom(DataStore.class);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(Service.class)) {
            return this.parent;
        }
        if (adaptee.isAssignableFrom(GeoResourceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(FeatureSource.class)) {
            return this.featureSource(monitor);
        }
        if (adaptee.isAssignableFrom(FeatureType.class)) {
            return this.parent.dataStore(monitor).getSchema(this.name);
        }
        if (adaptee.isAssignableFrom(DataStore.class)) {
            return this.parent.dataStore(monitor);
        }
        return null;
    }

    public Resolve.Status getStatus() {
        if (this.getMessage() != null) {
            return Resolve.Status.BROKEN;
        }
        if (this.source != null) {
            return Resolve.Status.CONNECTED;
        }
        return Resolve.Status.NOTCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoResourceInfo getInfo(ProgressListener monitor) throws IOException {
        if (this.info == null) {
            DataStore dataStore;
            DataStore dataStore2 = dataStore = this.parent.dataStore(monitor);
            synchronized (dataStore2) {
                if (this.info == null) {
                    try {
                        this.info = this.createMetaData(this.featureSource(monitor), monitor);
                        this.setMessage(null);
                    }
                    catch (Throwable t) {
                        String msg = "unable to create metadata";
                        logger.log(Level.SEVERE, msg, t);
                        this.setMessage(t);
                    }
                }
            }
        }
        return this.info;
    }

    protected GeoResourceInfo createMetaData(FeatureSource source, ProgressListener monitor) throws IOException {
        Object schema;
        Object rBounds = null;
        Envelope bounds = source.getBounds();
        if (bounds != null) {
            FeatureType schema2;
            if (bounds instanceof ReferencedEnvelope) {
                rBounds = (ReferencedEnvelope)bounds;
            }
            if (rBounds == null && (schema2 = source.getSchema()).getDefaultGeometry() != null) {
                CoordinateReferenceSystem crs = schema2.getDefaultGeometry().getCoordinateSystem();
                rBounds = crs != null ? new ReferencedEnvelope(bounds, crs) : null;
            }
            if (rBounds == null) {
                rBounds = new ReferencedEnvelope(bounds, null);
            }
        } else {
            bounds = new Envelope();
            FeatureIterator itr = source.getFeatures().features();
            if (itr.hasNext()) {
                bounds.init((Envelope)itr.next().getBounds());
                while (itr.hasNext()) {
                    bounds.expandToInclude((Envelope)itr.next().getBounds());
                }
            }
            schema = source.getSchema();
            CoordinateReferenceSystem crs = null;
            if (schema.getDefaultGeometry() != null) {
                crs = schema.getDefaultGeometry().getCoordinateSystem();
            }
            rBounds = new ReferencedEnvelope(bounds, crs);
        }
        String name = source.getSchema().getTypeName();
        schema = source.getSchema().getNamespace();
        return new DefaultGeoResourceInfo(null, name, null, (URI)schema, (ReferencedEnvelope)rBounds, null, null);
    }

    public URI getIdentifier() {
        URI uri = this.parent.getIdentifier();
        try {
            return new URI(uri.getScheme(), uri.getHost(), uri.getPath(), this.name);
        }
        catch (URISyntaxException e) {
            String msg = "Unable to build uri identifer";
            logger.log(Level.WARNING, msg, e);
            this.setMessage(e);
            try {
                return new URI(this.name);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureSource featureSource(ProgressListener monitor) {
        if (this.source == null) {
            DataStore dataStore = this.parent.dataStore(monitor);
            try {
                DataStore dataStore2 = dataStore;
                synchronized (dataStore2) {
                    this.source = dataStore.getFeatureSource(this.name);
                    if (this.source == null) {
                        throw new NullPointerException();
                    }
                    this.setMessage(null);
                    return this.source;
                }
            }
            catch (Throwable t) {
                String msg = "Unable to resolve feature source.";
                logger.log(Level.SEVERE, msg, t);
                this.setMessage(t);
            }
        }
        return this.source;
    }

    protected FeatureType featureType(ProgressListener monitor) {
        if (this.featureSource(monitor) != null) {
            return this.featureSource(monitor).getSchema();
        }
        return null;
    }
}

