/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveChangeListener;
import org.geotools.catalog.Service;
import org.geotools.util.ProgressListener;
import org.geotools.util.logging.Logging;

public abstract class AbstractService
implements Service {
    protected static Logger logger = Logging.getLogger("org.geotools.catalog");
    private Catalog parent;
    private Map params;
    private Throwable msg;
    private List members;

    public AbstractService(Catalog parent) {
        this.parent = parent;
    }

    public AbstractService(Catalog parent, Map params) {
        this(parent);
        this.params = params;
    }

    public Resolve parent(ProgressListener monitor) {
        return this.parent;
    }

    public Map getConnectionParams() {
        return this.params;
    }

    protected void setConnectionParams(Map params) {
        this.params = params;
    }

    protected void setMembers(List members) {
        this.members = members;
    }

    protected List getMembers() {
        return this.members;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    protected void setMessage(Throwable msg) {
        this.msg = msg;
    }

    public Resolve.Status getStatus() {
        if (this.msg != null) {
            return Resolve.Status.BROKEN;
        }
        if (this.members != null) {
            return Resolve.Status.CONNECTED;
        }
        return Resolve.Status.NOTCONNECTED;
    }

    public final boolean equals(Object other) {
        if (other != null && other instanceof Service) {
            Service service = (Service)other;
            if (this.getIdentifier() != null && service.getIdentifier() != null) {
                return this.getIdentifier().equals(service.getIdentifier());
            }
        }
        return false;
    }

    public void addListener(ResolveChangeListener listener) {
    }

    public void removeListener(ResolveChangeListener listener) {
    }

    public void fire(ResolveChangeEvent event) {
    }

    public final int hashCode() {
        if (this.getIdentifier() != null) {
            return this.getIdentifier().hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String classname = this.getClass().getName();
        String name = classname.substring(classname.lastIndexOf(46) + 1);
        buf.append(name);
        buf.append("(");
        buf.append(this.getIdentifier());
        buf.append(")");
        return buf.toString();
    }
}

