/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.geotools.catalog.AbstractService;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.ServiceInfo;
import org.geotools.util.ProgressListener;

public abstract class AbstractFileService
extends AbstractService {
    File file;

    public AbstractFileService(Catalog parent, File file) {
        super(parent);
        this.file = file;
    }

    public AbstractFileService(Catalog parent, Map params, File file) {
        super(parent, params);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public List members(ProgressListener monitor) throws IOException {
        if (this.getMembers() != null) {
            return this.getMembers();
        }
        AbstractFileService abstractFileService = this;
        synchronized (abstractFileService) {
            if (this.getMembers() != null) {
                return this.getMembers();
            }
            List members = null;
            try {
                members = this.createMembers(monitor);
                return members;
            }
            catch (IOException e) {
                this.setMessage(e);
                throw e;
            }
        }
    }

    protected abstract List createMembers(ProgressListener var1) throws IOException;

    public boolean canResolve(Class adaptee) {
        return List.class.isAssignableFrom(adaptee) || ServiceInfo.class.isAssignableFrom(adaptee) || File.class.isAssignableFrom(adaptee);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee.isAssignableFrom(List.class)) {
            return this.members(monitor);
        }
        if (adaptee.isAssignableFrom(ServiceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(File.class)) {
            return this.file;
        }
        return null;
    }

    public URI getIdentifier() {
        return this.file.toURI();
    }
}

