/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.time;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLTimeControlledNodeType;
import org.web3d.vrml.nodes.VRMLTimeListener;
import org.web3d.vrml.renderer.common.nodes.BaseTimeDependentNode;

public class BaseTimeController
extends BaseTimeDependentNode
implements VRMLSensorNodeType,
VRMLTimeControlledNodeType,
VRMLTimeListener {
    private static final int[] SECONDARY_TYPE = new int[]{53};
    protected static final int FIELD_DIRECTION = 1;
    protected static final int FIELD_ENABLED = 2;
    protected static final int FIELD_LOOP = 3;
    protected static final int FIELD_RATE = 4;
    protected static final int FIELD_RUN = 5;
    protected static final int FIELD_CURRENT_TIME = 6;
    protected static final int FIELD_START_TIME = 7;
    protected static final int FIELD_STOP_TIME = 8;
    protected static final int FIELD_FRACTION = 9;
    protected static final int FIELD_IS_ACTIVE = 10;
    protected static final int LAST_TIME_CONTROLLER_INDEX = 10;
    protected static final int NUM_FIELDS = 11;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean vfDirection;
    protected boolean vfEnabled;
    protected boolean vfLoop;
    protected float vfRate;
    protected boolean vfRun;
    protected double vfCurrentTime;
    protected double vfStartTime;
    protected double vfStopTime;
    protected float vfFraction;
    protected boolean vfIsActive;
    private double previous_clock_time;
    private boolean time_changed;

    public BaseTimeController() {
        super("TimeController");
        this.hasChanged = new boolean[11];
        this.vfDirection = true;
        this.vfEnabled = true;
        this.vfLoop = false;
        this.vfRate = 1.0f;
        this.vfRun = false;
        this.vfCurrentTime = 0.0;
        this.vfStartTime = 0.0;
        this.vfStopTime = 0.0;
        this.vfIsActive = false;
    }

    public BaseTimeController(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("direction");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDirection = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("enabled");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("loop");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLoop = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("rate");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRate = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("run");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRun = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("currentTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCurrentTime = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("startTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStartTime = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("stopTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStopTime = vRMLFieldData.doubleValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        if (this.vrmlClock != null) {
            this.vrmlClock.removeTimeListener((VRMLTimeListener)this);
        }
        this.vrmlClock = vRMLClock;
        if (this.vrmlClock != null && this.vfEnabled) {
            this.vrmlClock.addTimeListener((VRMLTimeListener)this);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.vfEnabled != bl) {
            this.vfEnabled = bl;
            if (!this.inSetup) {
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
            }
            if (!this.vfEnabled) {
                if (this.vfRun) {
                    this.vfRun = false;
                    if (!this.inSetup) {
                        this.hasChanged[5] = true;
                        this.fireFieldChanged(5);
                    }
                }
                if (this.vfIsActive) {
                    this.vfIsActive = false;
                    if (!this.inSetup) {
                        this.hasChanged[10] = true;
                        this.fireFieldChanged(10);
                    }
                }
            }
            if (this.vrmlClock != null) {
                if (this.vfEnabled) {
                    this.vrmlClock.addTimeListener((VRMLTimeListener)this);
                } else {
                    this.vrmlClock.removeTimeListener((VRMLTimeListener)this);
                }
            }
        }
    }

    public boolean getEnabled() {
        return this.vfEnabled;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 42;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfFraction;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfDirection;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfLoop;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfRate;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfRun;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfCurrentTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfStartTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfStopTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfFraction);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfDirection);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfLoop);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfRate);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfRun);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfCurrentTime);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfStartTime);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfStopTime);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTimeController.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setCurrentTime(d);
                break;
            }
            case 7: {
                this.setStartTime(d);
                break;
            }
            case 8: {
                this.setStopTime(d);
                break;
            }
            default: {
                super.setValue(n, d);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 10: {
                throw new InvalidFieldValueException("Cannot set eventout");
            }
            case 1: {
                this.setDirection(bl);
                break;
            }
            case 2: {
                this.setEnabled(bl);
                break;
            }
            case 3: {
                this.setLoop(bl);
                break;
            }
            case 5: {
                this.setRun(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setRate(f);
                break;
            }
            case 9: {
                throw new InvalidFieldValueException("Cannot set eventout");
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void timeClick(long l) {
        double d = (double)l * 0.001;
        if (this.vfEnabled) {
            int n = this.vfDirection ? 1 : -1;
            double d2 = this.vfStopTime - this.vfStartTime;
            if (this.vfRun) {
                if (this.vfIsActive) {
                    boolean bl;
                    double d3 = (double)((float)n * this.vfRate) * (d - this.previous_clock_time);
                    double d4 = this.vfCurrentTime + d3;
                    boolean bl2 = d4 >= this.vfStartTime;
                    boolean bl3 = bl = d4 <= this.vfStopTime;
                    if (bl2 && bl) {
                        this.vfCurrentTime = d4;
                        this.vfFraction = (float)((this.vfCurrentTime - this.vfStartTime) / d2);
                    } else if (!bl2) {
                        if (this.vfLoop) {
                            this.vfCurrentTime = this.vfStopTime - (this.vfStartTime - d4);
                            this.vfFraction = (float)((this.vfCurrentTime - this.vfStartTime) / d2);
                        } else {
                            this.vfCurrentTime = this.vfStartTime;
                            this.vfFraction = 0.0f;
                            this.vfIsActive = false;
                        }
                    } else if (!bl) {
                        if (this.vfLoop) {
                            this.vfCurrentTime = this.vfStartTime + (d4 - this.vfStopTime);
                            this.vfFraction = (float)((this.vfCurrentTime - this.vfStartTime) / d2);
                        } else {
                            this.vfCurrentTime = this.vfStopTime;
                            this.vfFraction = 1.0f;
                            this.vfIsActive = false;
                        }
                    }
                    this.hasChanged[6] = true;
                    this.fireFieldChanged(6);
                    this.hasChanged[9] = true;
                    this.fireFieldChanged(9);
                    if (!this.vfIsActive) {
                        this.vfRun = false;
                        this.hasChanged[5] = true;
                        this.fireFieldChanged(5);
                        this.hasChanged[10] = true;
                        this.fireFieldChanged(10);
                    }
                } else {
                    boolean bl;
                    boolean bl4 = this.vfCurrentTime >= this.vfStartTime;
                    boolean bl5 = bl = this.vfCurrentTime <= this.vfStopTime;
                    if (bl4 && bl) {
                        this.vfIsActive = true;
                        this.vfFraction = (float)((this.vfCurrentTime - this.vfStartTime) / d2);
                        this.hasChanged[6] = true;
                        this.fireFieldChanged(6);
                        this.hasChanged[9] = true;
                        this.fireFieldChanged(9);
                        this.hasChanged[10] = true;
                        this.fireFieldChanged(10);
                    } else {
                        this.vfRun = false;
                        this.hasChanged[5] = true;
                        this.fireFieldChanged(5);
                        this.hasChanged[10] = true;
                        this.fireFieldChanged(10);
                    }
                }
            } else if (this.time_changed && d2 > 0.0 && this.vfCurrentTime >= this.vfStartTime && this.vfCurrentTime <= this.vfStopTime) {
                this.vfFraction = (float)((this.vfCurrentTime - this.vfStartTime) / d2);
                this.hasChanged[9] = true;
                this.fireFieldChanged(9);
                this.time_changed = false;
            }
        }
        this.previous_clock_time = d;
    }

    public void setLoop(boolean bl) {
        if (bl != this.vfLoop) {
            this.vfLoop = bl;
            if (!this.inSetup) {
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
            }
        }
    }

    public boolean getLoop() {
        return this.vfLoop;
    }

    public void setStartTime(double d) {
        if (!this.vfIsActive && d != this.vfStartTime) {
            this.vfStartTime = d;
            if (!this.inSetup) {
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                this.time_changed = true;
            }
        }
    }

    public double getStartTime() {
        return this.vfStartTime;
    }

    public void setStopTime(double d) {
        if (!this.vfIsActive && d != this.vfStopTime) {
            this.vfStopTime = d;
            if (!this.inSetup) {
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                this.time_changed = true;
            }
        }
    }

    public double getStopTime() {
        return this.vfStopTime;
    }

    public void setDirection(boolean bl) {
        if (bl != this.vfDirection) {
            this.vfDirection = bl;
            if (!this.inSetup) {
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
            }
        }
    }

    public void setRun(boolean bl) {
        if (bl != this.vfRun) {
            this.vfRun = bl;
            if (!this.inSetup) {
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
            }
            if (!this.vfRun && this.vfIsActive) {
                this.vfIsActive = false;
                if (!this.inSetup) {
                    this.hasChanged[10] = true;
                    this.fireFieldChanged(10);
                }
            }
        }
    }

    public void setRate(float f) {
        if (f != this.vfRate) {
            this.vfRate = f;
            if (!this.inSetup) {
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
            }
        }
    }

    public void setCurrentTime(double d) {
        if (!this.vfIsActive && d != this.vfCurrentTime) {
            this.vfCurrentTime = d;
            if (!this.inSetup) {
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                this.time_changed = true;
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseTimeController.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTimeController.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "direction");
        BaseTimeController.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseTimeController.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "loop");
        BaseTimeController.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "rate");
        BaseTimeController.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFBool", "run");
        BaseTimeController.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFTime", "currentTime");
        BaseTimeController.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFTime", "startTime");
        BaseTimeController.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFTime", "stopTime");
        BaseTimeController.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseTimeController.fieldDecl[9] = new VRMLFieldDeclaration(4, "SFFloat", "fraction_changed");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("direction", n);
        fieldMap.put("set_direction", n);
        fieldMap.put("direction_changed", n);
        n = new Integer(2);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("loop", n);
        fieldMap.put("set_loop", n);
        fieldMap.put("loop_changed", n);
        n = new Integer(4);
        fieldMap.put("rate", n);
        fieldMap.put("set_rate", n);
        fieldMap.put("rate_changed", n);
        n = new Integer(5);
        fieldMap.put("run", n);
        fieldMap.put("set_run", n);
        fieldMap.put("run_changed", n);
        n = new Integer(6);
        fieldMap.put("currentTime", n);
        fieldMap.put("set_currentTime", n);
        fieldMap.put("currentTime_changed", n);
        n = new Integer(7);
        fieldMap.put("startTime", n);
        fieldMap.put("set_startTime", n);
        fieldMap.put("startTime_changed", n);
        n = new Integer(8);
        fieldMap.put("stopTime", n);
        fieldMap.put("set_stopTime", n);
        fieldMap.put("stopTime_changed", n);
        n = new Integer(10);
        fieldMap.put("isActive", new Integer(n));
        fieldMap.put("isActive_changed", new Integer(n));
        n = new Integer(9);
        fieldMap.put("fraction", new Integer(n));
        fieldMap.put("fraction_changed", new Integer(n));
    }
}

