/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.image.NIOBufferImage;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureProperties2DNodeType;
import org.web3d.vrml.nodes.VRMLTimeControlledNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.nodes.VRMLTimeListener;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.renderer.common.input.movie.MovieDecoder;
import org.web3d.vrml.renderer.common.input.movie.VideoStreamHandler;
import org.web3d.vrml.renderer.common.nodes.BaseTimeControlledNode;
import org.web3d.vrml.util.URLChecker;

public class BaseMovieTexture
extends BaseTimeControlledNode
implements VRMLSingleExternalNodeType,
VRMLTimeListener,
VRMLTimeDependentNodeType,
VRMLTexture2DNodeType,
FrameStateListener,
VideoStreamHandler {
    private static final int[] SECONDARY_TYPE = new int[]{44, 52, 3};
    private static final int FIELD_SPEED = 7;
    private static final int FIELD_URL = 8;
    private static final int FIELD_REPEAT_S = 9;
    private static final int FIELD_REPEAT_T = 10;
    private static final int FIELD_DURATION = 11;
    private static final int FIELD_IS_ACTIVE = 12;
    protected static final int FIELD_TEXTURE_PROPERTIES = 13;
    private static final int LAST_AUDIOCLIP_INDEX = 13;
    private static final int NUM_FIELDS = 14;
    protected static final String TEXTURE_PROPS_PROTO_MSG = "Proto does not describe a TextureProperties object";
    protected static final String TEXTURE_PROPS_NODE_MSG = "Node does not describe a TextureProperties object";
    protected static final String TEXPROPS_VERSION_MSG = "The textureProperties field is not available before X3D V3.2";
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    private static int[] urlFieldIndexList;
    private VRMLClock vrmlClock;
    private boolean isTimeListening;
    protected float vfSpeed;
    protected String[] vfURL;
    protected boolean vfRepeatS;
    protected boolean vfRepeatT;
    protected double vfDuration;
    protected boolean vfIsActive;
    protected VRMLProtoInstance pTextureProperties;
    protected VRMLTextureProperties2DNodeType vfTextureProperties;
    private ArrayList urlListeners = new ArrayList();
    protected ArrayList textureListeners;
    private ArrayList contentListeners = new ArrayList();
    private int loadState = 1;
    private String worldURL;
    private MovieDecoder movieDecoder;

    public BaseMovieTexture() {
        super("MovieTexture");
        this.textureListeners = new ArrayList();
        this.hasChanged = new boolean[14];
        this.vfURL = FieldConstants.EMPTY_MFSTRING;
        this.vfIsActive = false;
        this.vfLoop = false;
        this.vfSpeed = 1.0f;
        this.vfStartTime = 0.0;
        this.vfStopTime = 0.0;
        this.vfRepeatS = true;
        this.vfRepeatT = true;
        this.vfDuration = -1.0;
        this.isTimeListening = false;
        try {
            this.movieDecoder = new MovieDecoder(this);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println("Error creating movie decoder : " + noClassDefFoundError.toString());
        }
    }

    public void copy(VRMLNodeType vRMLNodeType) {
        this.checkNodeType(vRMLNodeType);
        try {
            super.copy((VRMLTimeControlledNodeType)vRMLNodeType);
            int n = vRMLNodeType.getFieldIndex("loop");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setLoop(vRMLFieldData.booleanValue);
            n = vRMLNodeType.getFieldIndex("repeatS");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRepeatS = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("repeatT");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRepeatT = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("speed");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setSpeed(vRMLFieldData.floatValue);
            n = vRMLNodeType.getFieldIndex("url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setUrl(vRMLFieldData.stringArrayValue, vRMLFieldData.numElements);
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getTextureType() {
        return 0;
    }

    public String getCacheString(int n) {
        return null;
    }

    public void addTextureListener(VRMLTextureListener vRMLTextureListener) {
        if (!this.textureListeners.contains(vRMLTextureListener)) {
            this.textureListeners.add(vRMLTextureListener);
        }
    }

    public void removeTextureListener(VRMLTextureListener vRMLTextureListener) {
        this.textureListeners.remove(vRMLTextureListener);
    }

    public NIOBufferImage getImage() {
        return null;
    }

    public boolean getRepeatS() {
        return this.vfRepeatS;
    }

    public boolean getRepeatT() {
        return this.vfRepeatT;
    }

    public VRMLNodeType getTextureProperties() throws InvalidFieldException {
        if (this.vrmlMajorVersion <= 3 && this.vrmlMinorVersion < 2) {
            InvalidFieldException invalidFieldException = new InvalidFieldException(TEXPROPS_VERSION_MSG);
            invalidFieldException.setFieldName("TextureProperties");
            throw invalidFieldException;
        }
        if (this.pTextureProperties != null) {
            return this.pTextureProperties;
        }
        return this.vfTextureProperties;
    }

    public void setTextureProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldException {
        if (this.vrmlMajorVersion <= 3 && this.vrmlMinorVersion < 2) {
            InvalidFieldException invalidFieldException = new InvalidFieldException(TEXPROPS_VERSION_MSG);
            invalidFieldException.setFieldName("TextureProperties");
            throw invalidFieldException;
        }
        Object object = this.pTextureProperties != null ? this.pTextureProperties : this.vfTextureProperties;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLTextureProperties2DNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROPS_PROTO_MSG);
            }
            this.pTextureProperties = (VRMLProtoInstance)vRMLNodeType;
            this.vfTextureProperties = (VRMLTextureProperties2DNodeType)vRMLNodeType2;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTextureProperties2DNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROPS_NODE_MSG);
            }
            this.pTextureProperties = null;
            this.vfTextureProperties = (VRMLTextureProperties2DNodeType)vRMLNodeType;
        }
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
        if (!this.inSetup) {
            if (object != null) {
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    public void setStartTime(double d) {
        if (!this.vfIsActive) {
            super.setStartTime(d);
            if (this.vrmlClock != null) {
                this.resetTimeListener(this.vrmlClock.getTime());
            }
        }
    }

    public void setStopTime(double d) {
        if (!this.vfIsActive || !(d < this.vfStartTime)) {
            super.setStopTime(d);
            if (this.vrmlClock == null) {
                this.resetTimeListener(0.0);
            } else {
                this.resetTimeListener(this.vrmlClock.getTime());
            }
        }
    }

    public void setIsActive(boolean bl) {
        if (this.vfIsActive != bl) {
            this.vfIsActive = bl;
            if (!this.inSetup) {
                if (this.vfIsActive) {
                    this.movieRewind();
                    this.movieStart();
                } else {
                    this.movieStop();
                }
                this.hasChanged[12] = true;
                this.fireFieldChanged(12);
            }
        }
    }

    public void setSpeed(float f) {
        if (this.vfSpeed != f && f > 0.0f) {
            this.vfSpeed = f;
            this.movieSetSpeed(this.vfSpeed);
            if (!this.inSetup) {
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
            }
        }
    }

    public void setDuration(double d) {
        if (d != this.vfDuration) {
            this.vfDuration = d;
            if (!this.inSetup) {
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
            }
        }
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int getPrimaryType() {
        return 50;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 13) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSpeed;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfRepeatS;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfRepeatT;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfURL;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfURL.length;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfDuration;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 13: {
                if (this.vrmlMajorVersion <= 3 && this.vrmlMinorVersion < 2) {
                    InvalidFieldException invalidFieldException = new InvalidFieldException(TEXPROPS_VERSION_MSG);
                    invalidFieldException.setFieldName("TextureProperties");
                    throw invalidFieldException;
                }
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pTextureProperties != null ? this.pTextureProperties : this.vfTextureProperties;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pTextureProperties != null) {
            this.pTextureProperties.setupFinished();
        } else if (this.vfTextureProperties != null) {
            this.vfTextureProperties.setupFinished();
        }
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 13: {
                    if (this.pTextureProperties != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pTextureProperties);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfTextureProperties);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException {
        switch (n) {
            case 9: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot write to repeatS");
                }
                this.vfRepeatS = bl;
                break;
            }
            case 10: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot write to repeatT");
                }
                this.vfRepeatT = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.setUrl(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                if (f < 0.0f) {
                    throw new InvalidFieldValueException("Invalid speed, must be >0: " + f);
                }
                this.setSpeed(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 13: {
                this.setTextureProperties(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void fireUrlChanged(int n) {
        int n2 = this.urlListeners.size();
        for (int i = 0; i < n2; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged((VRMLNodeType)this, n);
        }
    }

    protected void fireContentStateChanged() {
        int n = this.contentListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged((VRMLNodeType)this, 8, this.loadState);
        }
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        switch (n) {
            case 2: {
                break;
            }
            case 3: {
                if (!this.vfLoop) break;
                this.setIsActive(true);
                break;
            }
            case 4: {
                if (this.vfURL == null || this.vfURL.length <= 0) break;
                System.out.println("Movie Loading failed: " + this.vfURL[0]);
                break;
            }
            case 1: {
                break;
            }
            default: {
                System.out.println("Unknown state: " + n);
            }
        }
        this.loadState = n;
        this.fireContentStateChanged();
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfURL = n > 0 ? (this.worldURL != null ? URLChecker.checkURLs((String)this.worldURL, (String[])stringArray, (boolean)false) : stringArray) : FieldConstants.EMPTY_MFSTRING;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public String[] getUrl() {
        return this.vfURL;
    }

    public boolean checkValidContentType(String string) {
        return true;
    }

    public void setLoadedURI(String string) {
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
        String string2 = this.vfURL[0];
        if (this.movieDecoder == null) {
            throw new IllegalArgumentException("JMF not available");
        }
        this.movieDecoder.init(string2);
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        if (this.vfURL != null) {
            URLChecker.checkURLsInPlace((String)this.worldURL, (String[])this.vfURL, (boolean)false);
        }
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
        this.resetTimeListener(this.vrmlClock.getTime());
    }

    public void timeClick(long l) {
        this.resetTimeListener(l);
    }

    public float getSpeed() {
        return this.vfSpeed;
    }

    public double getDuration() {
        return this.vfDuration;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    public void videoStreamFrame(NIOBufferImage nIOBufferImage) {
    }

    public void videoStreamFormat(int n, int n2) {
    }

    public void videoStreamStop() {
        if (this.vfIsActive) {
            if (this.vfLoop) {
                this.movieRewind();
                this.movieStart();
            } else {
                this.setIsActive(false);
            }
        }
    }

    public void videoStreamStart() {
    }

    public void videoStreamDuration(double d) {
        this.setDuration(d);
    }

    private void movieStart() {
        if (this.movieDecoder != null) {
            this.movieDecoder.start();
        }
    }

    private void movieRewind() {
        if (this.movieDecoder != null) {
            this.movieDecoder.rewind();
        }
    }

    private void movieStop() {
        if (this.movieDecoder != null) {
            this.movieDecoder.stop();
        }
    }

    private void movieSetSpeed(float f) {
        if (this.movieDecoder != null) {
            this.movieDecoder.setRate(f);
        }
    }

    protected void fireTextureImageChanged(int n, VRMLTextureNodeType vRMLTextureNodeType, NIOBufferImage nIOBufferImage, String string) {
        int n2 = this.textureListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                VRMLTextureListener vRMLTextureListener = (VRMLTextureListener)this.textureListeners.get(i);
                vRMLTextureListener.textureImageChanged(n, (VRMLNodeType)vRMLTextureNodeType, nIOBufferImage, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending textureImpl changed message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void resetTimeListener(double d) {
        if (this.vfIsActive) {
            if (this.vfStopTime > this.vfStartTime && d >= this.vfStopTime) {
                this.setIsActive(false);
            }
        } else if (this.vfStartTime <= d && (this.vfStopTime < this.vfStartTime || this.vfStopTime > d)) {
            this.setIsActive(true);
        }
        boolean bl = false;
        if (this.vfIsActive) {
            if (this.vfStopTime > this.vfStartTime) {
                bl = true;
            }
        } else if (this.vfStartTime >= d) {
            bl = true;
        }
        if (this.vrmlClock != null && bl != this.isTimeListening) {
            if (this.isTimeListening) {
                this.vrmlClock.removeTimeListener((VRMLTimeListener)this);
            } else {
                this.vrmlClock.addTimeListener((VRMLTimeListener)this);
            }
            this.isTimeListening = bl;
        }
    }

    static {
        nodeFields = new int[]{0, 13};
        fieldDecl = new VRMLFieldDeclaration[14];
        fieldMap = new HashMap(42);
        BaseMovieTexture.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMovieTexture.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "loop");
        BaseMovieTexture.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "speed");
        BaseMovieTexture.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFTime", "startTime");
        BaseMovieTexture.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFTime", "stopTime");
        BaseMovieTexture.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFTime", "pauseTime");
        BaseMovieTexture.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFTime", "resumeTime");
        BaseMovieTexture.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFTime", "elapsedTime");
        BaseMovieTexture.fieldDecl[9] = new VRMLFieldDeclaration(2, "SFBool", "repeatS");
        BaseMovieTexture.fieldDecl[10] = new VRMLFieldDeclaration(2, "SFBool", "repeatT");
        BaseMovieTexture.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "url");
        BaseMovieTexture.fieldDecl[13] = new VRMLFieldDeclaration(2, "SFNode", "textureProperties");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("loop", n);
        fieldMap.put("set_loop", n);
        fieldMap.put("loop_changed", n);
        n = new Integer(7);
        fieldMap.put("speed", n);
        fieldMap.put("set_speed", n);
        fieldMap.put("speed_changed", n);
        n = new Integer(2);
        fieldMap.put("startTime", n);
        fieldMap.put("set_startTime", n);
        fieldMap.put("startTime_changed", n);
        n = new Integer(3);
        fieldMap.put("stopTime", n);
        fieldMap.put("set_stopTime", n);
        fieldMap.put("stopTime_changed", n);
        n = new Integer(4);
        fieldMap.put("pauseTime", n);
        fieldMap.put("set_pauseTime", n);
        fieldMap.put("pauseTime_changed", n);
        n = new Integer(5);
        fieldMap.put("resumeTime", n);
        fieldMap.put("set_resumeTime", n);
        fieldMap.put("resumeTime_changed", n);
        n = new Integer(9);
        fieldMap.put("repeatS", n);
        n = new Integer(10);
        fieldMap.put("repeatT", n);
        n = new Integer(13);
        fieldMap.put("textureProperties", n);
        n = new Integer(8);
        fieldMap.put("url", n);
        fieldMap.put("set_url", n);
        fieldMap.put("url_changed", n);
        fieldMap.put("isActive", new Integer(12));
        fieldMap.put("duration_changed", new Integer(11));
        fieldMap.put("elapsedTime", new Integer(6));
        urlFieldIndexList = new int[1];
        BaseMovieTexture.urlFieldIndexList[0] = 8;
    }
}

