/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.renderer.common.nodes.BaseTexture2DNode;
import org.web3d.vrml.util.URLChecker;

public class BaseImageTexture
extends BaseTexture2DNode
implements VRMLSingleExternalNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{44};
    protected static final int FIELD_URL = 4;
    private static final int LAST_IMAGETEXTURE_INDEX = 4;
    private static final int NUM_FIELDS = 5;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected String[] vfURL;
    protected int loadState;
    private String worldURL;
    private ArrayList urlListeners;
    private ArrayList contentListeners = new ArrayList();
    protected String loadedURI;

    protected BaseImageTexture() {
        super("ImageTexture");
        this.urlListeners = new ArrayList(1);
        this.hasChanged = new boolean[5];
        this.vfURL = FieldConstants.EMPTY_MFSTRING;
        this.loadState = 1;
    }

    protected BaseImageTexture(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("url");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfURL = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfURL, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public String getCacheString(int n) {
        return null;
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (this.loadedURI == null) break;
                System.out.println("Loading failed: " + this.loadedURI);
                break;
            }
            default: {
                System.out.println("Unknown state: " + n);
            }
        }
        this.loadState = n;
        if (n != 3) {
            this.fireContentStateChanged();
        }
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        this.worldURL = string;
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfURL = n > 0 ? (this.worldURL != null ? URLChecker.checkURLs((String)this.worldURL, (String[])stringArray, (boolean)false) : stringArray) : FieldConstants.EMPTY_MFSTRING;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public String[] getUrl() {
        if (this.worldURL != null) {
            URLChecker.checkURLsInPlace((String)this.worldURL, (String[])this.vfURL, (boolean)false);
        }
        return this.vfURL;
    }

    public boolean checkValidContentType(String string) {
        return string.indexOf("image") >= 0;
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
    }

    public void setLoadedURI(String string) {
        this.loadedURI = string;
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 50;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfURL;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfURL.length;
                break;
            }
            default: {
                return super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfURL, this.vfURL.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.vfURL = new String[1];
                this.vfURL[0] = string;
                if (this.inSetup) break;
                this.loadState = 1;
                this.fireUrlChanged(n);
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.vfURL = new String[n2];
                System.arraycopy(stringArray, 0, this.vfURL, 0, n2);
                if (this.inSetup) break;
                this.loadState = 1;
                this.fireUrlChanged(n);
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    protected void fireUrlChanged(int n) {
        int n2 = this.urlListeners.size();
        for (int i = 0; i < n2; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged((VRMLNodeType)this, n);
        }
    }

    protected void fireContentStateChanged() {
        int n = this.contentListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged((VRMLNodeType)this, 4, this.loadState);
        }
    }

    static {
        nodeFields = new int[]{0, 3};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseImageTexture.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseImageTexture.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "repeatS");
        BaseImageTexture.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFBool", "repeatT");
        BaseImageTexture.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFString", "url");
        BaseImageTexture.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFNode", "textureProperties");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("url", n);
        fieldMap.put("set_url", n);
        fieldMap.put("url_changed", n);
        fieldMap.put("repeatS", new Integer(1));
        fieldMap.put("repeatT", new Integer(2));
        fieldMap.put("textureProperties", new Integer(3));
    }
}

