/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSurfaceChildNodeType;
import org.web3d.vrml.nodes.VRMLSurfaceLayoutListener;
import org.web3d.vrml.nodes.VRMLSurfaceLayoutNodeType;
import org.web3d.vrml.renderer.common.nodes.surface.BaseSurfaceChildNode;

public abstract class BaseSurfaceLayoutNode
extends BaseSurfaceChildNode
implements VRMLSurfaceLayoutNodeType,
VRMLSurfaceLayoutListener {
    protected static final int FIELD_CHILDREN = 3;
    protected static final int LAST_LAYOUT_INDEX = 3;
    protected static final String BAD_PROTO_MSG = "Proto does not describe a SurfaceChildNode object";
    protected static final String BAD_NODE_MSG = "Node does not describe a SurfaceChildNode object";
    protected VRMLNodeType[] vfChildren = new VRMLNodeType[0];

    protected BaseSurfaceLayoutNode(String string) {
        super(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.updateVisibility();
    }

    public void setParentVisible(boolean bl) {
        super.setParentVisible(bl);
        this.updateVisibility();
    }

    public void setChildren(VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldValueException {
        if (vRMLNodeTypeArray == null) {
            this.vfChildren = null;
        } else {
            for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                if (vRMLNodeTypeArray[i] instanceof VRMLSurfaceChildNodeType) continue;
                if (!(vRMLNodeTypeArray[i] instanceof VRMLProtoInstance)) {
                    throw new InvalidFieldValueException(BAD_NODE_MSG);
                }
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeTypeArray[i];
                VRMLNodeType vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                if (vRMLNodeType instanceof VRMLSurfaceChildNodeType) continue;
                throw new InvalidFieldValueException(BAD_PROTO_MSG);
            }
            this.vfChildren = vRMLNodeTypeArray;
        }
        this.updateVisibility();
        this.hasChanged[3] = true;
        this.fireFieldChanged(3);
    }

    public VRMLNodeType[] getChildren() {
        return this.vfChildren;
    }

    public void windowChanged(int n, int n2, int n3, int n4) {
        this.screenBounds.setBounds(n, n2, n3, n4);
        this.updateManagedNodes();
    }

    public void surfaceResized(int n, int n2) {
        this.updateManagedNodes();
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfChildren == null ? 0 : this.vfChildren.length;
        for (int i = 0; i < n; ++i) {
            if (this.vfChildren[i] == null) continue;
            this.vfChildren[i].setupFinished();
        }
        this.updateVisibility();
    }

    public int getPrimaryType() {
        return 62;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.vfChildren;
                vRMLFieldData.numElements = this.vfChildren == null ? 0 : this.vfChildren.length;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            default: {
                return super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfChildren, this.vfChildren.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 3: {
                if (this.inSetup) {
                    this.appendNode(vRMLNodeType);
                    break;
                }
                this.setChildren(new VRMLNodeType[]{vRMLNodeType});
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.setChildren(vRMLNodeTypeArray);
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    protected void updateManagedNodes() {
    }

    protected void appendNode(VRMLNodeType vRMLNodeType) {
        VRMLNodeType[] vRMLNodeTypeArray;
        if (vRMLNodeType != null) {
            if (vRMLNodeType instanceof VRMLSurfaceChildNodeType) {
                ((VRMLSurfaceChildNodeType)vRMLNodeType).setLayoutListener((VRMLSurfaceLayoutListener)this);
            } else {
                if (!(vRMLNodeType instanceof VRMLProtoInstance)) {
                    throw new InvalidFieldValueException(BAD_NODE_MSG);
                }
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                vRMLNodeTypeArray = vRMLProtoInstance.getImplementationNode();
                if (!(vRMLNodeTypeArray instanceof VRMLSurfaceChildNodeType)) {
                    throw new InvalidFieldValueException(BAD_PROTO_MSG);
                }
                ((VRMLSurfaceChildNodeType)vRMLNodeTypeArray).setLayoutListener((VRMLSurfaceLayoutListener)this);
            }
        }
        if (this.vfChildren != null) {
            int n = this.vfChildren.length + 1;
            vRMLNodeTypeArray = new VRMLNodeType[n];
            System.arraycopy(this.vfChildren, 0, vRMLNodeTypeArray, 0, n - 1);
            this.vfChildren = vRMLNodeTypeArray;
            this.vfChildren[n - 1] = vRMLNodeType;
        } else {
            this.vfChildren = new VRMLNodeType[]{vRMLNodeType};
        }
    }

    private void updateVisibility() {
        for (int i = 0; i < this.vfChildren.length; ++i) {
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType;
            if (!(this.vfChildren[i] instanceof VRMLSurfaceChildNodeType)) {
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)this.vfChildren[i];
                vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)vRMLProtoInstance.getImplementationNode();
            } else {
                vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)this.vfChildren[i];
            }
            vRMLSurfaceChildNodeType.setParentVisible(this.vfVisible && this.parentVisibility);
        }
    }
}

