/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import java.awt.Rectangle;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSurfaceChildNodeType;
import org.web3d.vrml.nodes.VRMLSurfaceLayoutListener;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseSurfaceChildNode
extends AbstractNode
implements VRMLSurfaceChildNodeType {
    protected static final int FIELD_VISIBLE = 1;
    protected static final int FIELD_BBOX_SIZE = 2;
    protected static final int LAST_SURFACE_CHILD_INDEX = 2;
    protected boolean vfVisible = true;
    protected float[] screenLocation;
    protected float[] vfBboxSize = new float[]{-1.0f, -1.0f};
    protected Rectangle screenBounds;
    protected VRMLSurfaceLayoutListener listener;
    protected boolean parentVisibility = true;

    protected BaseSurfaceChildNode(String string) {
        super(string);
        this.screenLocation = new float[2];
        this.screenBounds = new Rectangle();
    }

    protected void copy(VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType) {
        float[] fArray = vRMLSurfaceChildNodeType.getBboxSize();
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
        this.screenBounds.setBounds(rectangle);
        this.screenLocation[0] = rectangle.x;
        this.screenLocation[1] = rectangle.y;
        this.vfVisible = vRMLSurfaceChildNodeType.isVisible();
        this.parentVisibility = vRMLSurfaceChildNodeType.getParentVisible();
    }

    public boolean isVisible() {
        return this.vfVisible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.vfVisible) {
            this.vfVisible = bl;
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public void setParentVisible(boolean bl) {
        this.parentVisibility = bl;
    }

    public boolean getParentVisible() {
        return this.parentVisibility;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public Rectangle getRealBounds() {
        return this.screenBounds;
    }

    public void setLocation(int n, int n2) {
        this.screenLocation[0] = n;
        this.screenLocation[1] = n2;
        this.screenBounds.x = n;
        this.screenBounds.y = n2;
    }

    public void setLayoutListener(VRMLSurfaceLayoutListener vRMLSurfaceLayoutListener) {
        this.listener = vRMLSurfaceLayoutListener;
    }

    public int getPrimaryType() {
        return 61;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfVisible;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxSize;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfVisible);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.vfBboxSize[0] != -1.0f) {
            this.screenBounds.width = (int)this.vfBboxSize[0];
        }
        if (this.vfBboxSize[1] != -1.0f) {
            this.screenBounds.height = (int)this.vfBboxSize[1];
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setVisible(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.setBboxSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void fireSizeChange(int n, int n2) {
        if (this.listener == null) {
            return;
        }
        try {
            this.listener.surfaceResized(n, n2);
        }
        catch (Exception exception) {
            System.out.println("Error on surface resize " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void setBboxSize(float[] fArray) throws InvalidFieldValueException, InvalidFieldAccessException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("bboxSize cannot be changed at runtime");
        }
        FieldValidator.checkBBoxSize2D((String)this.getVRMLNodeName(), (float[])fArray);
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
    }
}

