/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.shape;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.MaterialColorListener;
import org.web3d.vrml.nodes.MaterialColorListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMaterialNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseTwoSidedMaterial
extends AbstractNode
implements VRMLMaterialNodeType {
    protected static final int FIELD_AMBIENT_INTENSITY = 1;
    protected static final int FIELD_BACK_AMBIENT_INTENSITY = 2;
    protected static final int FIELD_DIFFUSE_COLOR = 3;
    protected static final int FIELD_BACK_DIFFUSE_COLOR = 4;
    protected static final int FIELD_EMISSIVE_COLOR = 5;
    protected static final int FIELD_BACK_EMISSIVE_COLOR = 6;
    protected static final int FIELD_SHININESS = 7;
    protected static final int FIELD_BACK_SHININESS = 8;
    protected static final int FIELD_SPECULAR_COLOR = 9;
    protected static final int FIELD_BACK_SPECULAR_COLOR = 10;
    protected static final int FIELD_TRANSPARENCY = 11;
    protected static final int FIELD_BACK_TRANSPARENCY = 12;
    protected static final int FIELD_SEPARATE_BACK_COLOR = 13;
    protected static final int NUM_FIELDS = 14;
    private static final String EMISSIVE_ERROR_MSG = "Error sending emissive changed notification to: ";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float vfAmbientIntensity;
    protected float vfBackAmbientIntensity;
    protected float[] vfDiffuseColor;
    protected float[] vfBackDiffuseColor;
    protected float[] vfEmissiveColor;
    protected float[] vfBackEmissiveColor;
    protected float vfShininess;
    protected float vfBackShininess;
    protected float[] vfSpecularColor;
    protected float[] vfBackSpecularColor;
    protected float vfTransparency;
    protected float vfBackTransparency;
    protected boolean vfSeparateBackColor;
    protected boolean ignoreDiffuse;
    private MaterialColorListener colorListener;

    protected BaseTwoSidedMaterial() {
        super("TwoSidedMaterial");
        this.hasChanged = new boolean[14];
        this.vfAmbientIntensity = 0.2f;
        this.vfBackAmbientIntensity = 0.2f;
        this.vfDiffuseColor = new float[]{0.8f, 0.8f, 0.8f};
        this.vfBackDiffuseColor = new float[]{0.8f, 0.8f, 0.8f};
        this.vfEmissiveColor = new float[]{0.0f, 0.0f, 0.0f};
        this.vfBackEmissiveColor = new float[]{0.0f, 0.0f, 0.0f};
        this.vfShininess = 0.2f;
        this.vfBackShininess = 0.2f;
        this.vfSpecularColor = new float[]{0.0f, 0.0f, 0.0f};
        this.vfBackSpecularColor = new float[]{0.0f, 0.0f, 0.0f};
        this.vfTransparency = 0.0f;
        this.vfBackTransparency = 0.0f;
        this.vfSeparateBackColor = true;
    }

    protected BaseTwoSidedMaterial(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("shininess");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfShininess = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("backShininess");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBackShininess = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("transparency");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTransparency = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("backTransparency");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBackTransparency = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("ambientIntensity");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAmbientIntensity = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("backAmbientIntensity");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBackAmbientIntensity = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("separateBackColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSeparateBackColor = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("diffuseColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDiffuseColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfDiffuseColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfDiffuseColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("backDiffuseColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBackDiffuseColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBackDiffuseColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBackDiffuseColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("emissiveColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEmissiveColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfEmissiveColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfEmissiveColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("backEmissiveColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBackEmissiveColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBackEmissiveColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBackEmissiveColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("specularColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSpecularColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfSpecularColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfSpecularColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("backSpecularColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBackSpecularColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBackSpecularColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBackSpecularColor[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.ambientIntensity", (float)f);
        this.vfAmbientIntensity = f;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public float getAmbientIntensity() {
        return this.vfAmbientIntensity;
    }

    public void setDiffuseColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.diffuseColor", (float[])fArray);
        this.vfDiffuseColor[0] = fArray[0];
        this.vfDiffuseColor[1] = fArray[1];
        this.vfDiffuseColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public float[] getDiffuseColor() {
        return this.vfDiffuseColor;
    }

    public void setEmissiveColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.emmissiveColor", (float[])fArray);
        this.vfEmissiveColor[0] = fArray[0];
        this.vfEmissiveColor[1] = fArray[1];
        this.vfEmissiveColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
            this.fireEmissiveColorChanged(this.colorListener);
        }
    }

    public float[] getEmissiveColor() {
        return this.vfEmissiveColor;
    }

    public void setShininess(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.shininess", (float)f);
        this.vfShininess = f;
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    public float getShininess() {
        return this.vfShininess;
    }

    public void setSpecularColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.specularColor", (float[])fArray);
        this.vfSpecularColor[0] = fArray[0];
        this.vfSpecularColor[1] = fArray[1];
        this.vfSpecularColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public float[] getSpecularColor() {
        return this.vfSpecularColor;
    }

    public void setTransparency(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.transparency", (float)f);
        this.vfTransparency = f;
        if (!this.inSetup) {
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    public void setIgnoreDiffuse(boolean bl) {
        this.ignoreDiffuse = bl;
    }

    public float getTransparency() {
        return this.vfTransparency;
    }

    public void addMaterialColorListener(MaterialColorListener materialColorListener) {
        this.colorListener = MaterialColorListenerMulticaster.add((MaterialColorListener)this.colorListener, (MaterialColorListener)materialColorListener);
        if (materialColorListener != null) {
            this.fireEmissiveColorChanged(materialColorListener);
        }
    }

    public void removeMaterialColorListener(MaterialColorListener materialColorListener) {
        this.colorListener = MaterialColorListenerMulticaster.remove((MaterialColorListener)this.colorListener, (MaterialColorListener)materialColorListener);
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 13) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 29;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAmbientIntensity;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfBackAmbientIntensity;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfDiffuseColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBackDiffuseColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfEmissiveColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBackEmissiveColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfTransparency;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfBackTransparency;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfShininess;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfBackShininess;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSpecularColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBackSpecularColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfSeparateBackColor;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfAmbientIntensity);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfBackAmbientIntensity);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfDiffuseColor, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfBackDiffuseColor, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfEmissiveColor, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfBackEmissiveColor, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfShininess);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfBackShininess);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfSpecularColor, 3);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfBackSpecularColor, 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfTransparency);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfBackTransparency);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfSeparateBackColor);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 13: {
                this.setSeparateBackColor(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setAmbientIntensity(f);
                break;
            }
            case 2: {
                this.setBackAmbientIntensity(f);
                break;
            }
            case 7: {
                this.setShininess(f);
                break;
            }
            case 8: {
                this.setBackShininess(f);
                break;
            }
            case 11: {
                this.setTransparency(f);
                break;
            }
            case 12: {
                this.setBackTransparency(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setDiffuseColor(fArray);
                break;
            }
            case 4: {
                this.setBackDiffuseColor(fArray);
                break;
            }
            case 5: {
                this.setEmissiveColor(fArray);
                break;
            }
            case 6: {
                this.setBackEmissiveColor(fArray);
                break;
            }
            case 9: {
                this.setSpecularColor(fArray);
                break;
            }
            case 10: {
                this.setBackSpecularColor(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setBackAmbientIntensity(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.backAmbientIntensity", (float)f);
        this.vfBackAmbientIntensity = f;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected void setBackDiffuseColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.backDiffuseColor", (float[])fArray);
        this.vfBackDiffuseColor[0] = fArray[0];
        this.vfBackDiffuseColor[1] = fArray[1];
        this.vfBackDiffuseColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    protected void setBackEmissiveColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.backEmissiveColor", (float[])fArray);
        this.vfBackEmissiveColor[0] = fArray[0];
        this.vfBackEmissiveColor[1] = fArray[1];
        this.vfBackEmissiveColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    protected void setBackShininess(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.backShininess", (float)f);
        this.vfBackShininess = f;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    protected void setBackSpecularColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.backSpecularColor", (float[])fArray);
        this.vfBackSpecularColor[0] = fArray[0];
        this.vfBackSpecularColor[1] = fArray[1];
        this.vfBackSpecularColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    protected void setBackTransparency(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.backTransparency", (float)f);
        this.vfBackTransparency = f;
        if (!this.inSetup) {
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
    }

    protected void setSeparateBackColor(boolean bl) {
        this.vfSeparateBackColor = bl;
        if (!this.inSetup) {
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    private void fireEmissiveColorChanged(MaterialColorListener materialColorListener) {
        try {
            if (materialColorListener != null) {
                materialColorListener.emissiveColorChanged(this.vfEmissiveColor);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                this.errorReporter.errorReport(EMISSIVE_ERROR_MSG + materialColorListener, (Exception)throwable);
            }
            System.out.println("Unknown BAAAAD error: " + throwable);
            throwable.printStackTrace();
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[14];
        fieldMap = new HashMap(42);
        BaseTwoSidedMaterial.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTwoSidedMaterial.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "ambientIntensity");
        BaseTwoSidedMaterial.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFFloat", "backAmbientIntensity");
        BaseTwoSidedMaterial.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFColor", "diffuseColor");
        BaseTwoSidedMaterial.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFColor", "backDiffuseColor");
        BaseTwoSidedMaterial.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFColor", "emissiveColor");
        BaseTwoSidedMaterial.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFColor", "backEmissiveColor");
        BaseTwoSidedMaterial.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "shininess");
        BaseTwoSidedMaterial.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "backShininess");
        BaseTwoSidedMaterial.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFColor", "specularColor");
        BaseTwoSidedMaterial.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFColor", "backSpecularColor");
        BaseTwoSidedMaterial.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFFloat", "transparency");
        BaseTwoSidedMaterial.fieldDecl[12] = new VRMLFieldDeclaration(3, "SFFloat", "backTransparency");
        BaseTwoSidedMaterial.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFBool", "separateBackColor");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("ambientIntensity", n);
        fieldMap.put("set_ambientIntensity", n);
        fieldMap.put("ambientIntensity_changed", n);
        n = new Integer(2);
        fieldMap.put("backAmbientIntensity", n);
        fieldMap.put("set_backAmbientIntensity", n);
        fieldMap.put("backAmbientIntensity_changed", n);
        n = new Integer(11);
        fieldMap.put("transparency", n);
        fieldMap.put("set_transparency", n);
        fieldMap.put("transparency_changed", n);
        n = new Integer(12);
        fieldMap.put("backTransparency", n);
        fieldMap.put("set_backTransparency", n);
        fieldMap.put("backTransparency_changed", n);
        n = new Integer(3);
        fieldMap.put("diffuseColor", n);
        fieldMap.put("set_diffuseColor", n);
        fieldMap.put("diffuseColor_changed", n);
        n = new Integer(4);
        fieldMap.put("backDiffuseColor", n);
        fieldMap.put("set_backDiffuseColor", n);
        fieldMap.put("backDiffuseColor_changed", n);
        n = new Integer(5);
        fieldMap.put("emissiveColor", n);
        fieldMap.put("set_emissiveColor", n);
        fieldMap.put("emissiveColor_changed", n);
        n = new Integer(6);
        fieldMap.put("backEmissiveColor", n);
        fieldMap.put("set_backEmissiveColor", n);
        fieldMap.put("backEmissiveColor_changed", n);
        n = new Integer(7);
        fieldMap.put("shininess", n);
        fieldMap.put("set_shininess", n);
        fieldMap.put("shininess_changed", n);
        n = new Integer(8);
        fieldMap.put("backShininess", n);
        fieldMap.put("set_backShininess", n);
        fieldMap.put("backShininess_changed", n);
        n = new Integer(9);
        fieldMap.put("specularColor", n);
        fieldMap.put("set_specularColor", n);
        fieldMap.put("specularColor_changed", n);
        n = new Integer(10);
        fieldMap.put("backSpecularColor", n);
        fieldMap.put("set_backSpecularColor", n);
        fieldMap.put("backSpecularColor_changed", n);
        n = new Integer(13);
        fieldMap.put("separateBackColor", n);
        fieldMap.put("set_separateBackColor", n);
        fieldMap.put("separateBackColor_changed", n);
    }
}

