/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.shape;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLBoundedNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseShape
extends AbstractNode
implements VRMLShapeNodeType,
VRMLBoundedNodeType,
LocalColorsListener {
    private static final int[] SECONDARY_TYPE = new int[]{6};
    protected static final int FIELD_APPEARANCE = 1;
    protected static final int FIELD_GEOMETRY = 2;
    private static final int FIELD_BBOX_SIZE = 3;
    private static final int FIELD_BBOX_CENTER = 4;
    protected static final int LAST_SHAPE_INDEX = 4;
    protected static final int NUM_FIELDS = 5;
    protected static final String GEOMETRY_PROTO_MSG = "Proto does not describe a Geometry object";
    protected static final String GEOMETRY_NODE_MSG = "Node does not describe a Geometry object";
    protected static final String APPEARANCE_PROTO_MSG = "Proto does not describe a Appearance object";
    protected static final String APPEARANCE_NODE_MSG = "Node does not describe a Appearance object";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected VRMLProtoInstance pAppearance;
    protected VRMLAppearanceNodeType vfAppearance;
    protected VRMLProtoInstance pGeometry;
    protected VRMLGeometryNodeType vfGeometry;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};

    protected BaseShape() {
        super("Shape");
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.hasChanged = new boolean[5];
    }

    protected BaseShape(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        float[] fArray = ((VRMLBoundedNodeType)vRMLNodeType).getBboxCenter();
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
        fArray = ((VRMLBoundedNodeType)vRMLNodeType).getBboxSize();
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    public VRMLNodeType getAppearance() {
        if (this.pAppearance != null) {
            return this.pAppearance;
        }
        return this.vfAppearance;
    }

    public void setAppearance(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLAppearanceNodeType vRMLAppearanceNodeType;
        Object object = this.pAppearance != null ? this.pAppearance : this.vfAppearance;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLAppearanceNodeType)) {
                throw new InvalidFieldValueException(APPEARANCE_PROTO_MSG);
            }
            vRMLAppearanceNodeType = (VRMLAppearanceNodeType)vRMLNodeType2;
            this.pAppearance = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLAppearanceNodeType)) {
                throw new InvalidFieldValueException(APPEARANCE_NODE_MSG);
            }
            this.pAppearance = null;
            vRMLAppearanceNodeType = (VRMLAppearanceNodeType)vRMLNodeType;
        }
        this.vfAppearance = vRMLAppearanceNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
        if (this.vfAppearance != null && this.vfGeometry != null) {
            this.vfAppearance.setSolid(this.vfGeometry.isSolid());
            this.vfAppearance.setLightingEnabled(this.vfGeometry.isLightingEnabled());
            this.vfAppearance.setLocalColor(this.vfGeometry.hasLocalColors(), this.vfGeometry.hasLocalColorAlpha());
            this.vfGeometry.addLocalColorsListener((LocalColorsListener)this);
            this.vfAppearance.setCCW(this.vfGeometry.isCCW());
        }
        if (!this.inSetup) {
            if (object != null) {
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public VRMLNodeType getGeometry() {
        if (this.pGeometry != null) {
            return this.pGeometry;
        }
        return this.vfGeometry;
    }

    public void setGeometry(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object = this.pGeometry != null ? this.pGeometry : this.vfGeometry;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLGeometryNodeType)) {
                throw new InvalidFieldValueException(GEOMETRY_PROTO_MSG);
            }
            this.pGeometry = (VRMLProtoInstance)vRMLNodeType;
            this.vfGeometry = (VRMLGeometryNodeType)vRMLNodeType2;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLGeometryNodeType)) {
                throw new InvalidFieldValueException(GEOMETRY_NODE_MSG);
            }
            this.pGeometry = null;
            this.vfGeometry = (VRMLGeometryNodeType)vRMLNodeType;
        }
        if (this.vfAppearance != null && this.vfGeometry != null) {
            this.vfAppearance.setSolid(this.vfGeometry.isSolid());
            this.vfAppearance.setLightingEnabled(this.vfGeometry.isLightingEnabled());
            this.vfAppearance.setLocalColor(this.vfGeometry.hasLocalColors(), this.vfGeometry.hasLocalColorAlpha());
            this.vfGeometry.addLocalColorsListener((LocalColorsListener)this);
            this.vfAppearance.setCCW(this.vfGeometry.isCCW());
        }
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
        if (!this.inSetup) {
            if (object != null) {
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public float[] getBboxCenter() {
        return this.vfBboxCenter;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pAppearance != null) {
            this.pAppearance.setupFinished();
        } else if (this.vfAppearance != null) {
            this.vfAppearance.setupFinished();
        }
        if (this.pGeometry != null) {
            this.pGeometry.setupFinished();
        } else if (this.vfGeometry != null) {
            this.vfGeometry.setupFinished();
        }
        if (this.vfAppearance != null && this.vfGeometry != null) {
            this.vfAppearance.setSolid(this.vfGeometry.isSolid());
            this.vfAppearance.setLightingEnabled(this.vfGeometry.isLightingEnabled());
            this.vfAppearance.setLocalColor(this.vfGeometry.hasLocalColors(), this.vfGeometry.hasLocalColorAlpha());
            this.vfGeometry.addLocalColorsListener((LocalColorsListener)this);
            this.vfAppearance.setCCW(this.vfGeometry.isCCW());
        }
    }

    public void localColorsChanged(boolean bl, boolean bl2) {
        if (this.vfAppearance != null) {
            this.vfAppearance.setLocalColor(bl, bl2);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 43;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pAppearance != null ? this.pAppearance : this.vfAppearance;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pGeometry != null ? this.pGeometry : this.vfGeometry;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxSize;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxCenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    if (this.pAppearance != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pAppearance);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfAppearance);
                    break;
                }
                case 2: {
                    if (this.pGeometry != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pGeometry);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfGeometry);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 4: {
                this.setBboxCenter(fArray);
                break;
            }
            case 3: {
                this.setBboxSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 1: {
                this.setAppearance(vRMLNodeType2);
                break;
            }
            case 2: {
                this.setGeometry(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    private void setBboxCenter(float[] fArray) throws InvalidFieldAccessException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("bboxCenter is initializeOnly");
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    private void setBboxSize(float[] fArray) throws InvalidFieldAccessException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("bboxSize is initializeOnly");
        }
        FieldValidator.checkBBoxSize((String)"BaseShape.bboxSize", (float[])fArray);
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    static {
        nodeFields = new int[]{1, 2, 0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseShape.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseShape.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "appearance");
        BaseShape.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "geometry");
        BaseShape.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseShape.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("appearance", n);
        fieldMap.put("set_appearance", n);
        fieldMap.put("appearance_changed", n);
        n = new Integer(2);
        fieldMap.put("geometry", n);
        fieldMap.put("set_geometry", n);
        fieldMap.put("geometry_changed", n);
        fieldMap.put("bboxSize", new Integer(3));
        fieldMap.put("bboxCenter", new Integer(4));
    }
}

