/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.shape;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointPropertiesNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BasePointProperties
extends AbstractNode
implements VRMLPointPropertiesNodeType {
    protected static final int FIELD_POINTSIZE_SCALE_FACTOR = 1;
    protected static final int FIELD_POINTSIZE_MIN_VALUE = 2;
    protected static final int FIELD_POINTSIZE_MAX_VALUE = 3;
    protected static final int FIELD_POINTSIZE_ATTENUATION = 4;
    protected static final int FIELD_COLOR_MODE = 5;
    protected static final int NUM_FIELDS = 6;
    private static final String COLOR_MODE_ERROR_MSG = "Error sending color mode changed notification to: ";
    private static final String UNKNOWN_TYPE_MSG = "The color mode provided is not recognised";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float vfPointsizeScaleFactor;
    protected float vfPointsizeMinValue;
    protected float vfPointsizeMaxValue;
    protected float[] vfPointsizeAttenuation;
    protected String vfColorMode;
    protected int colorMode;
    protected static final String TEXTURE_COLORMODE = "TEXTURE_COLOR";
    protected static final String POINT_COLORMODE = "POINT_COLOR";
    protected static final String TEXTURE_AND_POINT_COLORMODE = "TEXTURE_AND_POINT_COLOR";
    private static HashMap typeMap;

    protected BasePointProperties() {
        super("PointProperties");
        this.hasChanged = new boolean[6];
        this.vfPointsizeScaleFactor = 1.0f;
        this.vfPointsizeMinValue = 1.0f;
        this.vfPointsizeMaxValue = 1.0f;
        this.vfPointsizeAttenuation = new float[]{1.0f, 0.0f, 0.0f};
        this.vfColorMode = TEXTURE_COLORMODE;
        this.colorMode = 1;
    }

    protected BasePointProperties(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("pointsizeScaleFactor");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPointsizeScaleFactor = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("pointsizeMinValue");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPointsizeMinValue = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("pointsizeMaxValue");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPointsizeMaxValue = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("pointsizeAttenuation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfPointsizeAttenuation[0] = vRMLFieldData.floatArrayValue[0];
                this.vfPointsizeAttenuation[1] = vRMLFieldData.floatArrayValue[1];
                this.vfPointsizeAttenuation[2] = vRMLFieldData.floatArrayValue[2];
            }
            n = vRMLNodeType.getFieldIndex("colorMode");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfColorMode = vRMLFieldData.stringValue;
            this.colorMode = (Integer)typeMap.get(this.vfColorMode);
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 93;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfPointsizeScaleFactor;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfPointsizeMinValue;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfPointsizeMaxValue;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPointsizeAttenuation;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfColorMode;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfPointsizeScaleFactor);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfPointsizeMinValue);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfPointsizeMaxValue);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfPointsizeAttenuation, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfColorMode);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setColorMode(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setPointSizeScale(f);
                break;
            }
            case 2: {
                this.setPointSizeMin(f);
                break;
            }
            case 3: {
                this.setPointSizeMax(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setPointSizeAttenuation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setPointSizeScale(float f) throws InvalidFieldValueException {
        if (f <= 0.0f) {
            throw new InvalidFieldValueException("The pointsizeScaleFactor is <= 0: " + f);
        }
        this.vfPointsizeScaleFactor = f;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    protected void setPointSizeMin(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException("The pointsizeMinValue is < 0: " + f);
        }
        float f2 = this.vfPointsizeMinValue = f == 0.0f ? 1.0f : f;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected void setPointSizeMax(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException("The pointsizeMaxValue is < 0: " + f);
        }
        float f2 = this.vfPointsizeMaxValue = f == 0.0f ? 1.0f : f;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    protected void setPointSizeAttenuation(float[] fArray) throws InvalidFieldValueException {
        if (fArray[0] < 0.0f || fArray[1] < 0.0f || fArray[2] < 0.0f || fArray[0] > 1.0f || fArray[1] > 1.0f || fArray[2] > 1.0f) {
            throw new InvalidFieldValueException("attenuation value out of range [0,1]");
        }
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            fArray[0] = 1.0f;
        }
        this.vfPointsizeAttenuation[0] = fArray[0];
        this.vfPointsizeAttenuation[1] = fArray[1];
        this.vfPointsizeAttenuation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(int n) throws InvalidFieldValueException {
        if (n < 0 && n > 3) {
            throw new InvalidFieldValueException(UNKNOWN_TYPE_MSG);
        }
        this.colorMode = n;
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public void setColorMode(String string) throws InvalidFieldValueException {
        if (typeMap.get(string) == null) {
            throw new InvalidFieldValueException("The color mode provided is not recognised: " + string);
        }
        this.vfColorMode = string;
        Integer n = (Integer)typeMap.get(string);
        this.setColorMode(n);
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[6];
        fieldMap = new HashMap(18);
        BasePointProperties.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePointProperties.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "pointsizeScaleFactor");
        BasePointProperties.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFFloat", "pointsizeMinValue");
        BasePointProperties.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "pointsizeMaxValue");
        BasePointProperties.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec3f", "pointsizeAttenuation");
        BasePointProperties.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFString", "colorMode");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("pointsizeScaleFactor", n);
        fieldMap.put("set_pointsizeScaleFactor", n);
        fieldMap.put("pointsizeScaleFactor_changed", n);
        n = new Integer(2);
        fieldMap.put("pointsizeMinValue", n);
        fieldMap.put("set_pointsizeMinValue", n);
        fieldMap.put("pointsizeMinValue_changed", n);
        n = new Integer(3);
        fieldMap.put("pointsizeMaxValue", n);
        fieldMap.put("set_pointsizeMaxValue", n);
        fieldMap.put("pointsizeMaxValue_changed", n);
        n = new Integer(4);
        fieldMap.put("pointsizeAttenuation", n);
        fieldMap.put("set_pointsizeAttenuation", n);
        fieldMap.put("pointsizeAttenuation_changed", n);
        n = new Integer(5);
        fieldMap.put("colorMode", n);
        fieldMap.put("set_colorMode", n);
        fieldMap.put("colorMode_changed", n);
        typeMap = new HashMap();
        typeMap.put(TEXTURE_COLORMODE, new Integer(1));
        typeMap.put(POINT_COLORMODE, new Integer(2));
        typeMap.put(TEXTURE_AND_POINT_COLORMODE, new Integer(3));
    }
}

