/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.Body;
import org.odejava.JointGroup;
import org.odejava.JointSlider;
import org.odejava.World;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseJointNode;

public abstract class BaseSliderJoint
extends BaseJointNode {
    protected static final int FIELD_AXIS = 4;
    protected static final int FIELD_MIN_SEPARATION = 5;
    protected static final int FIELD_MAX_SEPARATION = 6;
    protected static final int FIELD_SEPARATION = 7;
    protected static final int FIELD_SEPARATION_RATE = 8;
    protected static final int FIELD_STOP_BOUNCE = 9;
    protected static final int FIELD_STOP_ERROR_CORRECTION = 10;
    protected static final int LAST_SLIDER_INDEX = 10;
    private static final int NUM_FIELDS = 11;
    protected static final String MIN_SEPARATION_MSG = "The minSeparation value is not allowed to be negative.";
    protected static final String MAX_SEPARATION_MSG = "The maxSeparation value is not allowed to be negative.";
    private static final String SEP_WRITE_MSG = "separationAngle is outputOnly and cannot be set";
    private static final String SEPR_WRITE_MSG = "separationRate is outputOnly and cannot be set";
    protected static final String BOUNCE_RANGE_MSG = "The stopBounce value is out of the required range [0,1]: ";
    protected static final String STOP_ERROR_RANGE_MSG = "The stopErrorCorrection value is out of the required range [0,1]: ";
    private static final int[] outputFields;
    private static final int[] nodeFields;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    protected float[] vfAxis = new float[3];
    protected float vfMinSeparation = (float)(-Math.PI);
    protected float vfMaxSeparation = (float)Math.PI;
    protected float vfSeparation;
    protected float vfSeparationRate;
    protected float vfStopBounce = 0.0f;
    protected float vfStopErrorCorrection = 0.8f;
    protected JointSlider odeJoint;

    public BaseSliderJoint() {
        super("SliderJoint");
        this.hasChanged = new boolean[11];
    }

    public BaseSliderJoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("axis");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAxis[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAxis[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("minSeparation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMinSeparation = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("maxSeparation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxSeparation = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stopBounce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStopBounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stopErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStopErrorCorrection = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void delete() {
        this.odeJoint.delete();
    }

    public void updateRequestedOutputs() {
        for (int i = 0; i < this.numOutputIndices; ++i) {
            int cfr_ignored_0 = this.outputIndices[i];
        }
    }

    public void setODEWorld(World world, JointGroup jointGroup) {
        if (world != null) {
            this.odeJoint = new JointSlider(world, jointGroup);
            Body body = null;
            Body body2 = null;
            if (this.vfBody1 != null) {
                body = this.vfBody1.getODEBody();
            }
            if (this.vfBody2 != null) {
                body2 = this.vfBody2.getODEBody();
            }
            this.odeJoint.attach(body, body2);
            this.odeJoint.setAxis(this.vfAxis[0], this.vfAxis[1], this.vfAxis[2]);
            this.odeJoint.setMinimumPosition(this.vfMinSeparation);
            this.odeJoint.setMaximumPosition(this.vfMaxSeparation);
            this.odeJoint.setStopBounce(this.vfStopBounce);
            this.odeJoint.setStopERP(this.vfStopErrorCorrection);
        } else {
            this.odeJoint.delete();
        }
    }

    public void setBody1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody1(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
    }

    public void setBody2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody2(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 81;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
        this.odeJoint.setAxis(this.vfAxis[0], this.vfAxis[1], this.vfAxis[2]);
        this.odeJoint.setMinimumPosition(this.vfMinSeparation);
        this.odeJoint.setMaximumPosition(this.vfMaxSeparation);
        this.odeJoint.setStopBounce(this.vfStopBounce);
        this.odeJoint.setStopERP(this.vfStopErrorCorrection);
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfAxis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMinSeparation;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMaxSeparation;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSeparation;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSeparationRate;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStopBounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStopErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAxis, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfMinSeparation);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfMaxSeparation);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfSeparation);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfSeparationRate);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfStopBounce);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfStopErrorCorrection);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("SingleAxisJoint.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("SingleAxisJoint.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 5: {
                this.setMinSeparation(f);
                break;
            }
            case 6: {
                this.setMaxSeparation(f);
                break;
            }
            case 9: {
                this.setStopBounce(f);
                break;
            }
            case 10: {
                this.setStopErrorCorrection(f);
                break;
            }
            case 7: {
                throw new InvalidFieldAccessException(SEP_WRITE_MSG);
            }
            case 8: {
                throw new InvalidFieldAccessException(SEPR_WRITE_MSG);
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                this.setAxis(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void setMinSeparation(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(MIN_SEPARATION_MSG);
        }
        this.vfMinSeparation = f;
        if (!this.inSetup) {
            this.odeJoint.setMinimumPosition(f);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setMaxSeparation(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(MAX_SEPARATION_MSG);
        }
        this.vfMaxSeparation = f;
        if (!this.inSetup) {
            this.odeJoint.setMaximumPosition(f);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setAxis(float[] fArray) {
        this.vfAxis[0] = fArray[0];
        this.vfAxis[1] = fArray[1];
        this.vfAxis[2] = fArray[2];
        if (!this.inSetup) {
            this.odeJoint.setAxis(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void setStopBounce(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(BOUNCE_RANGE_MSG + f);
        }
        this.vfStopBounce = f;
        if (!this.inSetup) {
            this.odeJoint.setStopBounce(f);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setStopErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(STOP_ERROR_RANGE_MSG + f);
        }
        this.vfStopErrorCorrection = f;
        if (!this.inSetup) {
            this.odeJoint.setStopERP(f);
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    int[] getAllOutputFieldIndices() {
        return outputFields;
    }

    static {
        nodeFields = new int[]{0, 1, 2};
        outputFields = new int[]{7, 8};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseSliderJoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseSliderJoint.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFString", "mustOutput");
        BaseSliderJoint.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec3f", "axis");
        BaseSliderJoint.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "body1");
        BaseSliderJoint.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "body2");
        BaseSliderJoint.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFFloat", "minSeparation");
        BaseSliderJoint.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "maxSeparation");
        BaseSliderJoint.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFFloat", "separation");
        BaseSliderJoint.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFFloat", "separationRate");
        BaseSliderJoint.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFFloat", "stopBounce");
        BaseSliderJoint.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFFloat", "stopErrorCorrection");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("mustOutput", n);
        fieldMap.put("set_mustOutput", n);
        fieldMap.put("mustOutput_changed", n);
        n = new Integer(4);
        fieldMap.put("axis", n);
        fieldMap.put("set_axis", n);
        fieldMap.put("axis_changed", n);
        n = new Integer(1);
        fieldMap.put("body1", n);
        fieldMap.put("set_body1", n);
        fieldMap.put("body1_changed", n);
        n = new Integer(2);
        fieldMap.put("body2", n);
        fieldMap.put("set_body2", n);
        fieldMap.put("body2_changed", n);
        n = new Integer(5);
        fieldMap.put("minSeparation", n);
        fieldMap.put("set_minSeparation", n);
        fieldMap.put("minSeparation_changed", n);
        n = new Integer(6);
        fieldMap.put("maxSeparation", n);
        fieldMap.put("set_maxSeparation", n);
        fieldMap.put("maxSeparation_changed", n);
        n = new Integer(9);
        fieldMap.put("stopBounce", n);
        fieldMap.put("set_stopBounce", n);
        fieldMap.put("stopBounce_changed", n);
        n = new Integer(10);
        fieldMap.put("stopErrorCorrection", n);
        fieldMap.put("set_stopErrorCorrection", n);
        fieldMap.put("stopErrorCorrection_changed", n);
        fieldMap.put("separation", new Integer(7));
        fieldMap.put("separationRate", new Integer(8));
    }
}

