/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.Body;
import org.odejava.JointGroup;
import org.odejava.JointHinge;
import org.odejava.World;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseJointNode;

public abstract class BaseSingleAxisHingeJoint
extends BaseJointNode {
    protected static final int FIELD_ANCHOR_POINT = 4;
    protected static final int FIELD_BODY1_ANCHOR_POINT = 5;
    protected static final int FIELD_BODY2_ANCHOR_POINT = 6;
    protected static final int FIELD_AXIS = 7;
    protected static final int FIELD_MIN_ANGLE = 8;
    protected static final int FIELD_MAX_ANGLE = 9;
    protected static final int FIELD_ANGLE = 10;
    protected static final int FIELD_ANGLE_RATE = 11;
    protected static final int FIELD_STOP_BOUNCE = 12;
    protected static final int FIELD_STOP_ERROR_CORRECTION = 13;
    protected static final int LAST_INDEX = 13;
    private static final int NUM_FIELDS = 14;
    protected static final String MIN_ANGLE_MSG = "The minAngle value is out of the required range [-pi,pi]: ";
    protected static final String MAX_ANGLE_MSG = "The maxAngle value is out of the required range [-pi,pi]: ";
    protected static final String BOUNCE_RANGE_MSG = "The stopBounce value is out of the required range [0,1]: ";
    protected static final String STOP_ERROR_RANGE_MSG = "The stopErrorCorrection value is out of the required range [0,1]: ";
    private static final String AP1_WRITE_MSG = "body1AnchorPoint is outputOnly and cannot be set";
    private static final String AP2_WRITE_MSG = "body2AnchorPoint is outputOnly and cannot be set";
    private static final String HA_WRITE_MSG = "angle is outputOnly and cannot be set";
    private static final String HAR_WRITE_MSG = "angleRate is outputOnly and cannot be set";
    private static final int[] outputFields;
    private static final int[] nodeFields;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    protected float[] vfAnchorPoint = new float[3];
    protected float[] vfBody1AnchorPoint;
    protected float[] vfBody2AnchorPoint;
    protected float[] vfAxis = new float[3];
    protected float vfMinAngle = (float)(-Math.PI);
    protected float vfMaxAngle = (float)Math.PI;
    protected float vfAngle;
    protected float vfAngleRate;
    protected float vfStopBounce = 0.0f;
    protected float vfStopErrorCorrection = 0.8f;
    protected JointHinge odeJoint;

    public BaseSingleAxisHingeJoint() {
        super("SingleAxisHingeJoint");
        this.vfBody1AnchorPoint = new float[3];
        this.vfBody2AnchorPoint = new float[3];
        this.hasChanged = new boolean[14];
    }

    public BaseSingleAxisHingeJoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("anchorPoint");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAnchorPoint[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAnchorPoint[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAnchorPoint[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("axis");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAxis[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAxis[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("minAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMinAngle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("maxAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxAngle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stopBounce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStopBounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stopErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStopErrorCorrection = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void delete() {
        this.odeJoint.delete();
    }

    public void updateRequestedOutputs() {
        if (this.odeJoint == null) {
            return;
        }
        for (int i = 0; i < this.numOutputIndices; ++i) {
            int cfr_ignored_0 = this.outputIndices[i];
        }
    }

    public void setODEWorld(World world, JointGroup jointGroup) {
        if (world != null) {
            this.odeJoint = new JointHinge(world, jointGroup);
            Body body = null;
            Body body2 = null;
            if (this.vfBody1 != null) {
                body = this.vfBody1.getODEBody();
            }
            if (this.vfBody2 != null) {
                body2 = this.vfBody2.getODEBody();
            }
            this.odeJoint.attach(body, body2);
            this.odeJoint.setAnchor(this.vfAnchorPoint[0], this.vfAnchorPoint[1], this.vfAnchorPoint[2]);
            this.odeJoint.setAxis(this.vfAxis[0], this.vfAxis[1], this.vfAxis[2]);
            this.odeJoint.setMinAngleStop(this.vfMinAngle);
            this.odeJoint.setMaxAngleStop(this.vfMaxAngle);
            this.odeJoint.setStopBounce(this.vfStopBounce);
            this.odeJoint.setStopERP(this.vfStopErrorCorrection);
        } else {
            this.odeJoint.delete();
        }
    }

    public void setBody1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody1(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            this.odeJoint.attach(body, body2);
        }
    }

    public void setBody2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody2(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            this.odeJoint.attach(body, body2);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            this.odeJoint.attach(body, body2);
            this.odeJoint.setAnchor(this.vfAnchorPoint[0], this.vfAnchorPoint[1], this.vfAnchorPoint[2]);
            this.odeJoint.setAxis(this.vfAxis[0], this.vfAxis[1], this.vfAxis[2]);
            this.odeJoint.setMinAngleStop(this.vfMinAngle);
            this.odeJoint.setMaxAngleStop(this.vfMaxAngle);
            this.odeJoint.setStopBounce(this.vfStopBounce);
            this.odeJoint.setStopERP(this.vfStopErrorCorrection);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 13) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 81;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfAnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBody1AnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBody2AnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfAxis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMinAngle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMaxAngle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAngle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAngleRate;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStopBounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStopErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAnchorPoint, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfBody1AnchorPoint, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfBody2AnchorPoint, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfAxis, 3);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfMinAngle);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfMaxAngle);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfAngle);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfAngleRate);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfStopBounce);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfStopErrorCorrection);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("SingleAxisJoint.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("SingleAxisJoint.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 8: {
                this.setMinAngle(f);
                break;
            }
            case 9: {
                this.setMaxAngle(f);
                break;
            }
            case 12: {
                this.setStopBounce(f);
                break;
            }
            case 13: {
                this.setStopErrorCorrection(f);
                break;
            }
            case 10: {
                throw new InvalidFieldAccessException(HA_WRITE_MSG);
            }
            case 11: {
                throw new InvalidFieldAccessException(HAR_WRITE_MSG);
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                this.setAnchorPoint(fArray);
                break;
            }
            case 7: {
                this.setAxis(fArray);
                break;
            }
            case 5: {
                throw new InvalidFieldAccessException(AP1_WRITE_MSG);
            }
            case 6: {
                throw new InvalidFieldAccessException(AP2_WRITE_MSG);
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void setMinAngle(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(MIN_ANGLE_MSG + f);
        }
        this.vfMinAngle = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setMinAngleStop(f);
            }
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void setMaxAngle(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(MIN_ANGLE_MSG + f);
        }
        this.vfMaxAngle = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setMaxAngleStop(f);
            }
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setAnchorPoint(float[] fArray) {
        this.vfAnchorPoint[0] = fArray[0];
        this.vfAnchorPoint[1] = fArray[1];
        this.vfAnchorPoint[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAnchor(fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void setAxis(float[] fArray) {
        this.vfAxis[0] = fArray[0];
        this.vfAxis[1] = fArray[1];
        this.vfAxis[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAxis(fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    private void setStopBounce(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(BOUNCE_RANGE_MSG + f);
        }
        this.vfStopBounce = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setStopBounce(f);
            }
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
    }

    private void setStopErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(STOP_ERROR_RANGE_MSG + f);
        }
        this.vfStopErrorCorrection = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setStopERP(f);
            }
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    int[] getAllOutputFieldIndices() {
        return outputFields;
    }

    static {
        nodeFields = new int[]{0, 1, 2};
        outputFields = new int[]{5, 6, 10, 11};
        fieldDecl = new VRMLFieldDeclaration[14];
        fieldMap = new HashMap(42);
        BaseSingleAxisHingeJoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseSingleAxisHingeJoint.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFString", "mustOutput");
        BaseSingleAxisHingeJoint.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec3f", "anchorPoint");
        BaseSingleAxisHingeJoint.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "body1");
        BaseSingleAxisHingeJoint.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "body2");
        BaseSingleAxisHingeJoint.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFVec3f", "body1AnchorPoint");
        BaseSingleAxisHingeJoint.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFVec3f", "body2AnchorPoint");
        BaseSingleAxisHingeJoint.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFVec3f", "Axis");
        BaseSingleAxisHingeJoint.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "minAngle");
        BaseSingleAxisHingeJoint.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFFloat", "maxAngle");
        BaseSingleAxisHingeJoint.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFFloat", "angle");
        BaseSingleAxisHingeJoint.fieldDecl[11] = new VRMLFieldDeclaration(4, "SFFloat", "angleRate");
        BaseSingleAxisHingeJoint.fieldDecl[12] = new VRMLFieldDeclaration(3, "SFFloat", "stopBounce");
        BaseSingleAxisHingeJoint.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFFloat", "stopErrorCorrection");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("mustOutput", n);
        fieldMap.put("set_mustOutput", n);
        fieldMap.put("mustOutput_changed", n);
        n = new Integer(4);
        fieldMap.put("anchorPoint", n);
        fieldMap.put("set_anchorPoint", n);
        fieldMap.put("anchorPoint_changed", n);
        n = new Integer(1);
        fieldMap.put("body1", n);
        fieldMap.put("set_body1", n);
        fieldMap.put("body1_changed", n);
        n = new Integer(2);
        fieldMap.put("body2", n);
        fieldMap.put("set_body2", n);
        fieldMap.put("body2_changed", n);
        n = new Integer(7);
        fieldMap.put("axis", n);
        fieldMap.put("set_axis", n);
        fieldMap.put("axis_changed", n);
        n = new Integer(8);
        fieldMap.put("minAngle", n);
        fieldMap.put("set_minAngle", n);
        fieldMap.put("minAngle_changed", n);
        n = new Integer(9);
        fieldMap.put("maxAngle", n);
        fieldMap.put("set_maxAngle", n);
        fieldMap.put("maxAngle_changed", n);
        n = new Integer(12);
        fieldMap.put("stopBounce", n);
        fieldMap.put("set_stopBounce", n);
        fieldMap.put("stopBounce_changed", n);
        n = new Integer(13);
        fieldMap.put("stopErrorCorrection", n);
        fieldMap.put("set_stopErrorCorrection", n);
        fieldMap.put("stopErrorCorrection_changed", n);
        fieldMap.put("body1AnchorPoint", new Integer(5));
        fieldMap.put("body2AnchorPoint", new Integer(6));
        fieldMap.put("angle", new Integer(10));
        fieldMap.put("angleRate", new Integer(11));
    }
}

