/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLRigidBodyNodeType;
import org.web3d.vrml.nodes.VRMLRigidJointNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseJointNode
extends AbstractNode
implements VRMLRigidJointNodeType {
    protected static final int FIELD_BODY1 = 1;
    protected static final int FIELD_BODY2 = 2;
    protected static final int FIELD_MUST_OUTPUT = 3;
    protected static final int LAST_JOINT_INDEX = 3;
    protected static final String BODY_PROTO_MSG = "Proto does not describe a Body object";
    protected static final String BODY_NODE_MSG = "Node does not describe a Body object";
    protected VRMLRigidBodyNodeType vfBody1;
    protected VRMLProtoInstance pBody1;
    protected VRMLRigidBodyNodeType vfBody2;
    protected VRMLProtoInstance pBody2;
    protected String[] vfMustOutput = new String[]{"NONE"};
    protected int numMustOutput = 1;
    protected int[] outputIndices;
    protected int numOutputIndices = 0;

    public BaseJointNode(String string) {
        super(string);
    }

    public int numOutputs() {
        return this.numOutputIndices;
    }

    public int[] getOutputFields() {
        return this.outputIndices;
    }

    public void setBody1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLRigidBodyNodeType vRMLRigidBodyNodeType;
        Object object = this.pBody1 != null ? this.pBody1 : this.vfBody1;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pBody1 = (VRMLProtoInstance)vRMLNodeType;
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLRigidBodyNodeType)) {
                throw new InvalidFieldValueException(BODY_PROTO_MSG);
            }
            vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType2;
        } else if (vRMLNodeType instanceof VRMLRigidBodyNodeType) {
            this.pBody1 = null;
            vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType;
        } else {
            throw new InvalidFieldValueException(BODY_NODE_MSG);
        }
        this.vfBody1 = vRMLRigidBodyNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
        if (!this.inSetup) {
            if (object != null) {
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public VRMLNodeType getBody1() {
        return this.vfBody1;
    }

    public void setBody2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLRigidBodyNodeType vRMLRigidBodyNodeType;
        Object object = this.pBody2 != null ? this.pBody2 : this.vfBody2;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pBody2 = (VRMLProtoInstance)vRMLNodeType;
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLRigidBodyNodeType)) {
                throw new InvalidFieldValueException(BODY_PROTO_MSG);
            }
            vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType2;
        } else if (vRMLNodeType instanceof VRMLRigidBodyNodeType) {
            this.pBody2 = null;
            vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType;
        } else {
            throw new InvalidFieldValueException(BODY_NODE_MSG);
        }
        this.vfBody2 = vRMLRigidBodyNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
        if (!this.inSetup) {
            if (object != null) {
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public VRMLNodeType getBody2() {
        return this.vfBody2;
    }

    public int getPrimaryType() {
        return 81;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pBody1 != null) {
            this.pBody1.setupFinished();
        } else if (this.vfBody1 != null) {
            this.vfBody1.setupFinished();
        }
        if (this.pBody2 != null) {
            this.pBody2.setupFinished();
        } else if (this.vfBody2 != null) {
            this.vfBody2.setupFinished();
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pBody1 != null ? this.pBody1 : this.vfBody1;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pBody2 != null ? this.pBody2 : this.vfBody2;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfMustOutput;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.numMustOutput;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    if (this.pBody1 != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pBody1);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfBody1);
                    break;
                }
                case 2: {
                    if (this.pBody2 != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pBody2);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfBody2);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfMustOutput, this.numMustOutput);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseJointNode.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseJointNode.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 3: {
                this.setMustOutput(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 1: {
                this.setBody1(vRMLNodeType);
                break;
            }
            case 2: {
                this.setBody2(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    private void setMustOutput(String[] stringArray, int n) {
        int n2;
        boolean bl;
        block12: {
            block10: {
                block11: {
                    if (this.vfMustOutput.length < n) {
                        this.vfMustOutput = new String[n];
                    }
                    System.arraycopy(stringArray, 0, this.vfMustOutput, 0, n);
                    this.numMustOutput = n;
                    bl = false;
                    if (n != 1) break block10;
                    if (!stringArray[0].equals("NONE")) break block11;
                    this.numOutputIndices = 0;
                    break block12;
                }
                if (!stringArray[0].equals("ALL")) break block12;
                bl = true;
                break block12;
            }
            for (n2 = 0; !bl && n2 < n; ++n2) {
                if (!stringArray[n2].equals("ALL")) continue;
                bl = true;
            }
        }
        if (bl) {
            int[] nArray = this.getAllOutputFieldIndices();
            if (this.outputIndices == null || this.outputIndices.length < nArray.length) {
                this.outputIndices = new int[nArray.length];
            }
            System.arraycopy(nArray, 0, this.outputIndices, 0, nArray.length);
            this.numOutputIndices = nArray.length;
        } else if (n != 0) {
            if (this.outputIndices == null || this.outputIndices.length < n) {
                this.outputIndices = new int[n];
            }
            this.numOutputIndices = 0;
            for (n2 = 0; n2 < n; ++n2) {
                int n3 = this.getFieldIndex(stringArray[n2]);
                if (n3 == -1) continue;
                this.outputIndices[this.numOutputIndices++] = n3;
            }
        } else {
            this.numOutputIndices = 0;
        }
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    abstract int[] getAllOutputFieldIndices();
}

