/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.ArrayList;
import java.util.HashMap;
import org.odejava.Geom;
import org.odejava.HashSpace;
import org.odejava.PlaceableGeom;
import org.odejava.QuadTreeSpace;
import org.odejava.Space;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNBodyCollidableNodeType;
import org.web3d.vrml.nodes.VRMLNBodySpaceNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseCollisionSpace
extends AbstractNode
implements VRMLNBodySpaceNodeType {
    protected static final int FIELD_BBOX_SIZE = 1;
    protected static final int FIELD_BBOX_CENTER = 2;
    protected static final int FIELD_COLLIDABLES = 3;
    protected static final int FIELD_USE_GEOMETRY = 4;
    protected static final int FIELD_ENABLED = 5;
    protected static final int LAST_SPACE_INDEX = 5;
    private static final int NUM_FIELDS = 6;
    private static final int QUADTREE_DEPTH = 5;
    protected static final String COLLIDABLE_PROTO_MSG = "Collidables field proto value does not describe a CollisionSpace  node or NBodyCollidableNode type.";
    protected static final String COLLIDABLE_NODE_MSG = "Collidables field node value does not describe a CollisionSpace  node or NBodyCollidableNode type.";
    private static final int[] nodeFields = new int[]{0, 3};
    private static final VRMLFieldDeclaration[] fieldDecl = new VRMLFieldDeclaration[6];
    private static final HashMap fieldMap = new HashMap(18);
    private ArrayList vfCollidables = new ArrayList();
    protected boolean vfEnabled = true;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};
    protected boolean vfUseGeometry = false;
    private VRMLNodeType[] nodeTmp;
    private Space odeSpace;
    private ArrayList spaceChildren;
    private ArrayList geomChildren;

    public BaseCollisionSpace() {
        super("CollisionSpace");
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.hasChanged = new boolean[6];
        this.spaceChildren = new ArrayList();
        this.geomChildren = new ArrayList();
    }

    public BaseCollisionSpace(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("enabled");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("useGeometry");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfUseGeometry = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("bboxSize");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBboxSize[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBboxSize[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBboxSize[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("bboxCenter");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBboxCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBboxCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBboxCenter[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public Space getODESpace() {
        return this.odeSpace;
    }

    public void setParentODESpace(Space space) {
        if (space == null) {
            this.odeSpace.delete();
            this.odeSpace = null;
        } else {
            if (this.odeSpace != null) {
                this.odeSpace.delete();
            }
            this.odeSpace = this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f ? new QuadTreeSpace(space, this.vfBboxCenter, this.vfBboxSize, 5) : new HashSpace(space);
            this.odeSpace.setChildCleanupMode(false);
        }
    }

    public boolean isEnabled() {
        return this.vfEnabled;
    }

    public float[] getBboxCenter() {
        return this.vfBboxCenter;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public void setupFinished() {
        VRMLNBodyCollidableNodeType vRMLNBodyCollidableNodeType;
        int n;
        int n2;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.odeSpace == null) {
            this.odeSpace = this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f ? new QuadTreeSpace(this.vfBboxCenter, this.vfBboxSize, 5) : new HashSpace();
            this.odeSpace.setChildCleanupMode(false);
            n2 = this.spaceChildren.size();
            for (n = 0; n < n2; ++n) {
                vRMLNBodyCollidableNodeType = (VRMLNBodySpaceNodeType)this.spaceChildren.get(n);
                vRMLNBodyCollidableNodeType.setParentODESpace(this.odeSpace);
            }
        }
        n2 = this.vfCollidables.size();
        for (n = 0; n < n2; ++n) {
            ((VRMLNodeType)this.vfCollidables.get(n)).setupFinished();
        }
        n2 = this.geomChildren.size();
        for (n = 0; n < n2; ++n) {
            vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)this.geomChildren.get(n);
            PlaceableGeom placeableGeom = vRMLNBodyCollidableNodeType.getODEGeometry();
            this.odeSpace.addGeom((Geom)placeableGeom);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 85;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                int n2 = this.vfCollidables.size();
                if (this.nodeTmp == null || this.nodeTmp.length < n2) {
                    this.nodeTmp = new VRMLNodeType[n2];
                }
                this.vfCollidables.toArray(this.nodeTmp);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = n2;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfUseGeometry;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxSize;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxCenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    int n3 = this.vfCollidables.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n3) {
                        this.nodeTmp = new VRMLNodeType[n3];
                    }
                    this.vfCollidables.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfUseGeometry);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 5: {
                this.setEnabled(bl);
                break;
            }
            case 4: {
                this.setUseGeometry(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 2: {
                this.setBboxCenter(fArray);
                break;
            }
            case 1: {
                this.setBboxSize(fArray);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 3: {
                if (!this.inSetup) {
                    this.clearCollidables();
                }
                this.addCollidable(vRMLNodeType2);
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 3: {
                if (!this.inSetup) {
                    this.clearCollidables();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addCollidable(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    private void setBboxCenter(float[] fArray) {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  bboxCenter");
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    private void setBboxSize(float[] fArray) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  bboxSize");
        }
        FieldValidator.checkBBoxSize((String)this.getVRMLNodeName(), (float[])fArray);
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    private void setEnabled(boolean bl) {
        this.vfEnabled = bl;
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setUseGeometry(boolean bl) {
        this.vfUseGeometry = bl;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    protected void clearCollidables() {
        int n = this.vfCollidables.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfCollidables.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes((VRMLNode[])this.nodeTmp);
        }
        this.vfCollidables.clear();
        this.spaceChildren.clear();
        this.geomChildren.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addCollidable(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLNBodyCollidableNodeType) {
            this.vfCollidables.add(vRMLNodeType);
            this.geomChildren.add(vRMLNodeType);
        } else if (vRMLNodeType instanceof VRMLNBodySpaceNodeType) {
            this.vfCollidables.add(vRMLNodeType);
            this.spaceChildren.add(vRMLNodeType);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 instanceof VRMLNBodyCollidableNodeType) {
                this.vfCollidables.add(vRMLNodeType2);
                this.geomChildren.add(vRMLNodeType2);
            } else {
                if (!(vRMLNodeType2 instanceof VRMLNBodySpaceNodeType)) throw new InvalidFieldValueException(COLLIDABLE_PROTO_MSG);
                this.vfCollidables.add(vRMLNodeType2);
                this.spaceChildren.add(vRMLNodeType2);
            }
        } else if (vRMLNodeType != null) {
            throw new InvalidFieldValueException(COLLIDABLE_NODE_MSG);
        }
        if (this.inSetup) return;
        this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
    }

    static {
        BaseCollisionSpace.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCollisionSpace.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseCollisionSpace.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "collidables");
        BaseCollisionSpace.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "useGeometry");
        BaseCollisionSpace.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseCollisionSpace.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(5);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("collidables", n);
        fieldMap.put("set_collidables", n);
        fieldMap.put("collidables_changed", n);
        n = new Integer(4);
        fieldMap.put("useGeometry", n);
        fieldMap.put("set_useGeometry", n);
        fieldMap.put("useGeometry_changed", n);
        fieldMap.put("bboxCenter", new Integer(2));
        fieldMap.put("bboxSize", new Integer(1));
    }
}

