/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.Body;
import org.odejava.JointBall;
import org.odejava.JointGroup;
import org.odejava.World;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseJointNode;

public abstract class BaseBallJoint
extends BaseJointNode {
    protected static final int FIELD_ANCHOR_POINT = 4;
    protected static final int FIELD_BODY1_ANCHOR_POINT = 5;
    protected static final int FIELD_BODY2_ANCHOR_POINT = 6;
    protected static final int LAST_BALL_INDEX = 6;
    private static final int NUM_FIELDS = 7;
    private static final String AP1_WRITE_MSG = "body1AnchorPoint is outputOnly and cannot be set";
    private static final String AP2_WRITE_MSG = "body2AnchorPoint is outputOnly and cannot be set";
    private static final int[] outputFields;
    private static final int[] nodeFields;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    protected float[] vfAnchorPoint = new float[3];
    protected float[] vfBody1AnchorPoint = new float[3];
    protected float[] vfBody2AnchorPoint = new float[3];
    protected JointBall odeJoint;

    public BaseBallJoint() {
        super("BallJoint");
        this.hasChanged = new boolean[7];
    }

    public BaseBallJoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("anchorPoint");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAnchorPoint[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAnchorPoint[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAnchorPoint[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void delete() {
        this.odeJoint.delete();
    }

    public void updateRequestedOutputs() {
        if (this.odeJoint == null) {
            return;
        }
        block4: for (int i = 0; i < this.numOutputIndices; ++i) {
            switch (this.outputIndices[i]) {
                case 5: {
                    this.odeJoint.getAnchor(this.vfBody1AnchorPoint);
                    this.hasChanged[5] = true;
                    this.fireFieldChanged(5);
                    continue block4;
                }
                case 6: {
                    this.odeJoint.getAnchor2(this.vfBody2AnchorPoint);
                    this.hasChanged[6] = true;
                    this.fireFieldChanged(6);
                }
            }
        }
    }

    public void setODEWorld(World world, JointGroup jointGroup) {
        if (world != null) {
            this.odeJoint = new JointBall(world, jointGroup);
        } else {
            this.odeJoint.delete();
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
        this.odeJoint.setAnchor(this.vfAnchorPoint[0], this.vfAnchorPoint[1], this.vfAnchorPoint[2]);
    }

    public void setBody1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody1(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            this.odeJoint.attach(body, body2);
        }
    }

    public void setBody2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody2(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            this.odeJoint.attach(body, body2);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 81;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.odeJoint == null) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
        this.odeJoint.setAnchor(this.vfAnchorPoint[0], this.vfAnchorPoint[1], this.vfAnchorPoint[2]);
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfAnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBody1AnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBody2AnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAnchorPoint, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfBody1AnchorPoint, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfBody2AnchorPoint, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("SingleAxisJoint.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("SingleAxisJoint.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                this.setAnchorPoint(fArray);
                break;
            }
            case 5: {
                throw new InvalidFieldAccessException(AP1_WRITE_MSG);
            }
            case 6: {
                throw new InvalidFieldAccessException(AP2_WRITE_MSG);
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void setAnchorPoint(float[] fArray) {
        this.vfAnchorPoint[0] = fArray[0];
        this.vfAnchorPoint[1] = fArray[1];
        this.vfAnchorPoint[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAnchor(fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    int[] getAllOutputFieldIndices() {
        return outputFields;
    }

    static {
        nodeFields = new int[]{0, 1, 2};
        outputFields = new int[]{5, 6};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseBallJoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseBallJoint.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFString", "mustOutput");
        BaseBallJoint.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec3f", "anchorPoint");
        BaseBallJoint.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "body1");
        BaseBallJoint.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "body2");
        BaseBallJoint.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFVec3f", "body1AnchorPoint");
        BaseBallJoint.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFVec3f", "body2AnchorPoint");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("mustOutput", n);
        fieldMap.put("set_mustOutput", n);
        fieldMap.put("mustOutput_changed", n);
        n = new Integer(4);
        fieldMap.put("anchorPoint", n);
        fieldMap.put("set_anchorPoint", n);
        fieldMap.put("anchorPoint_changed", n);
        n = new Integer(1);
        fieldMap.put("body1", n);
        fieldMap.put("set_body1", n);
        fieldMap.put("body1_changed", n);
        n = new Integer(2);
        fieldMap.put("body2", n);
        fieldMap.put("set_body2", n);
        fieldMap.put("body2_changed", n);
        fieldMap.put("body1AnchorPoint", new Integer(5));
        fieldMap.put("body2AnchorPoint", new Integer(6));
    }
}

