/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTriangleGeometryNode;

public abstract class BaseTriangleStripSet
extends BaseTriangleGeometryNode {
    protected static final int FIELD_STRIP_COUNT = 11;
    protected static final int LAST_TRIANGLE_INDEX = 11;
    private static final int NUM_FIELDS = 12;
    private static final String BAD_COUNT_MSG = "Strip count values less that 3 are not permitted. Offending value found at index: ";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int[] vfStripCount = FieldConstants.EMPTY_MFINT32;
    protected int numStripCount;

    protected BaseTriangleStripSet() {
        super("TriangleStripSet");
        this.hasChanged = new boolean[12];
    }

    protected BaseTriangleStripSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("stripCount");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfStripCount = new int[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfStripCount, 0, vRMLFieldData.numElements);
                this.numStripCount = vRMLFieldData.numElements;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        switch (n) {
            case 11: {
                vRMLNodeType.setValue(n2, this.vfStripCount, this.numStripCount);
                break;
            }
            default: {
                super.sendRoute(d, n, vRMLNodeType, n2);
            }
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.intArrayValue = this.vfStripCount;
                vRMLFieldData.numElements = this.numStripCount;
                vRMLFieldData.dataType = (short)9;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 11: {
                this.setStripCount(nArray, n2);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    protected void setStripCount(int[] nArray, int n) throws InvalidFieldValueException {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 3) continue;
            throw new InvalidFieldValueException(BAD_COUNT_MSG + i);
        }
        if (this.vfStripCount.length < n) {
            this.vfStripCount = new int[n];
        }
        System.arraycopy(nArray, 0, this.vfStripCount, 0, n);
        this.numStripCount = n;
        if (!this.inSetup) {
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
            this.buildImpl();
        }
    }

    static {
        nodeFields = new int[]{1, 3, 4, 2, 9, 10, 0};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(36);
        BaseTriangleStripSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTriangleStripSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseTriangleStripSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseTriangleStripSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "normal");
        BaseTriangleStripSet.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseTriangleStripSet.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFNode", "fogCoord");
        BaseTriangleStripSet.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFNode", "attrib");
        BaseTriangleStripSet.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseTriangleStripSet.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseTriangleStripSet.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        BaseTriangleStripSet.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFBool", "normalPerVertex");
        BaseTriangleStripSet.fieldDecl[11] = new VRMLFieldDeclaration(3, "MFInt32", "stripCount");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(1);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(3);
        fieldMap.put("normal", n);
        fieldMap.put("set_normal", n);
        fieldMap.put("normal_changed", n);
        n = new Integer(4);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        n = new Integer(9);
        fieldMap.put("fogCoord", n);
        fieldMap.put("set_fogCoord", n);
        fieldMap.put("fogCoord_changed", n);
        n = new Integer(10);
        fieldMap.put("attrib", n);
        fieldMap.put("set_attrib", n);
        fieldMap.put("attrib_changed", n);
        n = new Integer(11);
        fieldMap.put("stripCount", n);
        fieldMap.put("set_stripCount", n);
        fieldMap.put("stripCount_changed", n);
        fieldMap.put("solid", new Integer(5));
        fieldMap.put("ccw", new Integer(6));
        fieldMap.put("colorPerVertex", new Integer(7));
        fieldMap.put("normalPerVertex", new Integer(8));
    }
}

