/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseIndexedTriangleGeometryNode;

public abstract class BaseIndexedTriangleFanSet
extends BaseIndexedTriangleGeometryNode {
    private static final int NUM_FIELDS = 13;
    private static final String MAX_INDEX_COUNT_MSG = "Max coordIndex value > number of coords in IndexedTriangleFanSet";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected int[] fanCounts;
    protected int numFanCounts;
    protected int[] processedIndex;
    protected int numProcessedIndex;

    protected BaseIndexedTriangleFanSet() {
        super("IndexedTriangleFanSet");
        this.hasChanged = new boolean[13];
    }

    protected BaseIndexedTriangleFanSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 12) {
            return null;
        }
        return fieldDecl[n];
    }

    protected void updateIndexMaps() {
        int n;
        int n2;
        if (this.processedIndex == null || this.processedIndex.length < this.numIndex) {
            this.processedIndex = new int[this.numIndex];
        }
        this.numFanCounts = 1;
        for (n2 = 0; n2 < this.numIndex - 1; ++n2) {
            if (this.vfIndex[n2] != -1) continue;
            ++this.numFanCounts;
        }
        if (this.fanCounts == null || this.fanCounts.length < this.numFanCounts) {
            this.fanCounts = new int[this.numFanCounts];
        }
        n2 = 0;
        this.numProcessedIndex = 0;
        for (n = 0; n < this.numIndex; ++n) {
            if (this.vfIndex[n] == -1) {
                ++n2;
                continue;
            }
            this.processedIndex[this.numProcessedIndex++] = this.vfIndex[n];
            int n3 = n2;
            this.fanCounts[n3] = this.fanCounts[n3] + 1;
        }
        n = 0;
        for (int i = 0; i < this.numProcessedIndex; ++i) {
            if (this.processedIndex[i] <= n) continue;
            n = this.processedIndex[i];
        }
        if (this.vfCoord != null && (n + 1) * 3 > this.vfCoord.getNumPoints()) {
            this.errorReporter.warningReport(MAX_INDEX_COUNT_MSG, null);
        }
    }

    static {
        nodeFields = new int[]{1, 3, 4, 2, 9, 10, 0};
        fieldDecl = new VRMLFieldDeclaration[13];
        fieldMap = new HashMap(39);
        BaseIndexedTriangleFanSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseIndexedTriangleFanSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseIndexedTriangleFanSet.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseIndexedTriangleFanSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseIndexedTriangleFanSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "normal");
        BaseIndexedTriangleFanSet.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFNode", "fogCoord");
        BaseIndexedTriangleFanSet.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFNode", "attrib");
        BaseIndexedTriangleFanSet.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseIndexedTriangleFanSet.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseIndexedTriangleFanSet.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        BaseIndexedTriangleFanSet.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFBool", "normalPerVertex");
        BaseIndexedTriangleFanSet.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFInt32", "index");
        BaseIndexedTriangleFanSet.fieldDecl[12] = new VRMLFieldDeclaration(1, "MFInt32", "set_index");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(4);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(3);
        fieldMap.put("normal", n);
        fieldMap.put("set_normal", n);
        fieldMap.put("normal_changed", n);
        n = new Integer(9);
        fieldMap.put("fogCoord", n);
        fieldMap.put("set_fogCoord", n);
        fieldMap.put("fogCoord_changed", n);
        n = new Integer(10);
        fieldMap.put("attrib", n);
        fieldMap.put("set_attrib", n);
        fieldMap.put("attrib_changed", n);
        fieldMap.put("solid", new Integer(5));
        fieldMap.put("ccw", new Integer(6));
        fieldMap.put("colorPerVertex", new Integer(7));
        fieldMap.put("normalPerVertex", new Integer(8));
        fieldMap.put("index", new Integer(11));
        fieldMap.put("set_index", new Integer(12));
    }
}

