/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.particle;

import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.geom.particle.ColorRampFunction;
import org.j3d.geom.particle.MaxTimeParticleFunction;
import org.j3d.geom.particle.ParticleFunction;
import org.j3d.geom.particle.ParticleInitializer;
import org.j3d.geom.particle.ParticleSystem;
import org.j3d.geom.particle.PhysicsFunction;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLBoundedNodeType;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParticleEmitterNodeType;
import org.web3d.vrml.nodes.VRMLParticlePhysicsModelNodeType;
import org.web3d.vrml.nodes.VRMLParticleSystemNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseParticleSystem
extends AbstractNode
implements VRMLParticleSystemNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{6};
    protected static final int FIELD_APPEARANCE = 1;
    protected static final int FIELD_GEOMETRY = 2;
    protected static final int FIELD_BBOX_SIZE = 3;
    protected static final int FIELD_BBOX_CENTER = 4;
    protected static final int FIELD_GEOMETRY_TYPE = 5;
    protected static final int FIELD_ENABLED = 6;
    protected static final int FIELD_MAX_PARTICLES = 7;
    protected static final int FIELD_PARTICLE_LIFETIME = 8;
    protected static final int FIELD_LIFETIME_VARIATION = 9;
    protected static final int FIELD_EMITTER = 10;
    protected static final int FIELD_PHYSICS = 11;
    protected static final int FIELD_COLOR_RAMP = 12;
    protected static final int FIELD_COLOR_KEY = 13;
    protected static final int FIELD_IS_ACTIVE = 14;
    protected static final int FIELD_PARTICLE_SIZE = 15;
    protected static final int FIELD_CREATE_PARTICLES = 16;
    protected static final int FIELD_TEXCOORD_RAMP = 17;
    protected static final int FIELD_TEXCOORD_KEY = 18;
    protected static final int LAST_PARTICLE_INDEX = 18;
    protected static final int NUM_FIELDS = 19;
    protected static final String EMITTER_PROTO_MSG = "Proto does not describe a Emitter object";
    protected static final String EMITTER_NODE_MSG = "Node does not describe a Emitter object";
    protected static final String PHYSICS_PROTO_MSG = "Proto does not describe a Physics object";
    protected static final String PHYSICS_NODE_MSG = "Node does not describe a Physics object";
    protected static final String APPEARANCE_PROTO_MSG = "Proto does not describe a Appearance object";
    protected static final String APPEARANCE_NODE_MSG = "Node does not describe a Appearance object";
    protected static final String COLOR_PROTO_MSG = "Proto does not describe a Color object";
    protected static final String COLOR_NODE_MSG = "Node does not describe a Color object";
    protected static final String TEXCOORD_PROTO_MSG = "Proto does not describe a X3DTextureCoordinateNode object";
    protected static final String TEXCOORD_NODE_MSG = "Node does not describe a X3DTextureCoordinateNode object";
    private static final String NEG_PARTICLES_ERR = "Value provided for maxParticles is negative.";
    private static final String VARIATION_RANGE_ERR = "Value of lifetimeVariation is outside the acceptable range [0,1]";
    private static final String NEG_LIFETIME_ERR = "Provided particleLifetime value was negative.";
    private static final String ACTIVE_WRITE_MSG = "Attempt to set the isActive outputOnly field";
    private static final String NEG_SIZE_ERR = "Provided particleSize value contains a negative value:";
    protected static final int TYPE_QUADS = 1;
    protected static final int TYPE_TRIS = 2;
    protected static final int TYPE_LINES = 3;
    protected static final int TYPE_POINTS = 4;
    protected static final int TYPE_SPRITES = 5;
    protected static final int TYPE_CUSTOM = 6;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final int[] nodeFields;
    private static final HashMap fieldMap;
    private static final HashMap geomTypeMap;
    protected VRMLProtoInstance pAppearance;
    protected VRMLAppearanceNodeType vfAppearance;
    protected VRMLProtoInstance pEmitter;
    protected VRMLParticleEmitterNodeType vfEmitter;
    protected VRMLProtoInstance pColorRamp;
    protected VRMLColorNodeType vfColorRamp;
    protected VRMLProtoInstance pTexCoordRamp;
    protected VRMLTextureCoordinateNodeType vfTexCoordRamp;
    protected VRMLNodeType[] vfPhysics;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};
    protected String vfGeometryType;
    protected boolean vfEnabled;
    protected boolean vfCreateParticles;
    protected int vfMaxParticles;
    protected float vfParticleLifetime;
    protected float[] vfParticleSize;
    protected float vfLifetimeVariation;
    protected float[] vfColorKey;
    protected int numColorKey;
    protected float[] vfTexCoordKey;
    protected int numTexCoordKey;
    protected boolean vfIsActive;
    private ArrayList physicsNodes;
    protected int geometryType;
    protected ParticleSystem particleSystem;
    protected ParticleInitializer emitter;
    protected ColorRampFunction colorFunction;
    protected MaxTimeParticleFunction timeFunction;

    protected BaseParticleSystem() {
        super("ParticleSystem");
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.hasChanged = new boolean[19];
        this.vfEnabled = true;
        this.vfGeometryType = "QUAD";
        this.geometryType = 1;
        this.vfMaxParticles = 200;
        this.vfParticleLifetime = 5.0f;
        this.vfLifetimeVariation = 0.25f;
        this.vfIsActive = false;
        this.vfCreateParticles = true;
        this.vfParticleSize = new float[]{0.02f, 0.02f};
        this.numColorKey = 0;
        this.vfColorKey = FieldConstants.EMPTY_MFFLOAT;
        this.numTexCoordKey = 0;
        this.vfTexCoordKey = FieldConstants.EMPTY_MFFLOAT;
        this.timeFunction = new MaxTimeParticleFunction();
        this.physicsNodes = new ArrayList();
    }

    protected BaseParticleSystem(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        VRMLBoundedNodeType vRMLBoundedNodeType = (VRMLBoundedNodeType)vRMLNodeType;
        this.setBboxSize(vRMLBoundedNodeType.getBboxSize());
        this.setBboxCenter(vRMLBoundedNodeType.getBboxCenter());
        try {
            int n = vRMLNodeType.getFieldIndex("enabled");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("geometryType");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGeometryType = vRMLFieldData.stringValue;
            Integer n2 = (Integer)geomTypeMap.get(this.vfGeometryType);
            this.geometryType = n2;
            n = vRMLNodeType.getFieldIndex("maxParticles");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxParticles = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("particleLifetime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfParticleLifetime = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("particleSize");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfParticleSize[0] = vRMLFieldData.floatArrayValue[0];
            this.vfParticleSize[1] = vRMLFieldData.floatArrayValue[1];
            n = vRMLNodeType.getFieldIndex("lifetimeVariation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLifetimeVariation = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("createParticles");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCreateParticles = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("colorKey");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfColorKey = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfColorKey, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("texCoordKey");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfTexCoordKey = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfTexCoordKey, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public ParticleSystem getSystem() {
        return this.particleSystem;
    }

    public void setEnabled(boolean bl) {
        this.vfEnabled = bl;
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
            this.setActive(bl);
        }
    }

    public boolean getEnabled() {
        return this.vfEnabled;
    }

    public boolean isActive() {
        return this.vfIsActive;
    }

    public void setActive(boolean bl) {
        if (bl == this.vfIsActive || this.vfEmitter == null) {
            return;
        }
        this.vfIsActive = bl;
        this.hasChanged[14] = true;
        this.fireFieldChanged(14);
    }

    public VRMLNodeType getAppearance() {
        if (this.pAppearance != null) {
            return this.pAppearance;
        }
        return this.vfAppearance;
    }

    public void setAppearance(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLAppearanceNodeType vRMLAppearanceNodeType;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLAppearanceNodeType = (VRMLAppearanceNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pAppearance = (VRMLProtoInstance)vRMLNodeType;
            if (!(vRMLAppearanceNodeType instanceof VRMLAppearanceNodeType)) {
                throw new InvalidFieldValueException(APPEARANCE_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLAppearanceNodeType)) {
                throw new InvalidFieldValueException(APPEARANCE_NODE_MSG);
            }
            this.pAppearance = null;
            vRMLAppearanceNodeType = (VRMLAppearanceNodeType)vRMLNodeType;
        }
        this.vfAppearance = vRMLAppearanceNodeType;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public VRMLNodeType getGeometry() {
        return null;
    }

    public void setGeometry(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
    }

    public float[] getBboxCenter() {
        return this.vfBboxCenter;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public void setupFinished() {
        int n;
        int n2;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pAppearance != null) {
            this.pAppearance.setupFinished();
        } else if (this.vfAppearance != null) {
            this.vfAppearance.setupFinished();
        }
        if (this.pEmitter != null) {
            this.pEmitter.setupFinished();
        } else if (this.vfEmitter != null) {
            this.vfEmitter.setupFinished();
        }
        if (this.vfEmitter != null) {
            this.emitter = this.vfEmitter.getInitializer();
            this.particleSystem.setParticleInitializer(this.emitter);
            this.emitter.setMaxParticleCount(this.vfMaxParticles);
            this.emitter.setLifetimeVariation(this.vfLifetimeVariation);
            this.emitter.setParticleLifetime((int)(this.vfParticleLifetime * 1000.0f));
            this.vfIsActive = true;
        }
        if (this.vfEmitter == null && this.pEmitter == null) {
            this.vfIsActive = false;
        }
        this.particleSystem.addParticleFunction((ParticleFunction)this.timeFunction);
        int n3 = this.physicsNodes.size();
        this.vfPhysics = new VRMLNodeType[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.vfPhysics[n2] = (VRMLNodeType)this.physicsNodes.get(n2);
            this.vfPhysics[n2].setupFinished();
            ParticleFunction particleFunction = this.findParticleFunction(this.vfPhysics[n2]);
            this.particleSystem.addParticleFunction(particleFunction);
        }
        this.physicsNodes = null;
        this.particleSystem.addParticleFunction((ParticleFunction)new PhysicsFunction());
        this.particleSystem.enableParticleCreation(this.vfCreateParticles);
        if (this.vfColorRamp != null) {
            n2 = this.vfColorRamp.getNumColorComponents();
            boolean bl = n2 == 4;
            n = this.vfColorRamp.getFieldIndex("color");
            VRMLFieldData vRMLFieldData = this.vfColorRamp.getFieldValue(n);
            this.colorFunction = new ColorRampFunction(this.vfColorKey, vRMLFieldData.floatArrayValue, vRMLFieldData.numElements, bl);
            this.particleSystem.addParticleFunction((ParticleFunction)this.colorFunction);
        }
        if (this.vfTexCoordRamp != null && this.numTexCoordKey != 0) {
            n2 = this.vfTexCoordRamp.getSize(0);
            float[] fArray = new float[n2];
            this.vfTexCoordRamp.getPoint(0, fArray);
            n = 0;
            switch (this.geometryType) {
                case 1: 
                case 2: {
                    n = 8;
                    break;
                }
                case 3: {
                    n = 4;
                }
            }
            int n4 = (n2 /= n) < this.numTexCoordKey ? n2 : this.numTexCoordKey;
            float[] fArray2 = new float[n4];
            for (int i = 0; i < n4; ++i) {
                fArray2[i] = this.vfTexCoordKey[i] * 1000.0f;
            }
            this.particleSystem.setTexCoordFunction(fArray2, n4, fArray);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 18) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 66;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pAppearance != null ? this.pAppearance : this.vfAppearance;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pEmitter != null ? this.pEmitter : this.vfEmitter;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pColorRamp != null ? this.pColorRamp : this.vfColorRamp;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.vfPhysics;
                vRMLFieldData.numElements = this.vfPhysics != null ? this.vfPhysics.length : 0;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfColorKey;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.vfColorKey.length;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxSize;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxCenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfMaxParticles;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfParticleLifetime;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfLifetimeVariation;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfGeometryType;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 14: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 15: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfParticleSize;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 16: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfCreateParticles;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    if (this.pAppearance != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pAppearance);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfAppearance);
                    break;
                }
                case 12: {
                    if (this.pColorRamp != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pColorRamp);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfColorRamp);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfColorKey, this.numColorKey);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfMaxParticles);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfParticleLifetime);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfLifetimeVariation);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfParticleSize, 2);
                    break;
                }
                case 16: {
                    vRMLNodeType.setValue(n2, this.vfCreateParticles);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setEnabled(bl);
                break;
            }
            case 14: {
                throw new InvalidFieldAccessException(ACTIVE_WRITE_MSG);
            }
            case 16: {
                this.setCreateParticles(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                this.setMaxParticles(n2);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: geometryType");
                }
                this.vfGeometryType = string;
                Integer n2 = (Integer)geomTypeMap.get(this.vfGeometryType);
                this.geometryType = n2;
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 9: {
                this.setLifetimeVariation(f);
                break;
            }
            case 8: {
                this.setParticleLifetime(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 4: {
                this.setBboxCenter(fArray);
                break;
            }
            case 3: {
                this.setBboxSize(fArray);
                break;
            }
            case 13: {
                this.setColorKey(fArray, n2);
                break;
            }
            case 18: {
                this.setTexCoordKey(fArray, n2);
                break;
            }
            case 15: {
                this.setParticleSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 1: {
                this.setAppearance(vRMLNodeType2);
                break;
            }
            case 12: {
                this.setColorRamp(vRMLNodeType2);
                break;
            }
            case 17: {
                this.setTexCoordRamp(vRMLNodeType2);
                break;
            }
            case 10: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: emitter");
                }
                this.setEmitter(vRMLNodeType);
                break;
            }
            case 11: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: physics");
                }
                this.addPhysics(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 11: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: physics");
                }
                for (int i = 0; i < n2; ++i) {
                    this.addPhysics(vRMLNodeTypeArray[i]);
                }
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    protected void setParticleSize(float[] fArray) throws InvalidFieldValueException {
        if (fArray[0] < 0.0f || fArray[1] < 0.0f) {
            throw new InvalidFieldValueException(NEG_SIZE_ERR + fArray[0] + " " + fArray[1]);
        }
        this.vfParticleSize[0] = fArray[0];
        this.vfParticleSize[1] = fArray[1];
        if (!this.inSetup) {
            this.hasChanged[15] = true;
            this.fireFieldChanged(15);
        }
    }

    private void setColorKey(float[] fArray, int n) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: colorKey");
        }
        if (n > this.numColorKey || this.vfColorKey == null) {
            this.vfColorKey = new float[n];
        }
        this.numColorKey = n;
        if (fArray[0] < 0.0f) {
            throw new InvalidFieldValueException("colorKey[0] is < 0");
        }
        this.vfColorKey[0] = fArray[0];
        for (int i = 1; i < n; ++i) {
            if (fArray[i] <= fArray[i - 1]) {
                throw new InvalidFieldValueException("colorKey[" + i + "] is <= colorKey[" + (i - 1) + "]");
            }
            this.vfColorKey[i] = fArray[i];
        }
    }

    private void setTexCoordKey(float[] fArray, int n) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: texCoordKey");
        }
        if (n > this.numTexCoordKey || this.vfTexCoordKey == null) {
            this.vfTexCoordKey = new float[n];
        }
        this.numTexCoordKey = n;
        if (fArray[0] < 0.0f) {
            throw new InvalidFieldValueException("texCoordKey[0] is < 0");
        }
        this.vfTexCoordKey[0] = fArray[0];
        for (int i = 1; i < n; ++i) {
            if (fArray[i] <= fArray[i - 1]) {
                throw new InvalidFieldValueException("texCoordKey[" + i + "] is <= texCoordKey[" + (i - 1) + "]");
            }
            this.vfTexCoordKey[i] = fArray[i];
        }
    }

    private void setBboxCenter(float[] fArray) throws InvalidFieldAccessException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: bboxCenter");
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    private void setBboxSize(float[] fArray) throws InvalidFieldAccessException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: bboxSize");
        }
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    private void setMaxParticles(int n) throws InvalidFieldValueException {
        if (n < 0) {
            throw new InvalidFieldValueException(NEG_PARTICLES_ERR);
        }
        this.vfMaxParticles = n;
        if (!this.inSetup) {
            this.particleSystem.setMaxParticleCount(this.vfMaxParticles);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    private void setParticleLifetime(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_LIFETIME_ERR);
        }
        this.vfParticleLifetime = f;
        if (!this.inSetup) {
            this.emitter.setParticleLifetime((int)(this.vfParticleLifetime * 1000.0f));
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void setLifetimeVariation(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(VARIATION_RANGE_ERR);
        }
        this.vfLifetimeVariation = f;
        if (!this.inSetup) {
            this.emitter.setLifetimeVariation(f);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setCreateParticles(boolean bl) throws InvalidFieldValueException {
        this.vfCreateParticles = bl;
        if (!this.inSetup) {
            this.particleSystem.enableParticleCreation(bl);
            this.hasChanged[16] = true;
            this.fireFieldChanged(16);
        }
    }

    private void setColorRamp(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: colorRamp");
        }
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                throw new InvalidFieldValueException(COLOR_PROTO_MSG);
            }
            this.vfColorRamp = (VRMLColorNodeType)vRMLNodeType2;
            this.pColorRamp = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLColorNodeType)) {
                throw new InvalidFieldValueException(COLOR_NODE_MSG);
            }
            this.pColorRamp = null;
            this.vfColorRamp = (VRMLColorNodeType)vRMLNodeType;
        }
    }

    private void setTexCoordRamp(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: texCoordRamp");
        }
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLTextureCoordinateNodeType)) {
                throw new InvalidFieldValueException(TEXCOORD_PROTO_MSG);
            }
            this.vfTexCoordRamp = (VRMLTextureCoordinateNodeType)vRMLNodeType2;
            this.pTexCoordRamp = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTextureCoordinateNodeType)) {
                throw new InvalidFieldValueException(TEXCOORD_NODE_MSG);
            }
            this.pTexCoordRamp = null;
            this.vfTexCoordRamp = (VRMLTextureCoordinateNodeType)vRMLNodeType;
        }
    }

    private void setEmitter(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: emitter");
        }
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLParticleEmitterNodeType)) {
                throw new InvalidFieldValueException(EMITTER_PROTO_MSG);
            }
            this.vfEmitter = (VRMLParticleEmitterNodeType)vRMLNodeType2;
            this.pEmitter = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLParticleEmitterNodeType)) {
                throw new InvalidFieldValueException(EMITTER_NODE_MSG);
            }
            this.pEmitter = null;
            this.vfEmitter = (VRMLParticleEmitterNodeType)vRMLNodeType;
        }
    }

    private void addPhysics(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLParticlePhysicsModelNodeType)) {
                throw new InvalidFieldValueException(PHYSICS_PROTO_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLParticlePhysicsModelNodeType)) {
            throw new InvalidFieldValueException(PHYSICS_NODE_MSG);
        }
        this.physicsNodes.add(vRMLNodeType);
    }

    private ParticleFunction findParticleFunction(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        ParticleFunction particleFunction = null;
        VRMLParticlePhysicsModelNodeType vRMLParticlePhysicsModelNodeType = null;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null) {
                vRMLParticlePhysicsModelNodeType = (VRMLParticlePhysicsModelNodeType)vRMLNodeType2;
            }
        } else if (vRMLNodeType != null) {
            vRMLParticlePhysicsModelNodeType = (VRMLParticlePhysicsModelNodeType)vRMLNodeType;
        }
        if (vRMLParticlePhysicsModelNodeType != null) {
            particleFunction = vRMLParticlePhysicsModelNodeType.getParticleFunction();
        }
        return particleFunction;
    }

    static {
        nodeFields = new int[]{2, 1, 12, 10, 11, 0};
        fieldDecl = new VRMLFieldDeclaration[19];
        fieldMap = new HashMap(57);
        BaseParticleSystem.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseParticleSystem.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "appearance");
        BaseParticleSystem.fieldDecl[12] = new VRMLFieldDeclaration(2, "SFNode", "colorRamp");
        BaseParticleSystem.fieldDecl[13] = new VRMLFieldDeclaration(2, "MFFloat", "colorKey");
        BaseParticleSystem.fieldDecl[10] = new VRMLFieldDeclaration(2, "SFNode", "emitter");
        BaseParticleSystem.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFNode", "physics");
        BaseParticleSystem.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseParticleSystem.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseParticleSystem.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFString", "geometryType");
        BaseParticleSystem.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseParticleSystem.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFInt32", "maxParticles");
        BaseParticleSystem.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "particleLifetime");
        BaseParticleSystem.fieldDecl[15] = new VRMLFieldDeclaration(3, "SFVec2f", "particleSize");
        BaseParticleSystem.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFFloat", "lifetimeVariation");
        BaseParticleSystem.fieldDecl[14] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseParticleSystem.fieldDecl[16] = new VRMLFieldDeclaration(3, "SFBool", "createParticles");
        BaseParticleSystem.fieldDecl[17] = new VRMLFieldDeclaration(2, "SFNode", "texCoordRamp");
        BaseParticleSystem.fieldDecl[18] = new VRMLFieldDeclaration(2, "MFFloat", "texCoordKey");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("appearance", n);
        fieldMap.put("set_appearance", n);
        fieldMap.put("appearance_changed", n);
        n = new Integer(9);
        fieldMap.put("lifetimeVariation", n);
        fieldMap.put("set_lifetimeVariation", n);
        fieldMap.put("lifetimeVariation_changed", n);
        n = new Integer(7);
        fieldMap.put("maxParticles", n);
        fieldMap.put("set_maxParticles", n);
        fieldMap.put("maxParticles_changed", n);
        n = new Integer(8);
        fieldMap.put("particleLifetime", n);
        fieldMap.put("set_particleLifetime", n);
        fieldMap.put("particleLifetime_changed", n);
        n = new Integer(15);
        fieldMap.put("particleSize", n);
        fieldMap.put("set_particleSize", n);
        fieldMap.put("particleSize_changed", n);
        n = new Integer(16);
        fieldMap.put("createParticles", n);
        fieldMap.put("set_createParticles", n);
        fieldMap.put("createParticles_changed", n);
        n = new Integer(6);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("emitter", new Integer(10));
        fieldMap.put("physics", new Integer(11));
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(3));
        fieldMap.put("geometryType", new Integer(5));
        fieldMap.put("isActive", new Integer(14));
        fieldMap.put("colorRamp", new Integer(12));
        fieldMap.put("colorKey", new Integer(13));
        fieldMap.put("texCoordRamp", new Integer(17));
        fieldMap.put("texCoordKey", new Integer(18));
        geomTypeMap = new HashMap();
        geomTypeMap.put("QUAD", new Integer(1));
        geomTypeMap.put("TRIANGLE", new Integer(2));
        geomTypeMap.put("LINE", new Integer(3));
        geomTypeMap.put("POINT", new Integer(4));
        geomTypeMap.put("SPRITE", new Integer(5));
        geomTypeMap.put("GEOMETRY", new Integer(6));
    }
}

