/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.navigation;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLViewDependentNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;

public abstract class BaseLOD
extends BaseGroupingNode
implements VRMLViewDependentNodeType {
    protected static final int[] SECONDARY_TYPE = new int[]{88};
    protected static final int FIELD_CENTER = 6;
    protected static final int FIELD_RANGE = 7;
    protected static final int FIELD_LEVEL_CHANGED = 8;
    protected static final int FIELD_FORCE_TRANSITIONS = 9;
    protected static final int LAST_LOD_INDEX = 9;
    protected static final int NUM_FIELDS = 10;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfCenter;
    protected float[] vfRange;
    protected int rangeLen;
    protected float[] rangeSquared;
    protected boolean vfForceTransitions;
    protected int vfLevelChanged;

    protected BaseLOD() {
        super("LOD");
        this.hasChanged = new boolean[10];
        this.vfCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfRange = new float[0];
        this.rangeSquared = new float[0];
        this.rangeLen = 0;
        this.vfForceTransitions = false;
    }

    protected BaseLOD(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("range");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.floatArrayValue.length > this.rangeLen) {
                this.vfRange = new float[vRMLFieldData.floatArrayValue.length];
                this.rangeSquared = new float[vRMLFieldData.floatArrayValue.length];
            }
            this.rangeLen = vRMLFieldData.numElements;
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfRange, 0, this.rangeLen);
            for (int i = 0; i < this.rangeLen; ++i) {
                this.rangeSquared[i] = this.vfRange[i] * this.vfRange[i];
            }
            n = vRMLNodeType.getFieldIndex("forceTransitions");
            if (n != -1) {
                vRMLFieldData = vRMLNodeType.getFieldValue(n);
                this.vfForceTransitions = vRMLFieldData.booleanValue;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public int getFieldIndex(String string) {
        int n;
        Integer n2 = (Integer)fieldMap.get(string);
        int n3 = n = n2 == null ? -1 : n2;
        if ((n == 9 || n == 8) && (this.vrmlMajorVersion == 2 || this.vrmlMajorVersion == 3 && this.vrmlMinorVersion == 0)) {
            n = -1;
        }
        return n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 9) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfCenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfRange;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.rangeLen;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfLevelChanged;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfForceTransitions;
                vRMLFieldData.dataType = 1;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfRange, this.rangeLen);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfLevelChanged);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setCenter(fArray);
                break;
            }
            case 7: {
                this.setRange(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 9: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("forceTransitions is an initialize-only field");
                }
                this.vfForceTransitions = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    protected void setCenter(float[] fArray) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("Center is an initialize-only field");
        }
        if (fArray == null) {
            throw new InvalidFieldValueException("Center value null");
        }
        this.vfCenter[0] = fArray[0];
        this.vfCenter[1] = fArray[1];
        this.vfCenter[2] = fArray[2];
    }

    protected void setRange(float[] fArray, int n) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("Range is an initialize-only field");
        }
        if (n == 0) {
            this.rangeLen = 0;
        } else {
            int n2 = n;
            while (--n2 >= 0) {
                if (!(fArray[n2] < 0.0f)) continue;
                throw new InvalidFieldValueException("Negative range value " + fArray[n2]);
            }
            if (n > this.vfRange.length) {
                this.vfRange = new float[n];
                this.rangeSquared = new float[n];
            }
            this.rangeLen = n;
            System.arraycopy(fArray, 0, this.vfRange, 0, this.rangeLen);
            for (n2 = 0; n2 < this.rangeLen; ++n2) {
                this.rangeSquared[n2] = this.vfRange[n2] * this.vfRange[n2];
            }
        }
    }

    protected void setLevelChanged(int n) {
        this.vfLevelChanged = n;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[10];
        fieldMap = new HashMap(10);
        BaseLOD.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseLOD.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseLOD.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseLOD.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseLOD.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseLOD.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseLOD.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFVec3f", "center");
        BaseLOD.fieldDecl[7] = new VRMLFieldDeclaration(2, "MFFloat", "range");
        BaseLOD.fieldDecl[9] = new VRMLFieldDeclaration(2, "SFBool", "forceTransitions");
        BaseLOD.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFInt32", "level_changed");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        fieldMap.put("level", n);
        fieldMap.put("set_level", n);
        fieldMap.put("level_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        fieldMap.put("center", new Integer(6));
        fieldMap.put("range", new Integer(7));
        fieldMap.put("level_changed", new Integer(8));
        fieldMap.put("forceTransitions", new Integer(9));
    }
}

