/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.navigation;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLCollidableNodeType;
import org.web3d.vrml.nodes.VRMLEnvironmentalSensorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;

public abstract class BaseCollision
extends BaseGroupingNode
implements VRMLEnvironmentalSensorNodeType,
VRMLTimeDependentNodeType,
VRMLCollidableNodeType {
    protected static final String PROXY_PROTO_MSG = "Proto does not describe a proxy object";
    protected static final String PROXY_NODE_MSG = "Node does not describe a proxy object";
    private static final int[] SECONDARY_TYPE = new int[]{14, 52, 8};
    protected static final int FIELD_COLLIDE = 6;
    protected static final int FIELD_PROXY = 7;
    protected static final int FIELD_COLLIDE_TIME = 8;
    protected static final int FIELD_ISACTIVE = 9;
    protected static final int FIELD_ENABLED = 10;
    protected static final int LAST_COLLIDE_INDEX = 10;
    private static final int NUM_FIELDS = 11;
    private static final String COLLIDE_WRITE_MSG = "collideTime is an outputOnly field. You cannot write to it";
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected boolean vfCollide;
    protected VRMLChildNodeType vfProxy;
    protected VRMLProtoInstance pProxy;
    protected double vfCollideTime;
    protected boolean vfIsActive;
    protected VRMLClock vrmlClock;

    protected BaseCollision() {
        super("Collision");
        this.hasChanged = new boolean[11];
        this.vfCollide = true;
        this.vfIsActive = false;
        this.vfCollideTime = 0.0;
    }

    protected BaseCollision(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
    }

    public void setEnabled(boolean bl) {
        this.setCollide(bl);
    }

    public boolean getEnabled() {
        return this.vfCollide;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    public void collisionDetected() {
        if (!this.vfCollide) {
            return;
        }
        this.vfCollideTime = this.vrmlClock.getTime();
        this.hasChanged[8] = true;
        this.fireFieldChanged(8);
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 6: 
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfCollide;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfCollideTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pProxy != null ? this.pProxy : this.vfProxy;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: 
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfCollide);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfCollideTime);
                    break;
                }
                case 7: {
                    if (this.pProxy != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pProxy);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfProxy);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: 
            case 10: {
                this.setCollide(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                throw new InvalidFieldAccessException(COLLIDE_WRITE_MSG);
            }
        }
        super.setValue(n, d);
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 7: {
                this.setProxy(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setProxy(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLChildNodeType vRMLChildNodeType;
        Object object = this.pProxy != null ? this.pProxy : this.vfProxy;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLChildNodeType)) {
                throw new InvalidFieldValueException(PROXY_PROTO_MSG);
            }
            vRMLChildNodeType = (VRMLChildNodeType)vRMLNodeType2;
            this.pProxy = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLChildNodeType)) {
                throw new InvalidFieldValueException(PROXY_NODE_MSG);
            }
            this.pProxy = null;
            vRMLChildNodeType = (VRMLChildNodeType)vRMLNodeType;
        }
        this.vfProxy = vRMLChildNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
        if (!this.inSetup) {
            if (object != null) {
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    protected void setCollide(boolean bl) {
        this.vfCollide = bl;
        if (this.inSetup) {
            return;
        }
        if (this.vrmlMajorVersion == 2) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        } else {
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    protected void setIsActive(boolean bl) {
        this.vfIsActive = bl;
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    static {
        nodeFields = new int[]{1, 7, 0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(22);
        BaseCollision.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCollision.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseCollision.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseCollision.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseCollision.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseCollision.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseCollision.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFBool", "collide");
        BaseCollision.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFNode", "proxy");
        BaseCollision.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFTime", "collideTime");
        BaseCollision.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseCollision.fieldDecl[9] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        fieldMap.put("addChildren", new Integer(2));
        fieldMap.put("removeChildren", new Integer(3));
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        fieldMap.put("proxy", new Integer(7));
        fieldMap.put("collideTime", new Integer(8));
        fieldMap.put("isActive", new Integer(9));
        n = new Integer(6);
        fieldMap.put("collide", n);
        fieldMap.put("set_collide", n);
        fieldMap.put("collide_changed", n);
        n = new Integer(10);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
    }
}

