/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.marker;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.nodes.VRMLWorldRootChildNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.URLChecker;

public abstract class BaseScreenMarker
extends AbstractNode
implements VRMLWorldRootChildNodeType,
VRMLSingleExternalNodeType {
    protected static final int FIELD_ENABLED = 1;
    protected static final int FIELD_WIDTH = 2;
    protected static final int FIELD_HEIGHT = 3;
    protected static final int FIELD_REPRESENTS = 4;
    protected static final int FIELD_ICON_URL = 5;
    protected static final int LAST_SCREENMARKER_INDEX = 5;
    protected static final int NUM_FIELDS = 6;
    protected static final String BAD_PROTO_MSG = "Proto does not describe an X3DChildNode";
    protected static final String BAD_NODE_MSG = "Node is not an X3DChildNode";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int loadState;
    private String worldURL;
    private ArrayList urlListeners;
    private ArrayList contentListeners = new ArrayList();
    protected String loadedURI;
    protected boolean vfEnabled;
    protected float vfWidth;
    protected float vfHeight;
    protected String[] vfURL;
    protected VRMLChildNodeType vfRepresents;
    protected VRMLProtoInstance pRepresents;

    protected BaseScreenMarker() {
        super("ScreenMarker");
        this.urlListeners = new ArrayList(1);
        this.hasChanged = new boolean[6];
        this.vfURL = FieldConstants.EMPTY_MFSTRING;
        this.vfWidth = 1.0f;
        this.vfHeight = 1.0f;
        this.vfEnabled = true;
        this.loadState = 1;
    }

    protected BaseScreenMarker(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("iconUrl");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfURL = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfURL, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("enabled");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("width");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfWidth = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("height");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHeight = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (this.loadedURI == null) break;
                System.out.println("Loading failed: " + this.loadedURI);
                break;
            }
            default: {
                System.out.println("Unknown state: " + n);
            }
        }
        this.loadState = n;
        if (n != 3) {
            this.fireContentStateChanged();
        }
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        this.worldURL = string;
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfURL = n > 0 ? (this.worldURL != null ? URLChecker.checkURLs((String)this.worldURL, (String[])stringArray, (boolean)false) : stringArray) : FieldConstants.EMPTY_MFSTRING;
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public String[] getUrl() {
        if (this.worldURL != null) {
            URLChecker.checkURLsInPlace((String)this.worldURL, (String[])this.vfURL, (boolean)false);
        }
        return this.vfURL;
    }

    public boolean checkValidContentType(String string) {
        return string.indexOf("image") >= 0;
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
    }

    public void setLoadedURI(String string) {
        this.loadedURI = string;
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 63;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfWidth;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfHeight;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfURL;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfURL.length;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pRepresents != null ? this.pRepresents : this.vfRepresents;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                return super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfWidth);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfHeight);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfURL, this.vfURL.length);
                    break;
                }
                case 4: {
                    if (this.pRepresents != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pRepresents);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfRepresents);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setWidth(f);
                break;
            }
            case 3: {
                this.setHeight(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.vfURL = new String[1];
                this.vfURL[0] = string;
                if (this.inSetup) break;
                this.loadState = 1;
                this.fireUrlChanged(n);
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.vfURL = new String[n2];
                System.arraycopy(stringArray, 0, this.vfURL, 0, n2);
                if (this.inSetup) break;
                this.loadState = 1;
                this.fireUrlChanged(n);
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setRepresents(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    protected void setEnabled(boolean bl) {
        this.vfEnabled = bl;
    }

    protected void setWidth(float f) {
        this.vfWidth = f;
    }

    protected void setHeight(float f) {
        this.vfHeight = f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setRepresents(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType == null) {
            this.vfRepresents = null;
            this.pRepresents = null;
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            if (!(vRMLNodeType2 instanceof VRMLChildNodeType)) throw new InvalidFieldValueException(BAD_PROTO_MSG);
            this.vfRepresents = (VRMLChildNodeType)vRMLNodeType2;
            this.pRepresents = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (!(vRMLNodeType instanceof VRMLChildNodeType)) throw new InvalidFieldValueException(BAD_NODE_MSG);
            this.vfRepresents = (VRMLChildNodeType)vRMLNodeType;
            this.pRepresents = null;
        }
        if (this.inSetup) return;
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
    }

    protected void fireUrlChanged(int n) {
        int n2 = this.urlListeners.size();
        for (int i = 0; i < n2; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged((VRMLNodeType)this, n);
        }
    }

    protected void fireContentStateChanged() {
        int n = this.contentListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged((VRMLNodeType)this, 5, this.loadState);
        }
    }

    static {
        nodeFields = new int[]{0, 4};
        fieldDecl = new VRMLFieldDeclaration[6];
        fieldMap = new HashMap(18);
        BaseScreenMarker.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseScreenMarker.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseScreenMarker.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFFloat", "enabled");
        BaseScreenMarker.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "enabled");
        BaseScreenMarker.fieldDecl[5] = new VRMLFieldDeclaration(3, "MFString", "iconUrl");
        BaseScreenMarker.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFNode", "represents");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(2);
        fieldMap.put("width", n);
        fieldMap.put("set_width", n);
        fieldMap.put("width_changed", n);
        n = new Integer(3);
        fieldMap.put("height", n);
        fieldMap.put("set_height", n);
        fieldMap.put("height_changed", n);
        n = new Integer(5);
        fieldMap.put("iconUrl", n);
        fieldMap.put("set_iconUrl", n);
        fieldMap.put("iconUrl_changed", n);
        fieldMap.put("represents", new Integer(4));
    }
}

