/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.layering;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.LayerListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLLayerNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLViewportNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseLayer
extends AbstractNode
implements VRMLLayerNodeType {
    protected static final int FIELD_ADDCHILDREN = 1;
    protected static final int FIELD_REMOVECHILDREN = 2;
    protected static final int FIELD_CHILDREN = 3;
    protected static final int FIELD_IS_PICKABLE = 4;
    protected static final int FIELD_VIEWPORT = 5;
    protected static final int LAST_LAYER_INDEX = 5;
    protected static final int NUM_FIELDS = 6;
    protected static final String VIEWPORT_PROTO_MSG = "Proto does not describe a X3DViewportNode object";
    protected static final String VIEWPORT_NODE_MSG = "Node does not describe a X3DViewportNode object";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected int layerId = -1;
    protected ArrayList vfChildren = new ArrayList();
    protected boolean vfIsPickable = true;
    protected VRMLProtoInstance pViewport;
    protected VRMLViewportNodeType vfViewport;
    protected ArrayList layerListeners = new ArrayList(1);

    protected BaseLayer() {
        super("Layer");
        this.hasChanged = new boolean[6];
    }

    protected BaseLayer(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("isPickable");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfIsPickable = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void addLayerListener(LayerListener layerListener) {
        if (!this.layerListeners.contains(layerListener)) {
            this.layerListeners.add(layerListener);
        }
    }

    public void removeLayerListener(LayerListener layerListener) {
        this.layerListeners.remove(layerListener);
    }

    public boolean isPickable() {
        return this.vfIsPickable;
    }

    public void setPickable(boolean bl) {
        if (bl == this.vfIsPickable) {
            return;
        }
        this.vfIsPickable = bl;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public void setViewport(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        VRMLNodeType vRMLNodeType2;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "viewport");
        }
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pViewport = (VRMLProtoInstance)vRMLNodeType;
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLViewportNodeType)) {
                throw new InvalidFieldValueException(VIEWPORT_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLViewportNodeType)) {
                throw new InvalidFieldValueException(VIEWPORT_NODE_MSG);
            }
            this.pViewport = null;
            vRMLNodeType2 = (VRMLViewportNodeType)vRMLNodeType;
        }
        this.vfViewport = (VRMLViewportNodeType)vRMLNodeType2;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
    }

    public VRMLNodeType getViewport() {
        return this.vfViewport;
    }

    public int getViewportType() {
        int n = 1;
        if (this.vfViewport == null) {
            if (this.pViewport != null) {
                n = 0;
            }
        } else {
            n = this.vfViewport.getViewportType();
        }
        return n;
    }

    public void setLayerId(int n) {
        this.layerId = n;
        this.updateRefCount(n, true);
        int n2 = this.vfChildren.size();
        for (int i = 0; i < n2; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfChildren.get(i);
            if (vRMLNodeType == null) continue;
            this.updateRefs(vRMLNodeType, true);
        }
        if (this.vfViewport != null) {
            this.updateRefs((VRMLNodeType)this.vfViewport, true);
        }
    }

    public int getLayerId() {
        return this.layerId;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getNumFields() {
        return 6;
    }

    public int getPrimaryType() {
        return 89;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        for (int i = 0; i < this.vfChildren.size(); ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfChildren.get(i);
            vRMLNodeType.setupFinished();
        }
        if (this.pViewport != null) {
            this.pViewport.setupFinished();
        } else if (this.vfViewport != null) {
            this.vfViewport.setupFinished();
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                int n2 = this.vfChildren.size();
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n2];
                this.vfChildren.toArray(vRMLNodeTypeArray);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = vRMLNodeTypeArray;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = n2;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pViewport != null ? this.pViewport : this.vfViewport;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsPickable;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    int n3 = this.vfChildren.size();
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n3];
                    this.vfChildren.toArray(vRMLNodeTypeArray);
                    vRMLNodeType.setValue(n2, vRMLNodeTypeArray, n3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfIsPickable);
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldAccessException {
        switch (n) {
            case 4: {
                this.setPickable(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        boolean bl = false;
        switch (n) {
            case 3: {
                if (!this.inSetup) {
                    this.clearChildren();
                }
                if (vRMLNodeType != null) {
                    this.addChildNode(vRMLNodeType);
                }
                bl = true;
                break;
            }
            case 1: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set an inputOnly field in a file: addChildren");
                }
                if (vRMLNodeType != null) {
                    this.addChildNode(vRMLNodeType);
                }
                bl = true;
                break;
            }
            case 5: {
                this.setViewport(vRMLNodeType);
                break;
            }
            case 2: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set an inputOnly field in a file: removeChildren");
                }
                if (vRMLNodeType != null) {
                    this.removeChildNode(vRMLNodeType);
                }
                bl = true;
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup && bl) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 3: {
                if (!this.inSetup) {
                    this.clearChildren();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addChildNode(vRMLNodeTypeArray[i]);
                }
                break;
            }
            case 1: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set an inputOnly field in a file: addChildren");
                }
                for (int i = 0; i < n2; ++i) {
                    this.addChildNode(vRMLNodeTypeArray[i]);
                }
                break;
            }
            case 2: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set an inputOnly field in a file: removehildren");
                }
                for (int i = 0; i < n2; ++i) {
                    this.removeChildNode(vRMLNodeTypeArray[i]);
                }
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    protected void clearChildren() {
        int n = this.vfChildren.size();
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n];
        this.vfChildren.toArray(vRMLNodeTypeArray);
        for (int i = 0; i < n; ++i) {
            if (vRMLNodeTypeArray[i] instanceof VRMLGroupingNodeType) {
                ((VRMLGroupingNodeType)vRMLNodeTypeArray[i]).setShared(false);
            }
            if (this.layerId == -1) continue;
            this.updateRefs(vRMLNodeTypeArray[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes((VRMLNode[])vRMLNodeTypeArray);
        }
        this.vfChildren.clear();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLGroupingNodeType) {
            ((VRMLGroupingNodeType)vRMLNodeType).setShared(true);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 instanceof VRMLGroupingNodeType) {
                ((VRMLGroupingNodeType)vRMLNodeType2).setShared(true);
            }
        }
        this.vfChildren.add(vRMLNodeType);
        if (this.layerId != -1) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (!this.inSetup) {
            this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType instanceof VRMLGroupingNodeType) {
            ((VRMLGroupingNodeType)vRMLNodeType).setShared(false);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 instanceof VRMLGroupingNodeType) {
                ((VRMLGroupingNodeType)vRMLNodeType2).setShared(false);
            }
        }
        if (this.layerId != -1) {
            this.updateRefs(vRMLNodeType, false);
        }
        if (!this.inSetup) {
            this.vfChildren.remove(vRMLNodeType);
        }
        if (!this.inSetup) {
            this.stateManager.registerRemovedNode((VRMLNode)vRMLNodeType);
        }
    }

    static {
        nodeFields = new int[]{0, 5, 3};
        fieldDecl = new VRMLFieldDeclaration[6];
        fieldMap = new HashMap(18);
        BaseLayer.fieldDecl[1] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseLayer.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseLayer.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "isPickable");
        BaseLayer.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseLayer.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseLayer.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFNode", "viewport");
        Integer n = new Integer(3);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(4);
        fieldMap.put("isPickable", n);
        fieldMap.put("set_isPickable", n);
        fieldMap.put("isPickable_changed", n);
        n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("viewport", new Integer(5));
        fieldMap.put("addChildren", new Integer(1));
        fieldMap.put("removeChildren", new Integer(2));
    }
}

