/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.operation.transform.GeocentricTransform;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.NavigationInfoChangeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.ViewpointListener;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.BaseBindableNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;

public abstract class BaseGeoViewpoint
extends BaseBindableNode
implements VRMLViewpointNodeType,
VRMLNavigationInfoNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{5, 52, 31};
    protected static final int FIELD_FIELDOFVIEW = 4;
    protected static final int FIELD_JUMP = 5;
    protected static final int FIELD_SET_ORIENTATION = 6;
    protected static final int FIELD_SET_POSITION = 7;
    protected static final int FIELD_HEADLIGHT = 8;
    protected static final int FIELD_NAV_TYPE = 10;
    protected static final int FIELD_DESCRIPTION = 11;
    protected static final int FIELD_GEO_ORIGIN = 12;
    protected static final int FIELD_GEO_SYSTEM = 13;
    protected static final int FIELD_ORIENTATION = 14;
    protected static final int FIELD_POSITION = 15;
    protected static final int FIELD_SPEED_FACTOR = 16;
    protected static final int FIELD_RETAIN_USER_OFFSETS = 17;
    protected static final int LAST_VIEWPOINT_INDEX = 17;
    protected static final int NUM_FIELDS = 18;
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the coordinate values for some reason.";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap<String, Integer> fieldMap;
    private static final int[] nodeFields;
    private static final Vector3d YUP;
    private Vector3d XUP = new Vector3d(1.0, 0.0, 0.0);
    protected float vfFieldOfView = 0.785398f;
    protected boolean vfJump = true;
    protected boolean vfRetainUserOffsets;
    protected boolean vfHeadlight = true;
    protected float[] vfOrientation;
    protected double[] vfPosition;
    protected String vfDescription;
    protected String[] vfNavType;
    protected String[] vfGeoSystem;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLNodeType vfGeoOrigin;
    protected float vfSpeedFactor = 1.0f;
    private float correctedSpeed = 1.0f;
    private float[] correctedAvatarSize;
    protected double[] localPosition;
    private MathTransform geoTransform;
    private boolean geoCoordSwap;
    protected ArrayList<NavigationInfoChangeListener> changeListener;
    protected ArrayList<ViewpointListener> viewpointListeners;
    protected float[] centerOfRotation;
    protected AxisAngle4f axis;
    private Vector3d posVec;
    private Quat4d qx;
    private Quat4d qz;
    private Quat4d qr;
    private AxisAngle4d tmpAxis;
    private Quat4d local_quat;
    private Quat4d rel_quat;
    private Quat4d comb_quat;
    private GeocentricTransform gt;
    private double[] wgs84 = new double[3];
    private double[] ecef = new double[3];

    protected BaseGeoViewpoint() {
        super("GeoViewpoint");
        this.vfOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfPosition = new double[]{0.0, 0.0, 100000.0};
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.vfNavType = new String[]{"EXAMINE", "ANY"};
        this.correctedAvatarSize = new float[]{0.25f, 1.6f, 0.75f};
        this.posVec = new Vector3d();
        this.qx = new Quat4d();
        this.qz = new Quat4d();
        this.qr = new Quat4d();
        this.tmpAxis = new AxisAngle4d();
        this.axis = new AxisAngle4f();
        this.local_quat = new Quat4d();
        this.rel_quat = new Quat4d();
        this.comb_quat = new Quat4d();
        this.hasChanged = new boolean[18];
        this.localPosition = new double[3];
        this.viewpointListeners = new ArrayList(1);
        this.changeListener = new ArrayList();
        this.gt = new GeocentricTransform((Ellipsoid)DefaultEllipsoid.WGS84, true);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
    }

    protected BaseGeoViewpoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("fieldOfView");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFieldOfView = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("jump");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfJump = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("retainUserOffsets");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRetainUserOffsets = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("headlight");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHeadlight = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("orientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("position");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPosition[0] = vRMLFieldData.doubleArrayValue[0];
            this.vfPosition[1] = vRMLFieldData.doubleArrayValue[1];
            this.vfPosition[2] = vRMLFieldData.doubleArrayValue[2];
            n = vRMLNodeType.getFieldIndex("description");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDescription = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("navType");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfNavType = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfNavType, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("speedFactor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSpeedFactor = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void addViewpointListener(ViewpointListener viewpointListener) {
        if (!this.viewpointListeners.contains(viewpointListener)) {
            this.viewpointListeners.add(viewpointListener);
        }
    }

    public void removeViewpointListener(ViewpointListener viewpointListener) {
        this.viewpointListeners.remove(viewpointListener);
    }

    public int getProjectionType() {
        return 0;
    }

    public float[] getFieldOfView() {
        return new float[]{this.vfFieldOfView};
    }

    public void setFieldOfView(float f) throws InvalidFieldValueException {
        if (f <= 0.0f || f >= (float)Math.PI) {
            throw new InvalidFieldValueException("FieldOfView must be (0,PI)");
        }
        this.vfFieldOfView = f;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
            this.fireFieldOfViewChanged(new float[]{f});
        }
    }

    public boolean getJump() {
        return this.vfJump;
    }

    public void setJump(boolean bl) {
        this.vfJump = bl;
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public boolean getRetainUserOffsets() {
        return this.vfRetainUserOffsets;
    }

    public void setRetainUserOffsets(boolean bl) {
        this.vfRetainUserOffsets = bl;
        if (!this.inSetup) {
            this.hasChanged[17] = true;
            this.fireFieldChanged(17);
        }
    }

    public String getDescription() {
        return this.vfDescription;
    }

    public void setDescription(String string) {
        this.vfDescription = string;
        if (!this.inSetup) {
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    public void setWorldLocation(Vector3f vector3f) {
        if (this.vfGeoOrigin != null) {
            double[] dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
            vector3f.x = (float)((double)vector3f.x + dArray[0]);
            vector3f.y = (float)((double)vector3f.y + dArray[1]);
            vector3f.z = (float)((double)vector3f.z + dArray[2]);
        }
        this.ecef[0] = vector3f.x;
        this.ecef[1] = vector3f.y;
        this.ecef[2] = vector3f.z;
        this.gt.inverseTransform(this.ecef, 0, this.wgs84, 0, 1);
        double d = this.wgs84[2];
        float f = 20.0f;
        if (d > 200.0) {
            f = (float)d / 10.0f;
        }
        this.correctedSpeed = f * this.vfSpeedFactor;
        this.correctedAvatarSize[0] = 0.25f * f;
        this.correctedAvatarSize[1] = 1.6f * f;
        this.correctedAvatarSize[2] = 0.75f * f;
        for (int i = 0; i < this.changeListener.size(); ++i) {
            NavigationInfoChangeListener navigationInfoChangeListener = this.changeListener.get(i);
            navigationInfoChangeListener.notifyAvatarSizeChanged(this.correctedAvatarSize, this.correctedAvatarSize.length);
            navigationInfoChangeListener.notifyNavigationSpeedChanged(this.correctedSpeed);
        }
    }

    public float[] getCenterOfRotation() {
        if (this.centerOfRotation != null) {
            return this.centerOfRotation;
        }
        return FieldConstants.EMPTY_SFVEC3F;
    }

    public void setCenterOfRotation(float[] fArray) throws InvalidFieldValueException {
        this.fireCenterOfRotationChanged(fArray);
    }

    public String[] getType() {
        return this.vfNavType;
    }

    public int getNumTypes() {
        return this.vfNavType.length;
    }

    public void addNavigationChangedListener(NavigationInfoChangeListener navigationInfoChangeListener) {
        if (!this.changeListener.contains(navigationInfoChangeListener)) {
            this.changeListener.add(navigationInfoChangeListener);
        }
    }

    public void removeNavigationChangedListener(NavigationInfoChangeListener navigationInfoChangeListener) {
        this.changeListener.remove(navigationInfoChangeListener);
    }

    public void setType(String[] stringArray, int n) throws InvalidFieldValueException {
        if (n == 0) {
            this.vfNavType = new String[]{"NONE"};
        } else {
            if (this.vfNavType.length != n) {
                this.vfNavType = new String[n];
            }
            System.arraycopy(stringArray, 0, this.vfNavType, 0, n);
        }
        if (!this.inSetup) {
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
            for (int i = 0; i < this.changeListener.size(); ++i) {
                NavigationInfoChangeListener navigationInfoChangeListener = this.changeListener.get(i);
                navigationInfoChangeListener.notifyNavigationModesChanged(this.vfNavType, n);
            }
        }
    }

    public float[] getAvatarSize() {
        return this.correctedAvatarSize;
    }

    public void setAvatarSize(float[] fArray, int n) throws InvalidFieldValueException {
    }

    public float getSpeed() {
        return this.correctedSpeed;
    }

    public void setSpeed(float f) throws InvalidFieldValueException {
    }

    public float getVisibilityLimit() {
        return 0.0f;
    }

    public void setVisibilityLimit(float f) throws InvalidFieldValueException {
    }

    public boolean getHeadlight() {
        return this.vfHeadlight;
    }

    public void setHeadlight(boolean bl) {
        if (bl != this.vfHeadlight) {
            this.vfHeadlight = bl;
            if (!this.inSetup) {
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
        }
        try {
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            boolean[] blArray = new boolean[1];
            this.geoTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
            this.geoCoordSwap = blArray[0];
            if (this.geoCoordSwap) {
                double d = this.vfPosition[0];
                this.vfPosition[0] = this.vfPosition[1];
                this.vfPosition[1] = d;
                this.geoTransform.transform(this.vfPosition, 0, this.localPosition, 0, 1);
                d = this.vfPosition[0];
                this.vfPosition[0] = this.vfPosition[1];
                this.vfPosition[1] = d;
            } else {
                this.geoTransform.transform(this.vfPosition, 0, this.localPosition, 0, 1);
            }
            if (this.vfGeoOrigin != null) {
                double[] dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                this.localPosition[0] = this.localPosition[0] - dArray[0];
                this.localPosition[1] = this.localPosition[1] - dArray[1];
                this.localPosition[2] = this.localPosition[2] - dArray[2];
                this.centerOfRotation = new float[3];
                this.centerOfRotation[0] = (float)dArray[0];
                this.centerOfRotation[0] = (float)dArray[1];
                this.centerOfRotation[0] = (float)dArray[2];
            }
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
    }

    public int getFieldIndex(String string) {
        int n;
        Integer n2 = fieldMap.get(string);
        int n3 = n = n2 == null ? -1 : n2;
        if (n == 17 && (this.vrmlMajorVersion == 2 || this.vrmlMajorVersion == 3 && this.vrmlMinorVersion < 2)) {
            n = -1;
        }
        return n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return n < 0 || n > 17 ? null : fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 55;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfDescription;
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfFieldOfView;
                vRMLFieldData.dataType = (short)4;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfJump;
                vRMLFieldData.dataType = 1;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 17: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfRetainUserOffsets;
                vRMLFieldData.dataType = 1;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfHeadlight;
                vRMLFieldData.dataType = 1;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 14: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfOrientation;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 15: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleArrayValue = this.vfPosition;
                vRMLFieldData.dataType = (short)12;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfGeoSystem;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            case 16: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSpeedFactor;
                vRMLFieldData.dataType = (short)4;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfNavType;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfNavType.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfFieldOfView);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfJump);
                    break;
                }
                case 17: {
                    vRMLNodeType.setValue(n2, this.vfRetainUserOffsets);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfHeadlight);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfDescription);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfNavType, this.vfNavType.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseViewpoint.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setJump(bl);
                break;
            }
            case 17: {
                this.setRetainUserOffsets(bl);
                break;
            }
            case 8: {
                this.setHeadlight(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setFieldOfView(f);
                break;
            }
            case 16: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: speedFactor");
                }
                this.vfSpeedFactor = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: 
            case 14: {
                this.setOrientation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: 
            case 15: {
                this.setPosition(dArray);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 11: {
                this.vfDescription = string;
                if (this.inSetup) break;
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 13: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            case 10: {
                this.setType(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 12: {
                this.setGeoOrigin(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setPosition(double[] dArray) {
        this.vfPosition[0] = dArray[0];
        this.vfPosition[1] = dArray[1];
        this.vfPosition[2] = dArray[2];
        if (!this.inSetup && this.geoTransform != null) {
            try {
                this.geoTransform.transform(this.vfPosition, 0, this.localPosition, 0, 1);
                if (this.geoCoordSwap) {
                    double d = this.vfPosition[0];
                    this.vfPosition[0] = this.vfPosition[1];
                    this.vfPosition[1] = d;
                    this.geoTransform.transform(this.vfPosition, 0, this.localPosition, 0, 1);
                    d = this.vfPosition[0];
                    this.vfPosition[0] = this.vfPosition[1];
                    this.vfPosition[1] = d;
                } else {
                    this.geoTransform.transform(this.vfPosition, 0, this.localPosition, 0, 1);
                }
                if (this.vfGeoOrigin != null) {
                    double[] dArray2 = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                    this.localPosition[0] = this.localPosition[0] - dArray2[0];
                    this.localPosition[1] = this.localPosition[1] - dArray2[1];
                    this.localPosition[2] = this.localPosition[2] - dArray2[2];
                }
            }
            catch (TransformException transformException) {
                this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
            }
        }
    }

    protected void setOrientation(float[] fArray) {
        this.vfOrientation[0] = fArray[0];
        this.vfOrientation[1] = fArray[1];
        this.vfOrientation[2] = fArray[2];
        this.vfOrientation[3] = fArray[3];
    }

    private void getLocalOrientation(double[] dArray, AxisAngle4d axisAngle4d) {
        this.posVec.x = dArray[0];
        this.posVec.y = dArray[1];
        this.posVec.z = dArray[2];
        double d = this.posVec.x * this.posVec.x + this.posVec.y * this.posVec.y + this.posVec.z * this.posVec.z;
        if (d != 0.0) {
            d = 1.0 / Math.sqrt(d);
            this.posVec.x *= d;
            this.posVec.y *= d;
            this.posVec.z *= d;
        } else {
            this.posVec.x = 0.0;
            this.posVec.y = 1.0;
            this.posVec.z = 0.0;
        }
        double d2 = YUP.angle(this.posVec);
        this.posVec.cross(YUP, this.posVec);
        this.posVec.normalize();
        axisAngle4d.x = (float)this.posVec.x;
        axisAngle4d.y = (float)this.posVec.y;
        axisAngle4d.z = (float)this.posVec.z;
        axisAngle4d.angle = (float)d2;
        d2 = this.XUP.angle(this.posVec);
        this.posVec.cross(this.XUP, this.posVec);
        this.posVec.normalize();
        Quat4d quat4d = new Quat4d();
        quat4d.set(axisAngle4d);
        Quat4d quat4d2 = new Quat4d();
        quat4d2.set(new AxisAngle4d(this.posVec.x, this.posVec.y, this.posVec.z, d2));
        quat4d.set(quat4d.w * quat4d2.x + quat4d.x * quat4d2.w + quat4d.y * quat4d2.z - quat4d.z * quat4d2.y, quat4d.w * quat4d2.y + quat4d.y * quat4d2.w + quat4d.z * quat4d2.x - quat4d.x * quat4d2.z, quat4d.w * quat4d2.z + quat4d.z * quat4d2.w + quat4d.x * quat4d2.y - quat4d.y * quat4d2.x, quat4d.w * quat4d2.w - quat4d.x * quat4d2.x - quat4d.y * quat4d2.y - quat4d.z * quat4d2.z);
        axisAngle4d.set(quat4d);
    }

    protected void convOriToAxisAngle() {
        double[] dArray;
        if (this.vfGeoOrigin != null) {
            dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
            this.localPosition[0] = this.localPosition[0] + dArray[0];
            this.localPosition[1] = this.localPosition[1] + dArray[1];
            this.localPosition[2] = this.localPosition[2] + dArray[2];
        }
        this.getLocalOrientation(this.localPosition, this.tmpAxis);
        if (this.vfGeoOrigin != null) {
            dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
            this.localPosition[0] = this.localPosition[0] - dArray[0];
            this.localPosition[1] = this.localPosition[1] - dArray[1];
            this.localPosition[2] = this.localPosition[2] - dArray[2];
        }
        this.local_quat.set(this.tmpAxis);
        this.tmpAxis.x = this.vfOrientation[0];
        this.tmpAxis.y = this.vfOrientation[1];
        this.tmpAxis.z = this.vfOrientation[2];
        this.tmpAxis.angle = this.vfOrientation[3];
        this.rel_quat.set(this.tmpAxis);
        this.comb_quat.mul(this.local_quat, this.rel_quat);
        this.tmpAxis.set(this.comb_quat);
        this.axis.x = (float)this.tmpAxis.x;
        this.axis.y = (float)this.tmpAxis.y;
        this.axis.z = (float)this.tmpAxis.z;
        this.axis.angle = (float)this.tmpAxis.angle;
        double d = this.axis.x * this.axis.x + this.axis.y * this.axis.y + this.axis.z * this.axis.z;
        if (d != 0.0) {
            d = 1.0 / Math.sqrt(d);
            this.axis.x = (float)((double)this.axis.x * d);
            this.axis.y = (float)((double)this.axis.y * d);
            this.axis.z = (float)((double)this.axis.z * d);
        } else {
            this.axis.x = 0.0f;
            this.axis.y = 1.0f;
            this.axis.z = 0.0f;
        }
        this.axis.angle = (float)Math.IEEEremainder(this.axis.angle, Math.PI * 2);
    }

    protected void fireCenterOfRotationChanged(float[] fArray) {
        int n = this.viewpointListeners.size();
        for (int i = 0; i < n; ++i) {
            ViewpointListener viewpointListener = this.viewpointListeners.get(i);
            viewpointListener.centerOfRotationChanged(fArray);
        }
    }

    protected void fireFieldOfViewChanged(float[] fArray) {
        int n = this.viewpointListeners.size();
        for (int i = 0; i < n; ++i) {
            ViewpointListener viewpointListener = this.viewpointListeners.get(i);
            viewpointListener.fieldOfViewChanged(fArray);
        }
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoOrigin baseGeoOrigin;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        Object object = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType2;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType;
        }
        this.vfGeoOrigin = baseGeoOrigin;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
    }

    static {
        nodeFields = new int[]{0, 12};
        fieldDecl = new VRMLFieldDeclaration[18];
        fieldMap = new HashMap(54);
        BaseGeoViewpoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoViewpoint.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_bind");
        BaseGeoViewpoint.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFTime", "bindTime");
        BaseGeoViewpoint.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isBound");
        BaseGeoViewpoint.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "fieldOfView");
        BaseGeoViewpoint.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFBool", "jump");
        BaseGeoViewpoint.fieldDecl[17] = new VRMLFieldDeclaration(3, "SFBool", "retainUserOffsets");
        BaseGeoViewpoint.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFBool", "headlight");
        BaseGeoViewpoint.fieldDecl[14] = new VRMLFieldDeclaration(2, "SFRotation", "set_orientation");
        BaseGeoViewpoint.fieldDecl[6] = new VRMLFieldDeclaration(1, "SFRotation", "orientation");
        BaseGeoViewpoint.fieldDecl[15] = new VRMLFieldDeclaration(2, "SFVec3d", "position");
        BaseGeoViewpoint.fieldDecl[7] = new VRMLFieldDeclaration(1, "SFVec3d", "set_position");
        BaseGeoViewpoint.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFString", "description");
        BaseGeoViewpoint.fieldDecl[10] = new VRMLFieldDeclaration(3, "MFString", "navType");
        BaseGeoViewpoint.fieldDecl[13] = new VRMLFieldDeclaration(2, "MFString", "geoSystem");
        BaseGeoViewpoint.fieldDecl[12] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        BaseGeoViewpoint.fieldDecl[16] = new VRMLFieldDeclaration(2, "SFFloat", "speedFactor");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("set_bind", new Integer(1));
        fieldMap.put("bindTime", new Integer(2));
        fieldMap.put("isBound", new Integer(3));
        n = new Integer(4);
        fieldMap.put("fieldOfView", n);
        fieldMap.put("set_fieldOfView", n);
        fieldMap.put("fieldOfView_changed", n);
        n = new Integer(5);
        fieldMap.put("jump", n);
        fieldMap.put("set_jump", n);
        fieldMap.put("jump_changed", n);
        n = new Integer(17);
        fieldMap.put("retainUserOffsets", n);
        fieldMap.put("set_retainUserOffsets", n);
        fieldMap.put("retainUserOffsets_changed", n);
        n = new Integer(8);
        fieldMap.put("headlight", n);
        fieldMap.put("set_headlight", n);
        fieldMap.put("headlight_changed", n);
        n = new Integer(11);
        fieldMap.put("description", n);
        fieldMap.put("set_description", n);
        fieldMap.put("description_changed", n);
        n = new Integer(10);
        fieldMap.put("navType", n);
        fieldMap.put("set_navType", n);
        fieldMap.put("navType_changed", n);
        fieldMap.put("geoSystem", new Integer(13));
        fieldMap.put("geoOrigin", new Integer(12));
        fieldMap.put("speedFactor", new Integer(16));
        fieldMap.put("orientation", new Integer(14));
        fieldMap.put("set_orientation", new Integer(6));
        fieldMap.put("position", new Integer(15));
        fieldMap.put("set_position", new Integer(7));
        YUP = new Vector3d(0.0, 1.0, 0.0);
    }
}

