/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.HashMap;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;

public class BaseGeoTransform
extends BaseGroupingNode {
    protected static final int FIELD_GEO_CENTER = 6;
    protected static final int FIELD_ROTATION = 7;
    protected static final int FIELD_SCALE = 8;
    protected static final int FIELD_SCALE_ORIENTATION = 9;
    protected static final int FIELD_TRANSLATION = 10;
    protected static final int FIELD_GEO_ORIGIN = 11;
    protected static final int FIELD_GEO_SYSTEM = 12;
    protected static final int LAST_GEOTRANSFORM_INDEX = 12;
    protected static final int NUM_FIELDS = 13;
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the geoCoord value for some reason.";
    private static final float ZEROEPS = 1.0E-4f;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected double[] vfGeoCenter;
    protected float[] vfRotation;
    protected float[] vfScale;
    protected float[] vfScaleOrientation;
    protected float[] vfTranslation;
    protected String[] vfGeoSystem;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLNodeType vfGeoOrigin;
    protected double[] localCenter;
    private MathTransform geoTransform;
    private boolean geoCoordSwap;
    private Vector3d YUP = new Vector3d(0.0, 1.0, 0.0);
    private Vector3d XUP = new Vector3d(1.0, 0.0, 0.0);
    private Vector3f tempVec;
    private Vector3d tempVec3d;
    private AxisAngle4f tempAxis;
    private Matrix4f tempMtx1;
    private Matrix4f tempMtx2;
    private Quat4d origQuat;
    private Quat4d rotQuat;
    private Matrix4f locMtx = new Matrix4f();
    protected double[] geoOriginCoord;
    protected Matrix4f tmatrix;

    public BaseGeoTransform() {
        super("GeoTransform");
        this.hasChanged = new boolean[13];
        this.vfGeoCenter = new double[3];
        this.vfRotation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfScale = new float[]{1.0f, 1.0f, 1.0f};
        this.vfScaleOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfTranslation = new float[]{0.0f, 0.0f, 0.0f};
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.localCenter = new double[3];
        this.locMtx = new Matrix4f();
        this.tmatrix = new Matrix4f();
        this.tempVec = new Vector3f();
        this.tempVec3d = new Vector3d();
        this.tempAxis = new AxisAngle4f();
        this.tempMtx1 = new Matrix4f();
        this.tempMtx2 = new Matrix4f();
        this.origQuat = new Quat4d();
        this.rotQuat = new Quat4d();
    }

    public BaseGeoTransform(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("geoCenter");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGeoCenter[0] = vRMLFieldData.doubleArrayValue[0];
            this.vfGeoCenter[1] = vRMLFieldData.doubleArrayValue[1];
            this.vfGeoCenter[2] = vRMLFieldData.doubleArrayValue[2];
            n = vRMLNodeType.getFieldIndex("rotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRotation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfRotation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfRotation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfRotation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("scale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScale[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScale[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScale[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("scaleOrientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScaleOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScaleOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScaleOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfScaleOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("translation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTranslation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfTranslation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfTranslation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void allEventsComplete() {
        this.updateMatrix();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 12) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        switch (n) {
            case 6: {
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)12;
                vRMLFieldData.doubleArrayValue = this.vfGeoCenter;
                break;
            }
            case 7: {
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfRotation;
                break;
            }
            case 8: {
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfScale;
                break;
            }
            case 9: {
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfScaleOrientation;
                break;
            }
            case 10: {
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfTranslation;
                break;
            }
            case 11: {
                vRMLFieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 12: {
                vRMLFieldData.numElements = this.vfGeoSystem.length;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.stringArrayValue = this.vfGeoSystem;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
            this.geoOriginCoord = ((BaseGeoOrigin)this.pGeoOrigin).getConvertedCoordRef();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
            this.geoOriginCoord = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
        }
        try {
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            boolean[] blArray = new boolean[1];
            this.geoTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
            this.geoCoordSwap = blArray[0];
            if (this.geoCoordSwap) {
                double d = this.vfGeoCenter[0];
                this.vfGeoCenter[0] = this.vfGeoCenter[1];
                this.vfGeoCenter[1] = d;
                this.geoTransform.transform(this.vfGeoCenter, 0, this.localCenter, 0, 1);
                d = this.vfGeoCenter[0];
                this.vfGeoCenter[0] = this.vfGeoCenter[1];
                this.vfGeoCenter[1] = d;
            } else {
                this.geoTransform.transform(this.vfGeoCenter, 0, this.localCenter, 0, 1);
            }
            if (this.geoOriginCoord != null) {
                this.localCenter[0] = this.localCenter[0] - this.geoOriginCoord[0];
                this.localCenter[1] = this.localCenter[1] - this.geoOriginCoord[1];
                this.localCenter[2] = this.localCenter[2] - this.geoOriginCoord[2];
            }
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfGeoCenter, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfRotation, 4);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfScale, 3);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfScaleOrientation, 4);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfTranslation, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseGeoTransform.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setGeoCenter(dArray);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                this.setRotation(fArray);
                break;
            }
            case 8: {
                this.setScale(fArray);
                break;
            }
            case 9: {
                this.setScaleOrientation(fArray);
                break;
            }
            case 10: {
                this.setTranslation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 12: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 11: {
                this.setGeoOrigin(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setGeoCenter(double[] dArray) throws InvalidFieldValueException {
        if (dArray == null) {
            throw new InvalidFieldValueException("geoCenter value null");
        }
        this.vfGeoCenter[0] = dArray[0];
        this.vfGeoCenter[1] = dArray[1];
        this.vfGeoCenter[2] = dArray[2];
        if (this.inSetup) {
            return;
        }
        if (this.geoTransform != null) {
            try {
                if (this.geoCoordSwap) {
                    double d = this.vfGeoCenter[0];
                    this.vfGeoCenter[0] = this.vfGeoCenter[1];
                    this.vfGeoCenter[1] = d;
                    this.geoTransform.transform(this.vfGeoCenter, 0, this.localCenter, 0, 1);
                    d = this.vfGeoCenter[0];
                    this.vfGeoCenter[0] = this.vfGeoCenter[1];
                    this.vfGeoCenter[1] = d;
                } else {
                    this.geoTransform.transform(this.vfGeoCenter, 0, this.localCenter, 0, 1);
                }
                if (this.geoOriginCoord != null) {
                    this.localCenter[0] = this.localCenter[0] - this.geoOriginCoord[0];
                    this.localCenter[1] = this.localCenter[1] - this.geoOriginCoord[1];
                    this.localCenter[2] = this.localCenter[2] - this.geoOriginCoord[2];
                }
            }
            catch (TransformException transformException) {
                this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
            }
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        this.hasChanged[6] = true;
        this.fireFieldChanged(6);
    }

    protected void setRotation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Rotation value null");
        }
        this.vfRotation[0] = fArray[0];
        this.vfRotation[1] = fArray[1];
        this.vfRotation[2] = fArray[2];
        this.vfRotation[3] = fArray[3];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    protected float[] getRotation() {
        return this.vfRotation;
    }

    protected void setTranslation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Translation value null");
        }
        this.vfTranslation[0] = fArray[0];
        this.vfTranslation[1] = fArray[1];
        this.vfTranslation[2] = fArray[2];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    protected float[] getTranslation() {
        return this.vfTranslation;
    }

    protected void setScale(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale value null");
        }
        this.vfScale[0] = fArray[0];
        this.vfScale[1] = fArray[1];
        this.vfScale[2] = fArray[2];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    protected float[] getScale() {
        return this.vfScale;
    }

    protected void setScaleOrientation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale Orientation value null");
        }
        this.vfScaleOrientation[0] = fArray[0];
        this.vfScaleOrientation[1] = fArray[1];
        this.vfScaleOrientation[2] = fArray[2];
        this.vfScaleOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    protected float[] getScaleOrientation() {
        return this.vfScaleOrientation;
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoOrigin baseGeoOrigin;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        Object object = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType2;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType;
        }
        this.vfGeoOrigin = baseGeoOrigin;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
    }

    private boolean floatEq(float f, float f2) {
        float f3 = f - f2;
        if (f3 < 0.0f) {
            f3 *= -1.0f;
        }
        return f3 < 1.0E-4f;
    }

    protected void updateMatrix() {
        this.getLocalOrientation(this.localCenter, this.locMtx);
        this.tempVec3d.x = -this.localCenter[0];
        this.tempVec3d.y = -this.localCenter[1];
        this.tempVec3d.z = -this.localCenter[2];
        this.tempVec.set((Tuple3d)this.tempVec3d);
        this.tmatrix.setIdentity();
        this.tmatrix.setTranslation(this.tempVec);
        float f = 1.0f;
        if (this.floatEq(this.vfScale[0], this.vfScale[1]) && this.floatEq(this.vfScale[0], this.vfScale[2])) {
            f = this.vfScale[0];
            this.tempMtx1.set(f);
        } else {
            this.tempAxis.x = this.vfScaleOrientation[0];
            this.tempAxis.y = this.vfScaleOrientation[1];
            this.tempAxis.z = this.vfScaleOrientation[2];
            this.tempAxis.angle = -this.vfScaleOrientation[3];
            double d = 1.0 / Math.sqrt(this.tempAxis.x * this.tempAxis.x + this.tempAxis.y * this.tempAxis.y + this.tempAxis.z * this.tempAxis.z);
            this.tempAxis.x = (float)((double)this.tempAxis.x * d);
            this.tempAxis.y = (float)((double)this.tempAxis.y * d);
            this.tempAxis.z = (float)((double)this.tempAxis.z * d);
            this.tempMtx1.set(this.tempAxis);
            this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
            this.tempMtx1.setIdentity();
            this.tempMtx1.m00 = this.vfScale[0];
            this.tempMtx1.m11 = this.vfScale[1];
            this.tempMtx1.m22 = this.vfScale[2];
            this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
            this.tempAxis.x = this.vfScaleOrientation[0];
            this.tempAxis.y = this.vfScaleOrientation[1];
            this.tempAxis.z = this.vfScaleOrientation[2];
            this.tempAxis.angle = this.vfScaleOrientation[3];
            this.tempMtx1.set(this.tempAxis);
        }
        this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
        float f2 = this.vfRotation[0] * this.vfRotation[0] + this.vfRotation[1] * this.vfRotation[1] + this.vfRotation[2] * this.vfRotation[2];
        if (f2 < 1.0E-4f) {
            this.tempAxis.x = 0.0f;
            this.tempAxis.y = 0.0f;
            this.tempAxis.z = 1.0f;
            this.tempAxis.angle = 0.0f;
        } else {
            if ((double)f2 > 1.01 || (double)f2 < 0.99) {
                float f3 = (float)(1.0 / Math.sqrt(f2));
                this.tempAxis.x = this.vfRotation[0] * f3;
                this.tempAxis.y = this.vfRotation[1] * f3;
                this.tempAxis.z = this.vfRotation[2] * f3;
            } else {
                this.tempAxis.x = this.vfRotation[0];
                this.tempAxis.y = this.vfRotation[1];
                this.tempAxis.z = this.vfRotation[2];
            }
            this.tempAxis.angle = this.vfRotation[3];
        }
        this.tempVec.set(this.tempAxis.x, this.tempAxis.y, this.tempAxis.z);
        this.locMtx.transform(this.tempVec);
        this.tempAxis.x = this.tempVec.x;
        this.tempAxis.y = this.tempVec.y;
        this.tempAxis.z = this.tempVec.z;
        this.tempMtx1.set(this.tempAxis);
        this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
        this.tempVec3d.x = this.localCenter[0];
        this.tempVec3d.y = this.localCenter[1];
        this.tempVec3d.z = this.localCenter[2];
        this.tempVec.set((Tuple3d)this.tempVec3d);
        this.tempMtx1.setIdentity();
        this.tempMtx1.setTranslation(this.tempVec);
        this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
        this.tempVec.x = this.vfTranslation[0];
        this.tempVec.y = this.vfTranslation[1];
        this.tempVec.z = this.vfTranslation[2];
        this.locMtx.transform(this.tempVec);
        this.tempMtx1.setIdentity();
        this.tempMtx1.setTranslation(this.tempVec);
        this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
    }

    private void getLocalOrientation(double[] dArray, Matrix4f matrix4f) {
        double d;
        this.tempVec3d.x = dArray[0];
        this.tempVec3d.y = dArray[1];
        this.tempVec3d.z = dArray[2];
        if (this.geoOriginCoord != null) {
            this.tempVec3d.x += this.geoOriginCoord[0];
            this.tempVec3d.y += this.geoOriginCoord[1];
            this.tempVec3d.z += this.geoOriginCoord[2];
        }
        if ((d = this.tempVec3d.x * this.tempVec3d.x + this.tempVec3d.y * this.tempVec3d.y + this.tempVec3d.z * this.tempVec3d.z) != 0.0) {
            d = 1.0 / Math.sqrt(d);
            this.tempVec3d.x *= d;
            this.tempVec3d.y *= d;
            this.tempVec3d.z *= d;
        } else {
            this.tempVec3d.x = 0.0;
            this.tempVec3d.y = 1.0;
            this.tempVec3d.z = 0.0;
        }
        double d2 = this.YUP.angle(this.tempVec3d);
        this.tempVec3d.cross(this.YUP, this.tempVec3d);
        this.tempVec3d.normalize();
        this.tempAxis.x = (float)this.tempVec3d.x;
        this.tempAxis.y = (float)this.tempVec3d.y;
        this.tempAxis.z = (float)this.tempVec3d.z;
        this.tempAxis.angle = (float)d2;
        d2 = this.XUP.angle(this.tempVec3d);
        this.tempVec3d.cross(this.XUP, this.tempVec3d);
        this.tempVec3d.normalize();
        this.origQuat.set(this.tempAxis);
        this.rotQuat.set(new AxisAngle4d(this.tempVec3d.x, this.tempVec3d.y, this.tempVec3d.z, d2));
        this.origQuat.set(this.origQuat.w * this.rotQuat.x + this.origQuat.x * this.rotQuat.w + this.origQuat.y * this.rotQuat.z - this.origQuat.z * this.rotQuat.y, this.origQuat.w * this.rotQuat.y + this.origQuat.y * this.rotQuat.w + this.origQuat.z * this.rotQuat.x - this.origQuat.x * this.rotQuat.z, this.origQuat.w * this.rotQuat.z + this.origQuat.z * this.rotQuat.w + this.origQuat.x * this.rotQuat.y - this.origQuat.y * this.rotQuat.x, this.origQuat.w * this.rotQuat.w - this.origQuat.x * this.rotQuat.x - this.origQuat.y * this.rotQuat.y - this.origQuat.z * this.rotQuat.z);
        matrix4f.set(this.origQuat);
    }

    static {
        nodeFields = new int[]{1, 0, 11};
        fieldDecl = new VRMLFieldDeclaration[13];
        fieldMap = new HashMap(13);
        BaseGeoTransform.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoTransform.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseGeoTransform.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseGeoTransform.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseGeoTransform.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseGeoTransform.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseGeoTransform.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3d", "geoCenter");
        BaseGeoTransform.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFRotation", "rotation");
        BaseGeoTransform.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "scale");
        BaseGeoTransform.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFRotation", "scaleOrientation");
        BaseGeoTransform.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        BaseGeoTransform.fieldDecl[11] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        BaseGeoTransform.fieldDecl[12] = new VRMLFieldDeclaration(2, "MFString", "geoSystem");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("geoCenter", n);
        fieldMap.put("set_geoCenter", n);
        fieldMap.put("geoCenter_changed", n);
        n = new Integer(7);
        fieldMap.put("rotation", n);
        fieldMap.put("set_rotation", n);
        fieldMap.put("rotation_changed", n);
        n = new Integer(8);
        fieldMap.put("scale", n);
        fieldMap.put("set_scale", n);
        fieldMap.put("scale_changed", n);
        n = new Integer(9);
        fieldMap.put("scaleOrientation", n);
        fieldMap.put("set_scaleOrientation", n);
        fieldMap.put("scaleOrientation_changed", n);
        n = new Integer(10);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
        fieldMap.put("geoOrigin", new Integer(11));
        fieldMap.put("geoSystem", new Integer(12));
    }
}

