/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoSRFParametersNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoSRFTParametersNode;

public class BaseGeoSRFTemplate
extends BaseGeoSRFParametersNode {
    protected static final int FIELD_ORM_CODE = 1;
    protected static final int FIELD_SRFT_CODE = 2;
    protected static final int FIELD_SRFT_PARAMETERS = 3;
    protected static final int LAST_PARAMS_INFO_INDEX = 3;
    private static final int NUM_FIELDS = 4;
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap<String, Integer> fieldMap;
    private static final int[] nodeFields;
    private static final String SRFT_PARAMS_PROTO_MSG = "Proto does not describe a X3DGeoSRFTParametersNode object";
    private static final String SRFT_PARAMS_NODE_MSG = "Node does not describe a X3DGeoSRFTParametersNode object";
    protected VRMLNodeType vfSrfParameters;
    protected VRMLProtoInstance pSrfParameters;
    protected int vfSrftCode;
    protected int vfOrmCode;

    public BaseGeoSRFTemplate() {
        super("GeoSRFTemplate");
        this.hasChanged = new boolean[4];
        this.vfOrmCode = 250;
        this.vfSrftCode = 1;
    }

    public BaseGeoSRFTemplate(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("ormCode");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOrmCode = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("srftCode");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSrftCode = vRMLFieldData.intValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pSrfParameters != null) {
            this.pSrfParameters.setupFinished();
        } else if (this.vfSrfParameters != null) {
            this.vfSrfParameters.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return n < 0 || n > 3 ? null : fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfOrmCode;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfSrftCode;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pSrfParameters != null ? this.pSrfParameters : this.vfSrfParameters;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ormCode");
                }
                this.vfOrmCode = n2;
                break;
            }
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: srftCode");
                }
                this.vfSrftCode = n2;
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setSrftParams(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    private void setSrftParams(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoSRFTParametersNode baseGeoSRFTParametersNode;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: srtfParameters");
        }
        Object object = this.pSrfParameters != null ? this.pSrfParameters : this.vfSrfParameters;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseGeoSRFTParametersNode)) {
                throw new InvalidFieldValueException(SRFT_PARAMS_PROTO_MSG);
            }
            baseGeoSRFTParametersNode = (BaseGeoSRFTParametersNode)vRMLNodeType2;
            this.pSrfParameters = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoSRFTParametersNode)) {
                throw new InvalidFieldValueException(SRFT_PARAMS_NODE_MSG);
            }
            this.pSrfParameters = null;
            baseGeoSRFTParametersNode = (BaseGeoSRFTParametersNode)vRMLNodeType;
        }
        this.vfSrfParameters = baseGeoSRFTParametersNode;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
    }

    static {
        nodeFields = new int[]{3, 0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseGeoSRFTemplate.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoSRFTemplate.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFNode", "srtfParameters");
        BaseGeoSRFTemplate.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFInt32", "ormCode");
        BaseGeoSRFTemplate.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFInt32", "srftCode");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("ormCode", new Integer(1));
        fieldMap.put("srftCode", new Integer(2));
        fieldMap.put("srtfParameters", new Integer(3));
    }
}

